<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperationSchedulesType StructType
 * Meta information extracted from the WSDL
 * - documentation: The date range for which the operation schedule information is valid. | Collection of operation schedules.
 * @subpackage Structs
 */
class OperationSchedulesType extends AbstractStructBase
{
    /**
     * The OperationSchedule
     * Meta information extracted from the WSDL
     * - documentation: The OperationSchedule class defines the dates and hours of operation.
     * - maxOccurs: 999
     * @var \StructType\OperationScheduleType[]
     */
    public $OperationSchedule;
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - documentation: The starting value of the time span. | A construct to validate either a date or a time or a dateTime value.
     * - type: DateOrTimeOrDateTimeType
     * - union: date | dateTime | time
     * - use: optional
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - documentation: The duration datatype represents a combination of year, month, day and time values representing a single duration of time, encoded as a single string. | Allows for the specification of a night duration.
     * - type: DurationType
     * - union: duration | NightDurationType
     * - use: optional
     * @var string
     */
    public $Duration;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - documentation: The ending value of the time span. | A construct to validate either a date or a time or a dateTime value.
     * - type: DateOrTimeOrDateTimeType
     * - union: date | dateTime | time
     * - use: optional
     * @var string
     */
    public $End;
    /**
     * Constructor method for OperationSchedulesType
     * @uses OperationSchedulesType::setOperationSchedule()
     * @uses OperationSchedulesType::setStart()
     * @uses OperationSchedulesType::setDuration()
     * @uses OperationSchedulesType::setEnd()
     * @param \StructType\OperationScheduleType[] $operationSchedule
     * @param string $start
     * @param string $duration
     * @param string $end
     */
    public function __construct(array $operationSchedule = array(), $start = null, $duration = null, $end = null)
    {
        $this
            ->setOperationSchedule($operationSchedule)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end);
    }
    /**
     * Get OperationSchedule value
     * @return \StructType\OperationScheduleType[]|null
     */
    public function getOperationSchedule()
    {
        return $this->OperationSchedule;
    }
    /**
     * This method is responsible for validating the values passed to the setOperationSchedule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOperationSchedule method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOperationScheduleForArrayConstraintsFromSetOperationSchedule(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $operationSchedulesTypeOperationScheduleItem) {
            // validation for constraint: itemType
            if (!$operationSchedulesTypeOperationScheduleItem instanceof \StructType\OperationScheduleType) {
                $invalidValues[] = is_object($operationSchedulesTypeOperationScheduleItem) ? get_class($operationSchedulesTypeOperationScheduleItem) : sprintf('%s(%s)', gettype($operationSchedulesTypeOperationScheduleItem), var_export($operationSchedulesTypeOperationScheduleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OperationSchedule property can only contain items of type \StructType\OperationScheduleType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OperationSchedule value
     * @throws \InvalidArgumentException
     * @param \StructType\OperationScheduleType[] $operationSchedule
     * @return \StructType\OperationSchedulesType
     */
    public function setOperationSchedule(array $operationSchedule = array())
    {
        // validation for constraint: array
        if ('' !== ($operationScheduleArrayErrorMessage = self::validateOperationScheduleForArrayConstraintsFromSetOperationSchedule($operationSchedule))) {
            throw new \InvalidArgumentException($operationScheduleArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(999)
        if (is_array($operationSchedule) && count($operationSchedule) > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 999', count($operationSchedule)), __LINE__);
        }
        $this->OperationSchedule = $operationSchedule;
        return $this;
    }
    /**
     * Add item to OperationSchedule value
     * @throws \InvalidArgumentException
     * @param \StructType\OperationScheduleType $item
     * @return \StructType\OperationSchedulesType
     */
    public function addToOperationSchedule(\StructType\OperationScheduleType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OperationScheduleType) {
            throw new \InvalidArgumentException(sprintf('The OperationSchedule property can only contain items of type \StructType\OperationScheduleType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(999)
        if (is_array($this->OperationSchedule) && count($this->OperationSchedule) >= 999) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 999', count($this->OperationSchedule)), __LINE__);
        }
        $this->OperationSchedule[] = $item;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * This method is responsible for validating the value passed to the setStart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStart method
     * This is a set of validation rules based on the union types associated to the property being set by the setStart method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStartForUnionConstraintsFromSetStart($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\OperationSchedulesType
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($startUnionErrorMessage = self::validateStartForUnionConstraintsFromSetStart($start))) {
            throw new \InvalidArgumentException($startUnionErrorMessage, __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * This method is responsible for validating the value passed to the setDuration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDuration method
     * This is a set of validation rules based on the union types associated to the property being set by the setDuration method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDurationForUnionConstraintsFromSetDuration($value)
    {
        $message = '';
        // validation for constraint: pattern(P[0-9]{1,3}N)
        if (!is_null($value) && !preg_match('/P[0-9]{1,3}N/', $value)) {
            $exception0 = new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression P[0-9]{1,3}N', var_export($value, true)), __LINE__);
        }
        if (isset($exception0)) {
            $message = sprintf("The value %s does not match any of the union rules: duration, NightDurationType. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [$exception0])));
        }
        unset($exception0);
        return $message;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\OperationSchedulesType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        // validation for constraint: union(duration, NightDurationType)
        if ('' !== ($durationUnionErrorMessage = self::validateDurationForUnionConstraintsFromSetDuration($duration))) {
            throw new \InvalidArgumentException($durationUnionErrorMessage, __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * This method is responsible for validating the value passed to the setEnd method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEnd method
     * This is a set of validation rules based on the union types associated to the property being set by the setEnd method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEndForUnionConstraintsFromSetEnd($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\OperationSchedulesType
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($endUnionErrorMessage = self::validateEndForUnionConstraintsFromSetEnd($end))) {
            throw new \InvalidArgumentException($endUnionErrorMessage, __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OperationSchedulesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
