<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperationSchedulePlusChargeType StructType
 * Meta information extracted from the WSDL
 * - documentation: This allows a charge to be associated with operating times (e.g. a golf tee time may be more expensive during peak hours v. off peak hours).
 * @subpackage Structs
 */
class OperationSchedulePlusChargeType extends OperationScheduleType
{
    /**
     * The Charge
     * Meta information extracted from the WSDL
     * - documentation: Cost associated with an amenity.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\FeeType[]
     */
    public $Charge;
    /**
     * Constructor method for OperationSchedulePlusChargeType
     * @uses OperationSchedulePlusChargeType::setCharge()
     * @param \StructType\FeeType[] $charge
     */
    public function __construct(array $charge = array())
    {
        $this
            ->setCharge($charge);
    }
    /**
     * Get Charge value
     * @return \StructType\FeeType[]|null
     */
    public function getCharge()
    {
        return $this->Charge;
    }
    /**
     * This method is responsible for validating the values passed to the setCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChargeForArrayConstraintsFromSetCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $operationSchedulePlusChargeTypeChargeItem) {
            // validation for constraint: itemType
            if (!$operationSchedulePlusChargeTypeChargeItem instanceof \StructType\FeeType) {
                $invalidValues[] = is_object($operationSchedulePlusChargeTypeChargeItem) ? get_class($operationSchedulePlusChargeTypeChargeItem) : sprintf('%s(%s)', gettype($operationSchedulePlusChargeTypeChargeItem), var_export($operationSchedulePlusChargeTypeChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Charge property can only contain items of type \StructType\FeeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Charge value
     * @throws \InvalidArgumentException
     * @param \StructType\FeeType[] $charge
     * @return \StructType\OperationSchedulePlusChargeType
     */
    public function setCharge(array $charge = array())
    {
        // validation for constraint: array
        if ('' !== ($chargeArrayErrorMessage = self::validateChargeForArrayConstraintsFromSetCharge($charge))) {
            throw new \InvalidArgumentException($chargeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($charge) && count($charge) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($charge)), __LINE__);
        }
        $this->Charge = $charge;
        return $this;
    }
    /**
     * Add item to Charge value
     * @throws \InvalidArgumentException
     * @param \StructType\FeeType $item
     * @return \StructType\OperationSchedulePlusChargeType
     */
    public function addToCharge(\StructType\FeeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FeeType) {
            throw new \InvalidArgumentException(sprintf('The Charge property can only contain items of type \StructType\FeeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Charge) && count($this->Charge) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Charge)), __LINE__);
        }
        $this->Charge[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OperationSchedulePlusChargeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
