<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Occupancy StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies the age parameters for the occupancy of this guest room type. | Minimum or maximum number of people allowed in a room type as defined by age. | Provides parameters of occupancy limits. | The Occupancy details of a meeting
 * room.
 * @subpackage Structs
 */
class Occupancy extends AbstractStructBase
{
    /**
     * The MinOccupancy
     * Meta information extracted from the WSDL
     * - documentation: The minimum number of people in this meeting room. | Used for Numeric values, from 0 to 99 inclusive.
     * - base: xs:integer
     * - maxInclusive: 99
     * - minInclusive: 0
     * - use: optional
     * @var int
     */
    public $MinOccupancy;
    /**
     * The MaxOccupancy
     * Meta information extracted from the WSDL
     * - documentation: The maximum number of people in this meeting room. | Used for Numeric values, from 1 to 99 inclusive.
     * - base: xs:integer
     * - maxInclusive: 99
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $MaxOccupancy;
    /**
     * The AgeQualifyingCode
     * Meta information extracted from the WSDL
     * - documentation: Defines an age range or age category of a guest (e.g., under 21, over 65, teen, infant). Refer to OpenTravel Code List Age Qualifying Code (AQC). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1,
     * 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $AgeQualifyingCode;
    /**
     * The MinAge
     * Meta information extracted from the WSDL
     * - documentation: MinAge: The minimum age to qualify for AgeQualifyingCode. | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - type: Numeric1to999
     * - use: optional
     * @var int
     */
    public $MinAge;
    /**
     * The MaxAge
     * Meta information extracted from the WSDL
     * - documentation: Max Age: The maximum age to qualify for AgeQualifyingCode. | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - type: Numeric1to999
     * - use: optional
     * @var int
     */
    public $MaxAge;
    /**
     * The AgeTimeUnit
     * Meta information extracted from the WSDL
     * - documentation: TimeUnit : Qualifier for Age.
     * - type: TimeUnitType
     * - use: optional
     * @var string
     */
    public $AgeTimeUnit;
    /**
     * The MinRoomCharge
     * Meta information extracted from the WSDL
     * - documentation: The minimum room charge for this meeting room such as room rental fee.
     * - minOccurs: 0
     * @var \StructType\FeeType
     */
    public $MinRoomCharge;
    /**
     * The StandardOccupancy
     * Meta information extracted from the WSDL
     * - documentation: The standard number of people in this meeting room.
     * - use: optional
     * @var int
     */
    public $StandardOccupancy;
    /**
     * Constructor method for Occupancy
     * @uses Occupancy::setMinOccupancy()
     * @uses Occupancy::setMaxOccupancy()
     * @uses Occupancy::setAgeQualifyingCode()
     * @uses Occupancy::setMinAge()
     * @uses Occupancy::setMaxAge()
     * @uses Occupancy::setAgeTimeUnit()
     * @uses Occupancy::setMinRoomCharge()
     * @uses Occupancy::setStandardOccupancy()
     * @param int $minOccupancy
     * @param int $maxOccupancy
     * @param string $ageQualifyingCode
     * @param int $minAge
     * @param int $maxAge
     * @param string $ageTimeUnit
     * @param \StructType\FeeType $minRoomCharge
     * @param int $standardOccupancy
     */
    public function __construct($minOccupancy = null, $maxOccupancy = null, $ageQualifyingCode = null, $minAge = null, $maxAge = null, $ageTimeUnit = null, \StructType\FeeType $minRoomCharge = null, $standardOccupancy = null)
    {
        $this
            ->setMinOccupancy($minOccupancy)
            ->setMaxOccupancy($maxOccupancy)
            ->setAgeQualifyingCode($ageQualifyingCode)
            ->setMinAge($minAge)
            ->setMaxAge($maxAge)
            ->setAgeTimeUnit($ageTimeUnit)
            ->setMinRoomCharge($minRoomCharge)
            ->setStandardOccupancy($standardOccupancy);
    }
    /**
     * Get MinOccupancy value
     * @return int|null
     */
    public function getMinOccupancy()
    {
        return $this->MinOccupancy;
    }
    /**
     * Set MinOccupancy value
     * @param int $minOccupancy
     * @return \StructType\Occupancy
     */
    public function setMinOccupancy($minOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($minOccupancy) && !(is_int($minOccupancy) || ctype_digit($minOccupancy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minOccupancy, true), gettype($minOccupancy)), __LINE__);
        }
        // validation for constraint: maxInclusive(99)
        if (!is_null($minOccupancy) && $minOccupancy > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99', var_export($minOccupancy, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($minOccupancy) && $minOccupancy < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($minOccupancy, true)), __LINE__);
        }
        $this->MinOccupancy = $minOccupancy;
        return $this;
    }
    /**
     * Get MaxOccupancy value
     * @return int|null
     */
    public function getMaxOccupancy()
    {
        return $this->MaxOccupancy;
    }
    /**
     * Set MaxOccupancy value
     * @param int $maxOccupancy
     * @return \StructType\Occupancy
     */
    public function setMaxOccupancy($maxOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($maxOccupancy) && !(is_int($maxOccupancy) || ctype_digit($maxOccupancy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxOccupancy, true), gettype($maxOccupancy)), __LINE__);
        }
        // validation for constraint: maxInclusive(99)
        if (!is_null($maxOccupancy) && $maxOccupancy > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99', var_export($maxOccupancy, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($maxOccupancy) && $maxOccupancy < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($maxOccupancy, true)), __LINE__);
        }
        $this->MaxOccupancy = $maxOccupancy;
        return $this;
    }
    /**
     * Get AgeQualifyingCode value
     * @return string|null
     */
    public function getAgeQualifyingCode()
    {
        return $this->AgeQualifyingCode;
    }
    /**
     * Set AgeQualifyingCode value
     * @param string $ageQualifyingCode
     * @return \StructType\Occupancy
     */
    public function setAgeQualifyingCode($ageQualifyingCode = null)
    {
        // validation for constraint: string
        if (!is_null($ageQualifyingCode) && !is_string($ageQualifyingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ageQualifyingCode, true), gettype($ageQualifyingCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($ageQualifyingCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $ageQualifyingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($ageQualifyingCode, true)), __LINE__);
        }
        $this->AgeQualifyingCode = $ageQualifyingCode;
        return $this;
    }
    /**
     * Get MinAge value
     * @return int|null
     */
    public function getMinAge()
    {
        return $this->MinAge;
    }
    /**
     * Set MinAge value
     * @param int $minAge
     * @return \StructType\Occupancy
     */
    public function setMinAge($minAge = null)
    {
        // validation for constraint: int
        if (!is_null($minAge) && !(is_int($minAge) || ctype_digit($minAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minAge, true), gettype($minAge)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($minAge) && $minAge > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($minAge, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($minAge) && $minAge < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($minAge, true)), __LINE__);
        }
        $this->MinAge = $minAge;
        return $this;
    }
    /**
     * Get MaxAge value
     * @return int|null
     */
    public function getMaxAge()
    {
        return $this->MaxAge;
    }
    /**
     * Set MaxAge value
     * @param int $maxAge
     * @return \StructType\Occupancy
     */
    public function setMaxAge($maxAge = null)
    {
        // validation for constraint: int
        if (!is_null($maxAge) && !(is_int($maxAge) || ctype_digit($maxAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAge, true), gettype($maxAge)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($maxAge) && $maxAge > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($maxAge, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($maxAge) && $maxAge < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($maxAge, true)), __LINE__);
        }
        $this->MaxAge = $maxAge;
        return $this;
    }
    /**
     * Get AgeTimeUnit value
     * @return string|null
     */
    public function getAgeTimeUnit()
    {
        return $this->AgeTimeUnit;
    }
    /**
     * Set AgeTimeUnit value
     * @uses \EnumType\TimeUnitType::valueIsValid()
     * @uses \EnumType\TimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ageTimeUnit
     * @return \StructType\Occupancy
     */
    public function setAgeTimeUnit($ageTimeUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TimeUnitType::valueIsValid($ageTimeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TimeUnitType', is_array($ageTimeUnit) ? implode(', ', $ageTimeUnit) : var_export($ageTimeUnit, true), implode(', ', \EnumType\TimeUnitType::getValidValues())), __LINE__);
        }
        $this->AgeTimeUnit = $ageTimeUnit;
        return $this;
    }
    /**
     * Get MinRoomCharge value
     * @return \StructType\FeeType|null
     */
    public function getMinRoomCharge()
    {
        return $this->MinRoomCharge;
    }
    /**
     * Set MinRoomCharge value
     * @param \StructType\FeeType $minRoomCharge
     * @return \StructType\Occupancy
     */
    public function setMinRoomCharge(\StructType\FeeType $minRoomCharge = null)
    {
        $this->MinRoomCharge = $minRoomCharge;
        return $this;
    }
    /**
     * Get StandardOccupancy value
     * @return int|null
     */
    public function getStandardOccupancy()
    {
        return $this->StandardOccupancy;
    }
    /**
     * Set StandardOccupancy value
     * @param int $standardOccupancy
     * @return \StructType\Occupancy
     */
    public function setStandardOccupancy($standardOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($standardOccupancy) && !(is_int($standardOccupancy) || ctype_digit($standardOccupancy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($standardOccupancy, true), gettype($standardOccupancy)), __LINE__);
        }
        $this->StandardOccupancy = $standardOccupancy;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Occupancy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
