<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NegotiatedFareCode StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains code information for a negotiated fare. | Contains negotiated fare code information.
 * - type: xs:string
 * - use: optional
 * @subpackage Structs
 */
class NegotiatedFareCode extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The TicketDesignatorCode
     * Meta information extracted from the WSDL
     * - documentation: The ticket designator code for this negotiated fare code. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $TicketDesignatorCode;
    /**
     * The OverrideRuleInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the rules for the negotiated fare should not be applied.
     * - use: optional
     * @var bool
     */
    public $OverrideRuleInd;
    /**
     * The SecondaryCode
     * Meta information extracted from the WSDL
     * - documentation: An additional attribute to allow flexibility for particular organizations who require an additional code. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $SecondaryCode;
    /**
     * The SupplierCode
     * Meta information extracted from the WSDL
     * - documentation: An additional attribute to allow flexibility for particular organizations who require an additional supplier code. | Used for an Alpha String, length 1 to 3 (for letter codes).
     * - base: xs:string
     * - pattern: [A-Z]{1,3}
     * - type: UpperCaseAlphaLength1to3
     * - use: optional
     * @var string
     */
    public $SupplierCode;
    /**
     * The URI
     * @var string
     */
    public $URI;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $Code;
    /**
     * The CodeContext
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $CodeContext;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * Constructor method for NegotiatedFareCode
     * @uses NegotiatedFareCode::set_()
     * @uses NegotiatedFareCode::setTicketDesignatorCode()
     * @uses NegotiatedFareCode::setOverrideRuleInd()
     * @uses NegotiatedFareCode::setSecondaryCode()
     * @uses NegotiatedFareCode::setSupplierCode()
     * @uses NegotiatedFareCode::setURI()
     * @uses NegotiatedFareCode::setCode()
     * @uses NegotiatedFareCode::setCodeContext()
     * @uses NegotiatedFareCode::setQuantity()
     * @param string $_
     * @param string $ticketDesignatorCode
     * @param bool $overrideRuleInd
     * @param string $secondaryCode
     * @param string $supplierCode
     * @param string $uRI
     * @param string $code
     * @param string $codeContext
     * @param int $quantity
     */
    public function __construct($_ = null, $ticketDesignatorCode = null, $overrideRuleInd = null, $secondaryCode = null, $supplierCode = null, $uRI = null, $code = null, $codeContext = null, $quantity = null)
    {
        $this
            ->set_($_)
            ->setTicketDesignatorCode($ticketDesignatorCode)
            ->setOverrideRuleInd($overrideRuleInd)
            ->setSecondaryCode($secondaryCode)
            ->setSupplierCode($supplierCode)
            ->setURI($uRI)
            ->setCode($code)
            ->setCodeContext($codeContext)
            ->setQuantity($quantity);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\NegotiatedFareCode
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get TicketDesignatorCode value
     * @return string|null
     */
    public function getTicketDesignatorCode()
    {
        return $this->TicketDesignatorCode;
    }
    /**
     * Set TicketDesignatorCode value
     * @param string $ticketDesignatorCode
     * @return \StructType\NegotiatedFareCode
     */
    public function setTicketDesignatorCode($ticketDesignatorCode = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDesignatorCode) && !is_string($ticketDesignatorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketDesignatorCode, true), gettype($ticketDesignatorCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($ticketDesignatorCode) && mb_strlen($ticketDesignatorCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($ticketDesignatorCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ticketDesignatorCode) && mb_strlen($ticketDesignatorCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ticketDesignatorCode)), __LINE__);
        }
        $this->TicketDesignatorCode = $ticketDesignatorCode;
        return $this;
    }
    /**
     * Get OverrideRuleInd value
     * @return bool|null
     */
    public function getOverrideRuleInd()
    {
        return $this->OverrideRuleInd;
    }
    /**
     * Set OverrideRuleInd value
     * @param bool $overrideRuleInd
     * @return \StructType\NegotiatedFareCode
     */
    public function setOverrideRuleInd($overrideRuleInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($overrideRuleInd) && !is_bool($overrideRuleInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($overrideRuleInd, true), gettype($overrideRuleInd)), __LINE__);
        }
        $this->OverrideRuleInd = $overrideRuleInd;
        return $this;
    }
    /**
     * Get SecondaryCode value
     * @return string|null
     */
    public function getSecondaryCode()
    {
        return $this->SecondaryCode;
    }
    /**
     * Set SecondaryCode value
     * @param string $secondaryCode
     * @return \StructType\NegotiatedFareCode
     */
    public function setSecondaryCode($secondaryCode = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryCode) && !is_string($secondaryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondaryCode, true), gettype($secondaryCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($secondaryCode) && mb_strlen($secondaryCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($secondaryCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($secondaryCode) && mb_strlen($secondaryCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($secondaryCode)), __LINE__);
        }
        $this->SecondaryCode = $secondaryCode;
        return $this;
    }
    /**
     * Get SupplierCode value
     * @return string|null
     */
    public function getSupplierCode()
    {
        return $this->SupplierCode;
    }
    /**
     * Set SupplierCode value
     * @param string $supplierCode
     * @return \StructType\NegotiatedFareCode
     */
    public function setSupplierCode($supplierCode = null)
    {
        // validation for constraint: string
        if (!is_null($supplierCode) && !is_string($supplierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierCode, true), gettype($supplierCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{1,3})
        if (!is_null($supplierCode) && !preg_match('/[A-Z]{1,3}/', $supplierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{1,3}', var_export($supplierCode, true)), __LINE__);
        }
        $this->SupplierCode = $supplierCode;
        return $this;
    }
    /**
     * Get URI value
     * @return string|null
     */
    public function getURI()
    {
        return $this->URI;
    }
    /**
     * Set URI value
     * @param string $uRI
     * @return \StructType\NegotiatedFareCode
     */
    public function setURI($uRI = null)
    {
        // validation for constraint: string
        if (!is_null($uRI) && !is_string($uRI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRI, true), gettype($uRI)), __LINE__);
        }
        $this->URI = $uRI;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\NegotiatedFareCode
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($code) && mb_strlen($code) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($code)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($code) && mb_strlen($code) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get CodeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->CodeContext;
    }
    /**
     * Set CodeContext value
     * @param string $codeContext
     * @return \StructType\NegotiatedFareCode
     */
    public function setCodeContext($codeContext = null)
    {
        // validation for constraint: string
        if (!is_null($codeContext) && !is_string($codeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeContext, true), gettype($codeContext)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($codeContext) && mb_strlen($codeContext) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($codeContext)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($codeContext) && mb_strlen($codeContext) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($codeContext)), __LINE__);
        }
        $this->CodeContext = $codeContext;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\NegotiatedFareCode
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NegotiatedFareCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
