<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MultimediaDescriptions StructType
 * Meta information extracted from the WSDL
 * - documentation: Multimedia information about the restaurant.
 * @subpackage Structs
 */
class MultimediaDescriptions extends MultimediaDescriptionsType
{
    /**
     * The Attire
     * Meta information extracted from the WSDL
     * - documentation: Used to pass restaurant attire information. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $Attire;
    /**
     * Constructor method for MultimediaDescriptions
     * @uses MultimediaDescriptions::setAttire()
     * @param string $attire
     */
    public function __construct($attire = null)
    {
        $this
            ->setAttire($attire);
    }
    /**
     * Get Attire value
     * @return string|null
     */
    public function getAttire()
    {
        return $this->Attire;
    }
    /**
     * Set Attire value
     * @param string $attire
     * @return \StructType\MultimediaDescriptions
     */
    public function setAttire($attire = null)
    {
        // validation for constraint: string
        if (!is_null($attire) && !is_string($attire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attire, true), gettype($attire)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($attire) && mb_strlen($attire) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($attire)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($attire) && mb_strlen($attire) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($attire)), __LINE__);
        }
        $this->Attire = $attire;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MultimediaDescriptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
