<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MiscChargeOrder StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides information about the original document on which the reissue is based | Details of a miscellaneous charge order (MCO).
 * @subpackage Structs
 */
class MiscChargeOrder extends AbstractStructBase
{
    /**
     * The TicketNumber
     * Meta information extracted from the WSDL
     * - documentation: The ticket number of the miscellaneous charge order (MCO). | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $TicketNumber;
    /**
     * The PaperMCO_ExistInd
     * Meta information extracted from the WSDL
     * - documentation: Indicates if a paper or electronic MCO exists.
     * - use: optional
     * @var bool
     */
    public $PaperMCO_ExistInd;
    /**
     * The OriginalTicketNumber
     * Meta information extracted from the WSDL
     * - documentation: The original ticket number in a series if reissuances. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $OriginalTicketNumber;
    /**
     * The OriginalIssuePlace
     * Meta information extracted from the WSDL
     * - documentation: Place where the original ticket was issued. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - type: StringLength1to8
     * - use: optional
     * @var string
     */
    public $OriginalIssuePlace;
    /**
     * The OriginalIssueDate
     * Meta information extracted from the WSDL
     * - documentation: Date when the original ticket was issued.
     * - type: xs:date
     * - use: optional
     * @var string
     */
    public $OriginalIssueDate;
    /**
     * The OriginalIssueIATA
     * Meta information extracted from the WSDL
     * - documentation: IATA office number, which issued original ticket. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - type: StringLength1to8
     * - use: optional
     * @var string
     */
    public $OriginalIssueIATA;
    /**
     * The OriginalPaymentForm
     * Meta information extracted from the WSDL
     * - documentation: Payment type for the original ticket. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $OriginalPaymentForm;
    /**
     * The CheckInhibitorType
     * @var string
     */
    public $CheckInhibitorType;
    /**
     * The CouponRPHs
     * Meta information extracted from the WSDL
     * - documentation: Gives a list of references to coupon numbers of the ticket which will be taken for payment. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign
     * individual passengers or clients to particular itinerary items). | List of Reference Place Holders.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - type: ListOfRPH
     * - use: optional
     * @var string[]
     */
    public $CouponRPHs;
    /**
     * Constructor method for MiscChargeOrder
     * @uses MiscChargeOrder::setTicketNumber()
     * @uses MiscChargeOrder::setPaperMCO_ExistInd()
     * @uses MiscChargeOrder::setOriginalTicketNumber()
     * @uses MiscChargeOrder::setOriginalIssuePlace()
     * @uses MiscChargeOrder::setOriginalIssueDate()
     * @uses MiscChargeOrder::setOriginalIssueIATA()
     * @uses MiscChargeOrder::setOriginalPaymentForm()
     * @uses MiscChargeOrder::setCheckInhibitorType()
     * @uses MiscChargeOrder::setCouponRPHs()
     * @param string $ticketNumber
     * @param bool $paperMCO_ExistInd
     * @param string $originalTicketNumber
     * @param string $originalIssuePlace
     * @param string $originalIssueDate
     * @param string $originalIssueIATA
     * @param string $originalPaymentForm
     * @param string $checkInhibitorType
     * @param string[] $couponRPHs
     */
    public function __construct($ticketNumber = null, $paperMCO_ExistInd = null, $originalTicketNumber = null, $originalIssuePlace = null, $originalIssueDate = null, $originalIssueIATA = null, $originalPaymentForm = null, $checkInhibitorType = null, array $couponRPHs = array())
    {
        $this
            ->setTicketNumber($ticketNumber)
            ->setPaperMCO_ExistInd($paperMCO_ExistInd)
            ->setOriginalTicketNumber($originalTicketNumber)
            ->setOriginalIssuePlace($originalIssuePlace)
            ->setOriginalIssueDate($originalIssueDate)
            ->setOriginalIssueIATA($originalIssueIATA)
            ->setOriginalPaymentForm($originalPaymentForm)
            ->setCheckInhibitorType($checkInhibitorType)
            ->setCouponRPHs($couponRPHs);
    }
    /**
     * Get TicketNumber value
     * @return string|null
     */
    public function getTicketNumber()
    {
        return $this->TicketNumber;
    }
    /**
     * Set TicketNumber value
     * @param string $ticketNumber
     * @return \StructType\MiscChargeOrder
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ticketNumber) && !is_string($ticketNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketNumber, true), gettype($ticketNumber)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($ticketNumber) && mb_strlen($ticketNumber) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($ticketNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ticketNumber) && mb_strlen($ticketNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ticketNumber)), __LINE__);
        }
        $this->TicketNumber = $ticketNumber;
        return $this;
    }
    /**
     * Get PaperMCO_ExistInd value
     * @return bool|null
     */
    public function getPaperMCO_ExistInd()
    {
        return $this->PaperMCO_ExistInd;
    }
    /**
     * Set PaperMCO_ExistInd value
     * @param bool $paperMCO_ExistInd
     * @return \StructType\MiscChargeOrder
     */
    public function setPaperMCO_ExistInd($paperMCO_ExistInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($paperMCO_ExistInd) && !is_bool($paperMCO_ExistInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($paperMCO_ExistInd, true), gettype($paperMCO_ExistInd)), __LINE__);
        }
        $this->PaperMCO_ExistInd = $paperMCO_ExistInd;
        return $this;
    }
    /**
     * Get OriginalTicketNumber value
     * @return string|null
     */
    public function getOriginalTicketNumber()
    {
        return $this->OriginalTicketNumber;
    }
    /**
     * Set OriginalTicketNumber value
     * @param string $originalTicketNumber
     * @return \StructType\MiscChargeOrder
     */
    public function setOriginalTicketNumber($originalTicketNumber = null)
    {
        // validation for constraint: string
        if (!is_null($originalTicketNumber) && !is_string($originalTicketNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalTicketNumber, true), gettype($originalTicketNumber)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($originalTicketNumber) && mb_strlen($originalTicketNumber) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($originalTicketNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($originalTicketNumber) && mb_strlen($originalTicketNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($originalTicketNumber)), __LINE__);
        }
        $this->OriginalTicketNumber = $originalTicketNumber;
        return $this;
    }
    /**
     * Get OriginalIssuePlace value
     * @return string|null
     */
    public function getOriginalIssuePlace()
    {
        return $this->OriginalIssuePlace;
    }
    /**
     * Set OriginalIssuePlace value
     * @param string $originalIssuePlace
     * @return \StructType\MiscChargeOrder
     */
    public function setOriginalIssuePlace($originalIssuePlace = null)
    {
        // validation for constraint: string
        if (!is_null($originalIssuePlace) && !is_string($originalIssuePlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalIssuePlace, true), gettype($originalIssuePlace)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($originalIssuePlace) && mb_strlen($originalIssuePlace) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($originalIssuePlace)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($originalIssuePlace) && mb_strlen($originalIssuePlace) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($originalIssuePlace)), __LINE__);
        }
        $this->OriginalIssuePlace = $originalIssuePlace;
        return $this;
    }
    /**
     * Get OriginalIssueDate value
     * @return string|null
     */
    public function getOriginalIssueDate()
    {
        return $this->OriginalIssueDate;
    }
    /**
     * Set OriginalIssueDate value
     * @param string $originalIssueDate
     * @return \StructType\MiscChargeOrder
     */
    public function setOriginalIssueDate($originalIssueDate = null)
    {
        // validation for constraint: string
        if (!is_null($originalIssueDate) && !is_string($originalIssueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalIssueDate, true), gettype($originalIssueDate)), __LINE__);
        }
        $this->OriginalIssueDate = $originalIssueDate;
        return $this;
    }
    /**
     * Get OriginalIssueIATA value
     * @return string|null
     */
    public function getOriginalIssueIATA()
    {
        return $this->OriginalIssueIATA;
    }
    /**
     * Set OriginalIssueIATA value
     * @param string $originalIssueIATA
     * @return \StructType\MiscChargeOrder
     */
    public function setOriginalIssueIATA($originalIssueIATA = null)
    {
        // validation for constraint: string
        if (!is_null($originalIssueIATA) && !is_string($originalIssueIATA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalIssueIATA, true), gettype($originalIssueIATA)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($originalIssueIATA) && mb_strlen($originalIssueIATA) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($originalIssueIATA)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($originalIssueIATA) && mb_strlen($originalIssueIATA) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($originalIssueIATA)), __LINE__);
        }
        $this->OriginalIssueIATA = $originalIssueIATA;
        return $this;
    }
    /**
     * Get OriginalPaymentForm value
     * @return string|null
     */
    public function getOriginalPaymentForm()
    {
        return $this->OriginalPaymentForm;
    }
    /**
     * Set OriginalPaymentForm value
     * @param string $originalPaymentForm
     * @return \StructType\MiscChargeOrder
     */
    public function setOriginalPaymentForm($originalPaymentForm = null)
    {
        // validation for constraint: string
        if (!is_null($originalPaymentForm) && !is_string($originalPaymentForm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalPaymentForm, true), gettype($originalPaymentForm)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($originalPaymentForm) && mb_strlen($originalPaymentForm) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($originalPaymentForm)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($originalPaymentForm) && mb_strlen($originalPaymentForm) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($originalPaymentForm)), __LINE__);
        }
        $this->OriginalPaymentForm = $originalPaymentForm;
        return $this;
    }
    /**
     * Get CheckInhibitorType value
     * @return string|null
     */
    public function getCheckInhibitorType()
    {
        return $this->CheckInhibitorType;
    }
    /**
     * Set CheckInhibitorType value
     * @param string $checkInhibitorType
     * @return \StructType\MiscChargeOrder
     */
    public function setCheckInhibitorType($checkInhibitorType = null)
    {
        // validation for constraint: string
        if (!is_null($checkInhibitorType) && !is_string($checkInhibitorType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkInhibitorType, true), gettype($checkInhibitorType)), __LINE__);
        }
        $this->CheckInhibitorType = $checkInhibitorType;
        return $this;
    }
    /**
     * Get CouponRPHs value
     * @return string[]|null
     */
    public function getCouponRPHs()
    {
        return $this->CouponRPHs;
    }
    /**
     * This method is responsible for validating the values passed to the setCouponRPHs method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCouponRPHs method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCouponRPHsForArrayConstraintsFromSetCouponRPHs(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $miscChargeOrderCouponRPHsItem) {
            // validation for constraint: itemType
            if (!is_string($miscChargeOrderCouponRPHsItem)) {
                $invalidValues[] = is_object($miscChargeOrderCouponRPHsItem) ? get_class($miscChargeOrderCouponRPHsItem) : sprintf('%s(%s)', gettype($miscChargeOrderCouponRPHsItem), var_export($miscChargeOrderCouponRPHsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CouponRPHs property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CouponRPHs value
     * @param string[] $couponRPHs
     * @return \StructType\MiscChargeOrder
     */
    public function setCouponRPHs(array $couponRPHs = array())
    {
        // validation for constraint: list
        if ('' !== ($couponRPHsArrayErrorMessage = self::validateCouponRPHsForArrayConstraintsFromSetCouponRPHs($couponRPHs))) {
            throw new \InvalidArgumentException($couponRPHsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($couponRPHs) && !preg_match('/[0-9]{1,8}/', $couponRPHs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($couponRPHs, true)), __LINE__);
        }
        $this->CouponRPHs = is_array($couponRPHs) ? implode(' ', $couponRPHs) : null;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MiscChargeOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
