<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MinimumStay StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies restrictions for the shortest length/period of time or earliest day return travel can commence or be completed.
 * @subpackage Structs
 */
class MinimumStay extends AbstractStructBase
{
    /**
     * The ReturnTimeOfDay
     * Meta information extracted from the WSDL
     * - documentation: The time of day when return travel may commence. | Allows for the specification of a date time or just time.
     * - union: dateTime | time
     * - use: optional
     * @var string
     */
    public $ReturnTimeOfDay;
    /**
     * The MinStay
     * Meta information extracted from the WSDL
     * - documentation: The amount of elapsed time or number of occurrences of a day of the week needed to satisfy a minimum stay requirement. | Used for Numeric values, from 1 to 99 inclusive.
     * - base: xs:integer
     * - maxInclusive: 99
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $MinStay;
    /**
     * The StayUnit
     * Meta information extracted from the WSDL
     * - documentation: The unit of elapsed time or the day of the week applied to the MinStay value.
     * - use: optional
     * @var string
     */
    public $StayUnit;
    /**
     * The MinStayDate
     * Meta information extracted from the WSDL
     * - documentation: The specific date for the minimum stay requirement. | Allows for the specification of a date time or just time.
     * - union: dateTime | time
     * - use: optional
     * @var string
     */
    public $MinStayDate;
    /**
     * The ComplicatedRulesInd
     * Meta information extracted from the WSDL
     * - documentation: If true, there are complicated rules for the minimum stay requirement.
     * - use: optional
     * @var bool
     */
    public $ComplicatedRulesInd;
    /**
     * Constructor method for MinimumStay
     * @uses MinimumStay::setReturnTimeOfDay()
     * @uses MinimumStay::setMinStay()
     * @uses MinimumStay::setStayUnit()
     * @uses MinimumStay::setMinStayDate()
     * @uses MinimumStay::setComplicatedRulesInd()
     * @param string $returnTimeOfDay
     * @param int $minStay
     * @param string $stayUnit
     * @param string $minStayDate
     * @param bool $complicatedRulesInd
     */
    public function __construct($returnTimeOfDay = null, $minStay = null, $stayUnit = null, $minStayDate = null, $complicatedRulesInd = null)
    {
        $this
            ->setReturnTimeOfDay($returnTimeOfDay)
            ->setMinStay($minStay)
            ->setStayUnit($stayUnit)
            ->setMinStayDate($minStayDate)
            ->setComplicatedRulesInd($complicatedRulesInd);
    }
    /**
     * Get ReturnTimeOfDay value
     * @return string|null
     */
    public function getReturnTimeOfDay()
    {
        return $this->ReturnTimeOfDay;
    }
    /**
     * This method is responsible for validating the value passed to the setReturnTimeOfDay method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturnTimeOfDay method
     * This is a set of validation rules based on the union types associated to the property being set by the setReturnTimeOfDay method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReturnTimeOfDayForUnionConstraintsFromSetReturnTimeOfDay($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set ReturnTimeOfDay value
     * @param string $returnTimeOfDay
     * @return \StructType\MinimumStay
     */
    public function setReturnTimeOfDay($returnTimeOfDay = null)
    {
        // validation for constraint: string
        if (!is_null($returnTimeOfDay) && !is_string($returnTimeOfDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnTimeOfDay, true), gettype($returnTimeOfDay)), __LINE__);
        }
        // validation for constraint: union(dateTime, time)
        if ('' !== ($returnTimeOfDayUnionErrorMessage = self::validateReturnTimeOfDayForUnionConstraintsFromSetReturnTimeOfDay($returnTimeOfDay))) {
            throw new \InvalidArgumentException($returnTimeOfDayUnionErrorMessage, __LINE__);
        }
        $this->ReturnTimeOfDay = $returnTimeOfDay;
        return $this;
    }
    /**
     * Get MinStay value
     * @return int|null
     */
    public function getMinStay()
    {
        return $this->MinStay;
    }
    /**
     * Set MinStay value
     * @param int $minStay
     * @return \StructType\MinimumStay
     */
    public function setMinStay($minStay = null)
    {
        // validation for constraint: int
        if (!is_null($minStay) && !(is_int($minStay) || ctype_digit($minStay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minStay, true), gettype($minStay)), __LINE__);
        }
        // validation for constraint: maxInclusive(99)
        if (!is_null($minStay) && $minStay > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99', var_export($minStay, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($minStay) && $minStay < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($minStay, true)), __LINE__);
        }
        $this->MinStay = $minStay;
        return $this;
    }
    /**
     * Get StayUnit value
     * @return string|null
     */
    public function getStayUnit()
    {
        return $this->StayUnit;
    }
    /**
     * Set StayUnit value
     * @uses \EnumType\StayUnitType::valueIsValid()
     * @uses \EnumType\StayUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stayUnit
     * @return \StructType\MinimumStay
     */
    public function setStayUnit($stayUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StayUnitType::valueIsValid($stayUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\StayUnitType', is_array($stayUnit) ? implode(', ', $stayUnit) : var_export($stayUnit, true), implode(', ', \EnumType\StayUnitType::getValidValues())), __LINE__);
        }
        $this->StayUnit = $stayUnit;
        return $this;
    }
    /**
     * Get MinStayDate value
     * @return string|null
     */
    public function getMinStayDate()
    {
        return $this->MinStayDate;
    }
    /**
     * This method is responsible for validating the value passed to the setMinStayDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMinStayDate method
     * This is a set of validation rules based on the union types associated to the property being set by the setMinStayDate method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMinStayDateForUnionConstraintsFromSetMinStayDate($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set MinStayDate value
     * @param string $minStayDate
     * @return \StructType\MinimumStay
     */
    public function setMinStayDate($minStayDate = null)
    {
        // validation for constraint: string
        if (!is_null($minStayDate) && !is_string($minStayDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minStayDate, true), gettype($minStayDate)), __LINE__);
        }
        // validation for constraint: union(dateTime, time)
        if ('' !== ($minStayDateUnionErrorMessage = self::validateMinStayDateForUnionConstraintsFromSetMinStayDate($minStayDate))) {
            throw new \InvalidArgumentException($minStayDateUnionErrorMessage, __LINE__);
        }
        $this->MinStayDate = $minStayDate;
        return $this;
    }
    /**
     * Get ComplicatedRulesInd value
     * @return bool|null
     */
    public function getComplicatedRulesInd()
    {
        return $this->ComplicatedRulesInd;
    }
    /**
     * Set ComplicatedRulesInd value
     * @param bool $complicatedRulesInd
     * @return \StructType\MinimumStay
     */
    public function setComplicatedRulesInd($complicatedRulesInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($complicatedRulesInd) && !is_bool($complicatedRulesInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($complicatedRulesInd, true), gettype($complicatedRulesInd)), __LINE__);
        }
        $this->ComplicatedRulesInd = $complicatedRulesInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MinimumStay
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
