<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MethodInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: This is used to indicate the reservation and billing methods for a single inventory block. | This is used to indicate the reservation and billing methods for the rate plan.
 * @subpackage Structs
 */
class MethodInfo extends AbstractStructBase
{
    /**
     * The ReservationMethodCode
     * Meta information extracted from the WSDL
     * - documentation: This is used to indicate the method by which reservations are to be received. Refer to OpenTravel Code List Reservation Method Code (RMC). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101,
     * 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $ReservationMethodCode;
    /**
     * The BillingType
     * @var string
     */
    public $BillingType;
    /**
     * The SignFoodAndBev
     * Meta information extracted from the WSDL
     * - documentation: false | Food and beverage billed to master account. If false, guest pays own.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $SignFoodAndBev;
    /**
     * Constructor method for MethodInfo
     * @uses MethodInfo::setReservationMethodCode()
     * @uses MethodInfo::setBillingType()
     * @uses MethodInfo::setSignFoodAndBev()
     * @param string $reservationMethodCode
     * @param string $billingType
     * @param bool $signFoodAndBev
     */
    public function __construct($reservationMethodCode = null, $billingType = null, $signFoodAndBev = null)
    {
        $this
            ->setReservationMethodCode($reservationMethodCode)
            ->setBillingType($billingType)
            ->setSignFoodAndBev($signFoodAndBev);
    }
    /**
     * Get ReservationMethodCode value
     * @return string|null
     */
    public function getReservationMethodCode()
    {
        return $this->ReservationMethodCode;
    }
    /**
     * Set ReservationMethodCode value
     * @param string $reservationMethodCode
     * @return \StructType\MethodInfo
     */
    public function setReservationMethodCode($reservationMethodCode = null)
    {
        // validation for constraint: string
        if (!is_null($reservationMethodCode) && !is_string($reservationMethodCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationMethodCode, true), gettype($reservationMethodCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($reservationMethodCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $reservationMethodCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($reservationMethodCode, true)), __LINE__);
        }
        $this->ReservationMethodCode = $reservationMethodCode;
        return $this;
    }
    /**
     * Get BillingType value
     * @return string|null
     */
    public function getBillingType()
    {
        return $this->BillingType;
    }
    /**
     * Set BillingType value
     * @param string $billingType
     * @return \StructType\MethodInfo
     */
    public function setBillingType($billingType = null)
    {
        // validation for constraint: string
        if (!is_null($billingType) && !is_string($billingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingType, true), gettype($billingType)), __LINE__);
        }
        $this->BillingType = $billingType;
        return $this;
    }
    /**
     * Get SignFoodAndBev value
     * @return bool|null
     */
    public function getSignFoodAndBev()
    {
        return $this->SignFoodAndBev;
    }
    /**
     * Set SignFoodAndBev value
     * @param bool $signFoodAndBev
     * @return \StructType\MethodInfo
     */
    public function setSignFoodAndBev($signFoodAndBev = null)
    {
        // validation for constraint: boolean
        if (!is_null($signFoodAndBev) && !is_bool($signFoodAndBev)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($signFoodAndBev, true), gettype($signFoodAndBev)), __LINE__);
        }
        $this->SignFoodAndBev = $signFoodAndBev;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MethodInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
