<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageType StructType
 * Meta information extracted from the WSDL
 * - documentation: If StartSeqNmbr and EndSeqNmbr are not sent, the request will be assumed to be for the last sequence number.
 * @subpackage Structs
 */
class MessageType extends AbstractStructBase
{
    /**
     * The OriginalPayloadStdAttributes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OriginalPayloadStdAttributes
     */
    public $OriginalPayloadStdAttributes;
    /**
     * The MessageContent
     * Meta information extracted from the WSDL
     * - documentation: This container is designed to store the response message.
     * - minOccurs: 0
     * @var string
     */
    public $MessageContent;
    /**
     * The StartSeqNmbr
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $StartSeqNmbr;
    /**
     * The EndSeqNmbr
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $EndSeqNmbr;
    /**
     * The MessageType
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $MessageType;
    /**
     * The ResponseValue
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $ResponseValue;
    /**
     * The RequestCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $RequestCode;
    /**
     * The ReasonForRequest
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ReasonForRequest;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $UserName;
    /**
     * The RatePlanCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $RatePlanCode;
    /**
     * The ConfirmationID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ConfirmationID;
    /**
     * The ReservationID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ReservationID;
    /**
     * The ChainCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $ChainCode;
    /**
     * The BrandCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $BrandCode;
    /**
     * The HotelCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $HotelCode;
    /**
     * The HotelCityCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $HotelCityCode;
    /**
     * The HotelName
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 128.
     * - base: xs:string
     * - maxLength: 128
     * - minLength: 1
     * @var string
     */
    public $HotelName;
    /**
     * The HotelCodeContext
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $HotelCodeContext;
    /**
     * The ChainName
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $ChainName;
    /**
     * The BrandName
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $BrandName;
    /**
     * The AreaID
     * Meta information extracted from the WSDL
     * - documentation: Used for Numeric Strings, length 1 to 8.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * @var string
     */
    public $AreaID;
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a time or a dateTime value.
     * - union: date | dateTime | time
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - documentation: Allows for the specification of a night duration.
     * - union: duration | NightDurationType
     * @var string
     */
    public $Duration;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a time or a dateTime value.
     * - union: date | dateTime | time
     * @var string
     */
    public $End;
    /**
     * Constructor method for MessageType
     * @uses MessageType::setOriginalPayloadStdAttributes()
     * @uses MessageType::setMessageContent()
     * @uses MessageType::setStartSeqNmbr()
     * @uses MessageType::setEndSeqNmbr()
     * @uses MessageType::setMessageType()
     * @uses MessageType::setResponseValue()
     * @uses MessageType::setRequestCode()
     * @uses MessageType::setReasonForRequest()
     * @uses MessageType::setUserName()
     * @uses MessageType::setRatePlanCode()
     * @uses MessageType::setConfirmationID()
     * @uses MessageType::setReservationID()
     * @uses MessageType::setChainCode()
     * @uses MessageType::setBrandCode()
     * @uses MessageType::setHotelCode()
     * @uses MessageType::setHotelCityCode()
     * @uses MessageType::setHotelName()
     * @uses MessageType::setHotelCodeContext()
     * @uses MessageType::setChainName()
     * @uses MessageType::setBrandName()
     * @uses MessageType::setAreaID()
     * @uses MessageType::setStart()
     * @uses MessageType::setDuration()
     * @uses MessageType::setEnd()
     * @param \StructType\OriginalPayloadStdAttributes $originalPayloadStdAttributes
     * @param string $messageContent
     * @param int $startSeqNmbr
     * @param int $endSeqNmbr
     * @param string $messageType
     * @param string $responseValue
     * @param string $requestCode
     * @param string $reasonForRequest
     * @param string $userName
     * @param string $ratePlanCode
     * @param string $confirmationID
     * @param string $reservationID
     * @param string $chainCode
     * @param string $brandCode
     * @param string $hotelCode
     * @param string $hotelCityCode
     * @param string $hotelName
     * @param string $hotelCodeContext
     * @param string $chainName
     * @param string $brandName
     * @param string $areaID
     * @param string $start
     * @param string $duration
     * @param string $end
     */
    public function __construct(\StructType\OriginalPayloadStdAttributes $originalPayloadStdAttributes = null, $messageContent = null, $startSeqNmbr = null, $endSeqNmbr = null, $messageType = null, $responseValue = null, $requestCode = null, $reasonForRequest = null, $userName = null, $ratePlanCode = null, $confirmationID = null, $reservationID = null, $chainCode = null, $brandCode = null, $hotelCode = null, $hotelCityCode = null, $hotelName = null, $hotelCodeContext = null, $chainName = null, $brandName = null, $areaID = null, $start = null, $duration = null, $end = null)
    {
        $this
            ->setOriginalPayloadStdAttributes($originalPayloadStdAttributes)
            ->setMessageContent($messageContent)
            ->setStartSeqNmbr($startSeqNmbr)
            ->setEndSeqNmbr($endSeqNmbr)
            ->setMessageType($messageType)
            ->setResponseValue($responseValue)
            ->setRequestCode($requestCode)
            ->setReasonForRequest($reasonForRequest)
            ->setUserName($userName)
            ->setRatePlanCode($ratePlanCode)
            ->setConfirmationID($confirmationID)
            ->setReservationID($reservationID)
            ->setChainCode($chainCode)
            ->setBrandCode($brandCode)
            ->setHotelCode($hotelCode)
            ->setHotelCityCode($hotelCityCode)
            ->setHotelName($hotelName)
            ->setHotelCodeContext($hotelCodeContext)
            ->setChainName($chainName)
            ->setBrandName($brandName)
            ->setAreaID($areaID)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end);
    }
    /**
     * Get OriginalPayloadStdAttributes value
     * @return \StructType\OriginalPayloadStdAttributes|null
     */
    public function getOriginalPayloadStdAttributes()
    {
        return $this->OriginalPayloadStdAttributes;
    }
    /**
     * Set OriginalPayloadStdAttributes value
     * @param \StructType\OriginalPayloadStdAttributes $originalPayloadStdAttributes
     * @return \StructType\MessageType
     */
    public function setOriginalPayloadStdAttributes(\StructType\OriginalPayloadStdAttributes $originalPayloadStdAttributes = null)
    {
        $this->OriginalPayloadStdAttributes = $originalPayloadStdAttributes;
        return $this;
    }
    /**
     * Get MessageContent value
     * @return string|null
     */
    public function getMessageContent()
    {
        return $this->MessageContent;
    }
    /**
     * Set MessageContent value
     * @param string $messageContent
     * @return \StructType\MessageType
     */
    public function setMessageContent($messageContent = null)
    {
        // validation for constraint: string
        if (!is_null($messageContent) && !is_string($messageContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageContent, true), gettype($messageContent)), __LINE__);
        }
        $this->MessageContent = $messageContent;
        return $this;
    }
    /**
     * Get StartSeqNmbr value
     * @return int|null
     */
    public function getStartSeqNmbr()
    {
        return $this->StartSeqNmbr;
    }
    /**
     * Set StartSeqNmbr value
     * @param int $startSeqNmbr
     * @return \StructType\MessageType
     */
    public function setStartSeqNmbr($startSeqNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($startSeqNmbr) && !(is_int($startSeqNmbr) || ctype_digit($startSeqNmbr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($startSeqNmbr, true), gettype($startSeqNmbr)), __LINE__);
        }
        $this->StartSeqNmbr = $startSeqNmbr;
        return $this;
    }
    /**
     * Get EndSeqNmbr value
     * @return int|null
     */
    public function getEndSeqNmbr()
    {
        return $this->EndSeqNmbr;
    }
    /**
     * Set EndSeqNmbr value
     * @param int $endSeqNmbr
     * @return \StructType\MessageType
     */
    public function setEndSeqNmbr($endSeqNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($endSeqNmbr) && !(is_int($endSeqNmbr) || ctype_digit($endSeqNmbr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($endSeqNmbr, true), gettype($endSeqNmbr)), __LINE__);
        }
        $this->EndSeqNmbr = $endSeqNmbr;
        return $this;
    }
    /**
     * Get MessageType value
     * @return string|null
     */
    public function getMessageType()
    {
        return $this->MessageType;
    }
    /**
     * Set MessageType value
     * @param string $messageType
     * @return \StructType\MessageType
     */
    public function setMessageType($messageType = null)
    {
        // validation for constraint: string
        if (!is_null($messageType) && !is_string($messageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageType, true), gettype($messageType)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($messageType) && mb_strlen($messageType) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($messageType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($messageType) && mb_strlen($messageType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($messageType)), __LINE__);
        }
        $this->MessageType = $messageType;
        return $this;
    }
    /**
     * Get ResponseValue value
     * @return string|null
     */
    public function getResponseValue()
    {
        return $this->ResponseValue;
    }
    /**
     * Set ResponseValue value
     * @param string $responseValue
     * @return \StructType\MessageType
     */
    public function setResponseValue($responseValue = null)
    {
        // validation for constraint: string
        if (!is_null($responseValue) && !is_string($responseValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseValue, true), gettype($responseValue)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($responseValue) && mb_strlen($responseValue) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($responseValue)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($responseValue) && mb_strlen($responseValue) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($responseValue)), __LINE__);
        }
        $this->ResponseValue = $responseValue;
        return $this;
    }
    /**
     * Get RequestCode value
     * @return string|null
     */
    public function getRequestCode()
    {
        return $this->RequestCode;
    }
    /**
     * Set RequestCode value
     * @param string $requestCode
     * @return \StructType\MessageType
     */
    public function setRequestCode($requestCode = null)
    {
        // validation for constraint: string
        if (!is_null($requestCode) && !is_string($requestCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestCode, true), gettype($requestCode)), __LINE__);
        }
        $this->RequestCode = $requestCode;
        return $this;
    }
    /**
     * Get ReasonForRequest value
     * @return string|null
     */
    public function getReasonForRequest()
    {
        return $this->ReasonForRequest;
    }
    /**
     * Set ReasonForRequest value
     * @param string $reasonForRequest
     * @return \StructType\MessageType
     */
    public function setReasonForRequest($reasonForRequest = null)
    {
        // validation for constraint: string
        if (!is_null($reasonForRequest) && !is_string($reasonForRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonForRequest, true), gettype($reasonForRequest)), __LINE__);
        }
        $this->ReasonForRequest = $reasonForRequest;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\MessageType
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\MessageType
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get ConfirmationID value
     * @return string|null
     */
    public function getConfirmationID()
    {
        return $this->ConfirmationID;
    }
    /**
     * Set ConfirmationID value
     * @param string $confirmationID
     * @return \StructType\MessageType
     */
    public function setConfirmationID($confirmationID = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationID) && !is_string($confirmationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationID, true), gettype($confirmationID)), __LINE__);
        }
        $this->ConfirmationID = $confirmationID;
        return $this;
    }
    /**
     * Get ReservationID value
     * @return string|null
     */
    public function getReservationID()
    {
        return $this->ReservationID;
    }
    /**
     * Set ReservationID value
     * @param string $reservationID
     * @return \StructType\MessageType
     */
    public function setReservationID($reservationID = null)
    {
        // validation for constraint: string
        if (!is_null($reservationID) && !is_string($reservationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationID, true), gettype($reservationID)), __LINE__);
        }
        $this->ReservationID = $reservationID;
        return $this;
    }
    /**
     * Get ChainCode value
     * @return string|null
     */
    public function getChainCode()
    {
        return $this->ChainCode;
    }
    /**
     * Set ChainCode value
     * @param string $chainCode
     * @return \StructType\MessageType
     */
    public function setChainCode($chainCode = null)
    {
        // validation for constraint: string
        if (!is_null($chainCode) && !is_string($chainCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chainCode, true), gettype($chainCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($chainCode) && mb_strlen($chainCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($chainCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($chainCode) && mb_strlen($chainCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($chainCode)), __LINE__);
        }
        $this->ChainCode = $chainCode;
        return $this;
    }
    /**
     * Get BrandCode value
     * @return string|null
     */
    public function getBrandCode()
    {
        return $this->BrandCode;
    }
    /**
     * Set BrandCode value
     * @param string $brandCode
     * @return \StructType\MessageType
     */
    public function setBrandCode($brandCode = null)
    {
        // validation for constraint: string
        if (!is_null($brandCode) && !is_string($brandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brandCode, true), gettype($brandCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($brandCode) && mb_strlen($brandCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($brandCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($brandCode) && mb_strlen($brandCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($brandCode)), __LINE__);
        }
        $this->BrandCode = $brandCode;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \StructType\MessageType
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCode, true), gettype($hotelCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($hotelCode) && mb_strlen($hotelCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($hotelCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($hotelCode) && mb_strlen($hotelCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get HotelCityCode value
     * @return string|null
     */
    public function getHotelCityCode()
    {
        return $this->HotelCityCode;
    }
    /**
     * Set HotelCityCode value
     * @param string $hotelCityCode
     * @return \StructType\MessageType
     */
    public function setHotelCityCode($hotelCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCityCode) && !is_string($hotelCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCityCode, true), gettype($hotelCityCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($hotelCityCode) && mb_strlen($hotelCityCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($hotelCityCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($hotelCityCode) && mb_strlen($hotelCityCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($hotelCityCode)), __LINE__);
        }
        $this->HotelCityCode = $hotelCityCode;
        return $this;
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \StructType\MessageType
     */
    public function setHotelName($hotelName = null)
    {
        // validation for constraint: string
        if (!is_null($hotelName) && !is_string($hotelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelName, true), gettype($hotelName)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($hotelName) && mb_strlen($hotelName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($hotelName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($hotelName) && mb_strlen($hotelName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($hotelName)), __LINE__);
        }
        $this->HotelName = $hotelName;
        return $this;
    }
    /**
     * Get HotelCodeContext value
     * @return string|null
     */
    public function getHotelCodeContext()
    {
        return $this->HotelCodeContext;
    }
    /**
     * Set HotelCodeContext value
     * @param string $hotelCodeContext
     * @return \StructType\MessageType
     */
    public function setHotelCodeContext($hotelCodeContext = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCodeContext) && !is_string($hotelCodeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCodeContext, true), gettype($hotelCodeContext)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($hotelCodeContext) && mb_strlen($hotelCodeContext) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($hotelCodeContext)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($hotelCodeContext) && mb_strlen($hotelCodeContext) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($hotelCodeContext)), __LINE__);
        }
        $this->HotelCodeContext = $hotelCodeContext;
        return $this;
    }
    /**
     * Get ChainName value
     * @return string|null
     */
    public function getChainName()
    {
        return $this->ChainName;
    }
    /**
     * Set ChainName value
     * @param string $chainName
     * @return \StructType\MessageType
     */
    public function setChainName($chainName = null)
    {
        // validation for constraint: string
        if (!is_null($chainName) && !is_string($chainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chainName, true), gettype($chainName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($chainName) && mb_strlen($chainName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($chainName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($chainName) && mb_strlen($chainName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($chainName)), __LINE__);
        }
        $this->ChainName = $chainName;
        return $this;
    }
    /**
     * Get BrandName value
     * @return string|null
     */
    public function getBrandName()
    {
        return $this->BrandName;
    }
    /**
     * Set BrandName value
     * @param string $brandName
     * @return \StructType\MessageType
     */
    public function setBrandName($brandName = null)
    {
        // validation for constraint: string
        if (!is_null($brandName) && !is_string($brandName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brandName, true), gettype($brandName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($brandName) && mb_strlen($brandName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($brandName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($brandName) && mb_strlen($brandName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($brandName)), __LINE__);
        }
        $this->BrandName = $brandName;
        return $this;
    }
    /**
     * Get AreaID value
     * @return string|null
     */
    public function getAreaID()
    {
        return $this->AreaID;
    }
    /**
     * Set AreaID value
     * @param string $areaID
     * @return \StructType\MessageType
     */
    public function setAreaID($areaID = null)
    {
        // validation for constraint: string
        if (!is_null($areaID) && !is_string($areaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaID, true), gettype($areaID)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($areaID) && !preg_match('/[0-9]{1,8}/', $areaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($areaID, true)), __LINE__);
        }
        $this->AreaID = $areaID;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * This method is responsible for validating the value passed to the setStart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStart method
     * This is a set of validation rules based on the union types associated to the property being set by the setStart method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStartForUnionConstraintsFromSetStart($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\MessageType
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($startUnionErrorMessage = self::validateStartForUnionConstraintsFromSetStart($start))) {
            throw new \InvalidArgumentException($startUnionErrorMessage, __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * This method is responsible for validating the value passed to the setDuration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDuration method
     * This is a set of validation rules based on the union types associated to the property being set by the setDuration method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDurationForUnionConstraintsFromSetDuration($value)
    {
        $message = '';
        // validation for constraint: pattern(P[0-9]{1,3}N)
        if (!is_null($value) && !preg_match('/P[0-9]{1,3}N/', $value)) {
            $exception0 = new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression P[0-9]{1,3}N', var_export($value, true)), __LINE__);
        }
        if (isset($exception0)) {
            $message = sprintf("The value %s does not match any of the union rules: duration, NightDurationType. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [$exception0])));
        }
        unset($exception0);
        return $message;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\MessageType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        // validation for constraint: union(duration, NightDurationType)
        if ('' !== ($durationUnionErrorMessage = self::validateDurationForUnionConstraintsFromSetDuration($duration))) {
            throw new \InvalidArgumentException($durationUnionErrorMessage, __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * This method is responsible for validating the value passed to the setEnd method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEnd method
     * This is a set of validation rules based on the union types associated to the property being set by the setEnd method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEndForUnionConstraintsFromSetEnd($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\MessageType
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($endUnionErrorMessage = self::validateEndForUnionConstraintsFromSetEnd($end))) {
            throw new \InvalidArgumentException($endUnionErrorMessage, __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MessageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
