<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MeetingRoomsType StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of MeetingRoom objects that provide the codes and description of the meeting rooms in the hotel.
 * @subpackage Structs
 */
class MeetingRoomsType extends AbstractStructBase
{
    /**
     * The MeetingRoom
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MeetingRoom[]
     */
    public $MeetingRoom;
    /**
     * The MeetingRoomCount
     * Meta information extracted from the WSDL
     * - documentation: The total number of unique meeting rooms provided at the hotel facility. For example, if the hotel has a grand ballroom that breaks into Salon A, B, and C -the total number of unique meeting rooms is three.
     * - use: optional
     * @var int
     */
    public $MeetingRoomCount;
    /**
     * The SmallestRoomSpace
     * Meta information extracted from the WSDL
     * - documentation: The amount of room space for the smallest unique meeting room at the hotel facility.
     * - use: optional
     * @var int
     */
    public $SmallestRoomSpace;
    /**
     * The LargestRoomSpace
     * Meta information extracted from the WSDL
     * - documentation: The amount of room space for the largest unique meeting room at the hotel facility.
     * - use: optional
     * @var int
     */
    public $LargestRoomSpace;
    /**
     * The TotalRoomSpace
     * Meta information extracted from the WSDL
     * - documentation: The total amount of unique room space provided at the hotel facility. Note: when counting space, if there is grand ballroom that is comprised of Salon A, B, and C - count the total measurement of the ballroom only.
     * - use: optional
     * @var int
     */
    public $TotalRoomSpace;
    /**
     * The LargestSeatingCapacity
     * Meta information extracted from the WSDL
     * - documentation: The largest seating capacity available in the largest meeting room - generally this is for theatre-style room setup.
     * - use: optional
     * @var int
     */
    public $LargestSeatingCapacity;
    /**
     * The SecondLargestSeatingCapacity
     * Meta information extracted from the WSDL
     * - documentation: The second largest seating capacity available in the second largest meeting room - generally this is for theatre-style room setup. This is excluding any space within the largest meeting room.
     * - use: optional
     * @var int
     */
    public $SecondLargestSeatingCapacity;
    /**
     * The SmallestSeatingCapacity
     * Meta information extracted from the WSDL
     * - documentation: The smallest seating capacity available in a meeting room - generally this is for theatre-style room setup.
     * - use: optional
     * @var int
     */
    public $SmallestSeatingCapacity;
    /**
     * The TotalRoomSeatingCapacity
     * Meta information extracted from the WSDL
     * - documentation: The total seating capacity available at the hotel facility.
     * - use: optional
     * @var int
     */
    public $TotalRoomSeatingCapacity;
    /**
     * The LargestRoomHeight
     * Meta information extracted from the WSDL
     * - documentation: The ceiling height of the largest meeting room.
     * - use: optional
     * @var int
     */
    public $LargestRoomHeight;
    /**
     * The UnitOfMeasureQuantity
     * @var float
     */
    public $UnitOfMeasureQuantity;
    /**
     * The UnitOfMeasure
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $UnitOfMeasure;
    /**
     * The UnitOfMeasureCode
     * Meta information extracted from the WSDL
     * - documentation: Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * @var string
     */
    public $UnitOfMeasureCode;
    /**
     * Constructor method for MeetingRoomsType
     * @uses MeetingRoomsType::setMeetingRoom()
     * @uses MeetingRoomsType::setMeetingRoomCount()
     * @uses MeetingRoomsType::setSmallestRoomSpace()
     * @uses MeetingRoomsType::setLargestRoomSpace()
     * @uses MeetingRoomsType::setTotalRoomSpace()
     * @uses MeetingRoomsType::setLargestSeatingCapacity()
     * @uses MeetingRoomsType::setSecondLargestSeatingCapacity()
     * @uses MeetingRoomsType::setSmallestSeatingCapacity()
     * @uses MeetingRoomsType::setTotalRoomSeatingCapacity()
     * @uses MeetingRoomsType::setLargestRoomHeight()
     * @uses MeetingRoomsType::setUnitOfMeasureQuantity()
     * @uses MeetingRoomsType::setUnitOfMeasure()
     * @uses MeetingRoomsType::setUnitOfMeasureCode()
     * @param \StructType\MeetingRoom[] $meetingRoom
     * @param int $meetingRoomCount
     * @param int $smallestRoomSpace
     * @param int $largestRoomSpace
     * @param int $totalRoomSpace
     * @param int $largestSeatingCapacity
     * @param int $secondLargestSeatingCapacity
     * @param int $smallestSeatingCapacity
     * @param int $totalRoomSeatingCapacity
     * @param int $largestRoomHeight
     * @param float $unitOfMeasureQuantity
     * @param string $unitOfMeasure
     * @param string $unitOfMeasureCode
     */
    public function __construct(array $meetingRoom = array(), $meetingRoomCount = null, $smallestRoomSpace = null, $largestRoomSpace = null, $totalRoomSpace = null, $largestSeatingCapacity = null, $secondLargestSeatingCapacity = null, $smallestSeatingCapacity = null, $totalRoomSeatingCapacity = null, $largestRoomHeight = null, $unitOfMeasureQuantity = null, $unitOfMeasure = null, $unitOfMeasureCode = null)
    {
        $this
            ->setMeetingRoom($meetingRoom)
            ->setMeetingRoomCount($meetingRoomCount)
            ->setSmallestRoomSpace($smallestRoomSpace)
            ->setLargestRoomSpace($largestRoomSpace)
            ->setTotalRoomSpace($totalRoomSpace)
            ->setLargestSeatingCapacity($largestSeatingCapacity)
            ->setSecondLargestSeatingCapacity($secondLargestSeatingCapacity)
            ->setSmallestSeatingCapacity($smallestSeatingCapacity)
            ->setTotalRoomSeatingCapacity($totalRoomSeatingCapacity)
            ->setLargestRoomHeight($largestRoomHeight)
            ->setUnitOfMeasureQuantity($unitOfMeasureQuantity)
            ->setUnitOfMeasure($unitOfMeasure)
            ->setUnitOfMeasureCode($unitOfMeasureCode);
    }
    /**
     * Get MeetingRoom value
     * @return \StructType\MeetingRoom[]|null
     */
    public function getMeetingRoom()
    {
        return $this->MeetingRoom;
    }
    /**
     * This method is responsible for validating the values passed to the setMeetingRoom method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeetingRoom method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeetingRoomForArrayConstraintsFromSetMeetingRoom(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $meetingRoomsTypeMeetingRoomItem) {
            // validation for constraint: itemType
            if (!$meetingRoomsTypeMeetingRoomItem instanceof \StructType\MeetingRoom) {
                $invalidValues[] = is_object($meetingRoomsTypeMeetingRoomItem) ? get_class($meetingRoomsTypeMeetingRoomItem) : sprintf('%s(%s)', gettype($meetingRoomsTypeMeetingRoomItem), var_export($meetingRoomsTypeMeetingRoomItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MeetingRoom property can only contain items of type \StructType\MeetingRoom, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MeetingRoom value
     * @throws \InvalidArgumentException
     * @param \StructType\MeetingRoom[] $meetingRoom
     * @return \StructType\MeetingRoomsType
     */
    public function setMeetingRoom(array $meetingRoom = array())
    {
        // validation for constraint: array
        if ('' !== ($meetingRoomArrayErrorMessage = self::validateMeetingRoomForArrayConstraintsFromSetMeetingRoom($meetingRoom))) {
            throw new \InvalidArgumentException($meetingRoomArrayErrorMessage, __LINE__);
        }
        $this->MeetingRoom = $meetingRoom;
        return $this;
    }
    /**
     * Add item to MeetingRoom value
     * @throws \InvalidArgumentException
     * @param \StructType\MeetingRoom $item
     * @return \StructType\MeetingRoomsType
     */
    public function addToMeetingRoom(\StructType\MeetingRoom $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MeetingRoom) {
            throw new \InvalidArgumentException(sprintf('The MeetingRoom property can only contain items of type \StructType\MeetingRoom, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MeetingRoom[] = $item;
        return $this;
    }
    /**
     * Get MeetingRoomCount value
     * @return int|null
     */
    public function getMeetingRoomCount()
    {
        return $this->MeetingRoomCount;
    }
    /**
     * Set MeetingRoomCount value
     * @param int $meetingRoomCount
     * @return \StructType\MeetingRoomsType
     */
    public function setMeetingRoomCount($meetingRoomCount = null)
    {
        // validation for constraint: int
        if (!is_null($meetingRoomCount) && !(is_int($meetingRoomCount) || ctype_digit($meetingRoomCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($meetingRoomCount, true), gettype($meetingRoomCount)), __LINE__);
        }
        $this->MeetingRoomCount = $meetingRoomCount;
        return $this;
    }
    /**
     * Get SmallestRoomSpace value
     * @return int|null
     */
    public function getSmallestRoomSpace()
    {
        return $this->SmallestRoomSpace;
    }
    /**
     * Set SmallestRoomSpace value
     * @param int $smallestRoomSpace
     * @return \StructType\MeetingRoomsType
     */
    public function setSmallestRoomSpace($smallestRoomSpace = null)
    {
        // validation for constraint: int
        if (!is_null($smallestRoomSpace) && !(is_int($smallestRoomSpace) || ctype_digit($smallestRoomSpace))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($smallestRoomSpace, true), gettype($smallestRoomSpace)), __LINE__);
        }
        $this->SmallestRoomSpace = $smallestRoomSpace;
        return $this;
    }
    /**
     * Get LargestRoomSpace value
     * @return int|null
     */
    public function getLargestRoomSpace()
    {
        return $this->LargestRoomSpace;
    }
    /**
     * Set LargestRoomSpace value
     * @param int $largestRoomSpace
     * @return \StructType\MeetingRoomsType
     */
    public function setLargestRoomSpace($largestRoomSpace = null)
    {
        // validation for constraint: int
        if (!is_null($largestRoomSpace) && !(is_int($largestRoomSpace) || ctype_digit($largestRoomSpace))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($largestRoomSpace, true), gettype($largestRoomSpace)), __LINE__);
        }
        $this->LargestRoomSpace = $largestRoomSpace;
        return $this;
    }
    /**
     * Get TotalRoomSpace value
     * @return int|null
     */
    public function getTotalRoomSpace()
    {
        return $this->TotalRoomSpace;
    }
    /**
     * Set TotalRoomSpace value
     * @param int $totalRoomSpace
     * @return \StructType\MeetingRoomsType
     */
    public function setTotalRoomSpace($totalRoomSpace = null)
    {
        // validation for constraint: int
        if (!is_null($totalRoomSpace) && !(is_int($totalRoomSpace) || ctype_digit($totalRoomSpace))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalRoomSpace, true), gettype($totalRoomSpace)), __LINE__);
        }
        $this->TotalRoomSpace = $totalRoomSpace;
        return $this;
    }
    /**
     * Get LargestSeatingCapacity value
     * @return int|null
     */
    public function getLargestSeatingCapacity()
    {
        return $this->LargestSeatingCapacity;
    }
    /**
     * Set LargestSeatingCapacity value
     * @param int $largestSeatingCapacity
     * @return \StructType\MeetingRoomsType
     */
    public function setLargestSeatingCapacity($largestSeatingCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($largestSeatingCapacity) && !(is_int($largestSeatingCapacity) || ctype_digit($largestSeatingCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($largestSeatingCapacity, true), gettype($largestSeatingCapacity)), __LINE__);
        }
        $this->LargestSeatingCapacity = $largestSeatingCapacity;
        return $this;
    }
    /**
     * Get SecondLargestSeatingCapacity value
     * @return int|null
     */
    public function getSecondLargestSeatingCapacity()
    {
        return $this->SecondLargestSeatingCapacity;
    }
    /**
     * Set SecondLargestSeatingCapacity value
     * @param int $secondLargestSeatingCapacity
     * @return \StructType\MeetingRoomsType
     */
    public function setSecondLargestSeatingCapacity($secondLargestSeatingCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($secondLargestSeatingCapacity) && !(is_int($secondLargestSeatingCapacity) || ctype_digit($secondLargestSeatingCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($secondLargestSeatingCapacity, true), gettype($secondLargestSeatingCapacity)), __LINE__);
        }
        $this->SecondLargestSeatingCapacity = $secondLargestSeatingCapacity;
        return $this;
    }
    /**
     * Get SmallestSeatingCapacity value
     * @return int|null
     */
    public function getSmallestSeatingCapacity()
    {
        return $this->SmallestSeatingCapacity;
    }
    /**
     * Set SmallestSeatingCapacity value
     * @param int $smallestSeatingCapacity
     * @return \StructType\MeetingRoomsType
     */
    public function setSmallestSeatingCapacity($smallestSeatingCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($smallestSeatingCapacity) && !(is_int($smallestSeatingCapacity) || ctype_digit($smallestSeatingCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($smallestSeatingCapacity, true), gettype($smallestSeatingCapacity)), __LINE__);
        }
        $this->SmallestSeatingCapacity = $smallestSeatingCapacity;
        return $this;
    }
    /**
     * Get TotalRoomSeatingCapacity value
     * @return int|null
     */
    public function getTotalRoomSeatingCapacity()
    {
        return $this->TotalRoomSeatingCapacity;
    }
    /**
     * Set TotalRoomSeatingCapacity value
     * @param int $totalRoomSeatingCapacity
     * @return \StructType\MeetingRoomsType
     */
    public function setTotalRoomSeatingCapacity($totalRoomSeatingCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($totalRoomSeatingCapacity) && !(is_int($totalRoomSeatingCapacity) || ctype_digit($totalRoomSeatingCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalRoomSeatingCapacity, true), gettype($totalRoomSeatingCapacity)), __LINE__);
        }
        $this->TotalRoomSeatingCapacity = $totalRoomSeatingCapacity;
        return $this;
    }
    /**
     * Get LargestRoomHeight value
     * @return int|null
     */
    public function getLargestRoomHeight()
    {
        return $this->LargestRoomHeight;
    }
    /**
     * Set LargestRoomHeight value
     * @param int $largestRoomHeight
     * @return \StructType\MeetingRoomsType
     */
    public function setLargestRoomHeight($largestRoomHeight = null)
    {
        // validation for constraint: int
        if (!is_null($largestRoomHeight) && !(is_int($largestRoomHeight) || ctype_digit($largestRoomHeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($largestRoomHeight, true), gettype($largestRoomHeight)), __LINE__);
        }
        $this->LargestRoomHeight = $largestRoomHeight;
        return $this;
    }
    /**
     * Get UnitOfMeasureQuantity value
     * @return float|null
     */
    public function getUnitOfMeasureQuantity()
    {
        return $this->UnitOfMeasureQuantity;
    }
    /**
     * Set UnitOfMeasureQuantity value
     * @param float $unitOfMeasureQuantity
     * @return \StructType\MeetingRoomsType
     */
    public function setUnitOfMeasureQuantity($unitOfMeasureQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($unitOfMeasureQuantity) && !(is_float($unitOfMeasureQuantity) || is_numeric($unitOfMeasureQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitOfMeasureQuantity, true), gettype($unitOfMeasureQuantity)), __LINE__);
        }
        $this->UnitOfMeasureQuantity = $unitOfMeasureQuantity;
        return $this;
    }
    /**
     * Get UnitOfMeasure value
     * @return string|null
     */
    public function getUnitOfMeasure()
    {
        return $this->UnitOfMeasure;
    }
    /**
     * Set UnitOfMeasure value
     * @param string $unitOfMeasure
     * @return \StructType\MeetingRoomsType
     */
    public function setUnitOfMeasure($unitOfMeasure = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasure) && !is_string($unitOfMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitOfMeasure, true), gettype($unitOfMeasure)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($unitOfMeasure) && mb_strlen($unitOfMeasure) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($unitOfMeasure)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($unitOfMeasure) && mb_strlen($unitOfMeasure) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($unitOfMeasure)), __LINE__);
        }
        $this->UnitOfMeasure = $unitOfMeasure;
        return $this;
    }
    /**
     * Get UnitOfMeasureCode value
     * @return string|null
     */
    public function getUnitOfMeasureCode()
    {
        return $this->UnitOfMeasureCode;
    }
    /**
     * Set UnitOfMeasureCode value
     * @param string $unitOfMeasureCode
     * @return \StructType\MeetingRoomsType
     */
    public function setUnitOfMeasureCode($unitOfMeasureCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasureCode) && !is_string($unitOfMeasureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitOfMeasureCode, true), gettype($unitOfMeasureCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($unitOfMeasureCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $unitOfMeasureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($unitOfMeasureCode, true)), __LINE__);
        }
        $this->UnitOfMeasureCode = $unitOfMeasureCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MeetingRoomsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
