<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MeetingRoomCodeType StructType
 * Meta information extracted from the WSDL
 * - documentation: A unique identifying value assigned by the creating system. The ID attribute may be used to reference a primary-key value within a database or in a particular implementation. | May be used to give further detail on the code or to
 * remove an obsolete item.
 * @subpackage Structs
 */
class MeetingRoomCodeType extends AbstractStructBase
{
    /**
     * The Charge
     * Meta information extracted from the WSDL
     * - documentation: The minimum charge for this meeting room code.
     * - minOccurs: 0
     * @var \StructType\FeeType
     */
    public $Charge;
    /**
     * The MultimediaDescriptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MultimediaDescriptionsType
     */
    public $MultimediaDescriptions;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: This is used to define items that may be available for any of the meeting rooms. Refer to OpenTravel Code List Meeting Room Code (MRC). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101,
     * 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The ExistsCode
     * Meta information extracted from the WSDL
     * - documentation: This attribute is used to explicitly define whether an amenity or service is offered. Refer to OpenTravel Code list Option Type Code (OTC). This is used in conjunction with Code. | Used for codes in the OpenTravel Code tables.
     * Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $ExistsCode;
    /**
     * The DiscountsAvailableCode
     * Meta information extracted from the WSDL
     * - documentation: This is used for discounts that apply to meetings (eg. corporate, military). Refer to OpenTravel Code List Discounts Available (DIS). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101,
     * 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $DiscountsAvailableCode;
    /**
     * The CodeDetail
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $CodeDetail;
    /**
     * The Removal
     * @var bool
     */
    public $Removal;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $ID;
    /**
     * Constructor method for MeetingRoomCodeType
     * @uses MeetingRoomCodeType::setCharge()
     * @uses MeetingRoomCodeType::setMultimediaDescriptions()
     * @uses MeetingRoomCodeType::setCode()
     * @uses MeetingRoomCodeType::setExistsCode()
     * @uses MeetingRoomCodeType::setDiscountsAvailableCode()
     * @uses MeetingRoomCodeType::setCodeDetail()
     * @uses MeetingRoomCodeType::setRemoval()
     * @uses MeetingRoomCodeType::setQuantity()
     * @uses MeetingRoomCodeType::setID()
     * @param \StructType\FeeType $charge
     * @param \StructType\MultimediaDescriptionsType $multimediaDescriptions
     * @param string $code
     * @param string $existsCode
     * @param string $discountsAvailableCode
     * @param string $codeDetail
     * @param bool $removal
     * @param int $quantity
     * @param string $iD
     */
    public function __construct(\StructType\FeeType $charge = null, \StructType\MultimediaDescriptionsType $multimediaDescriptions = null, $code = null, $existsCode = null, $discountsAvailableCode = null, $codeDetail = null, $removal = null, $quantity = null, $iD = null)
    {
        $this
            ->setCharge($charge)
            ->setMultimediaDescriptions($multimediaDescriptions)
            ->setCode($code)
            ->setExistsCode($existsCode)
            ->setDiscountsAvailableCode($discountsAvailableCode)
            ->setCodeDetail($codeDetail)
            ->setRemoval($removal)
            ->setQuantity($quantity)
            ->setID($iD);
    }
    /**
     * Get Charge value
     * @return \StructType\FeeType|null
     */
    public function getCharge()
    {
        return $this->Charge;
    }
    /**
     * Set Charge value
     * @param \StructType\FeeType $charge
     * @return \StructType\MeetingRoomCodeType
     */
    public function setCharge(\StructType\FeeType $charge = null)
    {
        $this->Charge = $charge;
        return $this;
    }
    /**
     * Get MultimediaDescriptions value
     * @return \StructType\MultimediaDescriptionsType|null
     */
    public function getMultimediaDescriptions()
    {
        return $this->MultimediaDescriptions;
    }
    /**
     * Set MultimediaDescriptions value
     * @param \StructType\MultimediaDescriptionsType $multimediaDescriptions
     * @return \StructType\MeetingRoomCodeType
     */
    public function setMultimediaDescriptions(\StructType\MultimediaDescriptionsType $multimediaDescriptions = null)
    {
        $this->MultimediaDescriptions = $multimediaDescriptions;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\MeetingRoomCodeType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($code) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($code, true)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get ExistsCode value
     * @return string|null
     */
    public function getExistsCode()
    {
        return $this->ExistsCode;
    }
    /**
     * Set ExistsCode value
     * @param string $existsCode
     * @return \StructType\MeetingRoomCodeType
     */
    public function setExistsCode($existsCode = null)
    {
        // validation for constraint: string
        if (!is_null($existsCode) && !is_string($existsCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($existsCode, true), gettype($existsCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($existsCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $existsCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($existsCode, true)), __LINE__);
        }
        $this->ExistsCode = $existsCode;
        return $this;
    }
    /**
     * Get DiscountsAvailableCode value
     * @return string|null
     */
    public function getDiscountsAvailableCode()
    {
        return $this->DiscountsAvailableCode;
    }
    /**
     * Set DiscountsAvailableCode value
     * @param string $discountsAvailableCode
     * @return \StructType\MeetingRoomCodeType
     */
    public function setDiscountsAvailableCode($discountsAvailableCode = null)
    {
        // validation for constraint: string
        if (!is_null($discountsAvailableCode) && !is_string($discountsAvailableCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountsAvailableCode, true), gettype($discountsAvailableCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($discountsAvailableCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $discountsAvailableCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($discountsAvailableCode, true)), __LINE__);
        }
        $this->DiscountsAvailableCode = $discountsAvailableCode;
        return $this;
    }
    /**
     * Get CodeDetail value
     * @return string|null
     */
    public function getCodeDetail()
    {
        return $this->CodeDetail;
    }
    /**
     * Set CodeDetail value
     * @param string $codeDetail
     * @return \StructType\MeetingRoomCodeType
     */
    public function setCodeDetail($codeDetail = null)
    {
        // validation for constraint: string
        if (!is_null($codeDetail) && !is_string($codeDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeDetail, true), gettype($codeDetail)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($codeDetail) && mb_strlen($codeDetail) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($codeDetail)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($codeDetail) && mb_strlen($codeDetail) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($codeDetail)), __LINE__);
        }
        $this->CodeDetail = $codeDetail;
        return $this;
    }
    /**
     * Get Removal value
     * @return bool|null
     */
    public function getRemoval()
    {
        return $this->Removal;
    }
    /**
     * Set Removal value
     * @param bool $removal
     * @return \StructType\MeetingRoomCodeType
     */
    public function setRemoval($removal = null)
    {
        // validation for constraint: boolean
        if (!is_null($removal) && !is_bool($removal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($removal, true), gettype($removal)), __LINE__);
        }
        $this->Removal = $removal;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\MeetingRoomCodeType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\MeetingRoomCodeType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($iD) && mb_strlen($iD) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($iD)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($iD) && mb_strlen($iD) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MeetingRoomCodeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
