<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MeetingRoom StructType
 * Meta information extracted from the WSDL
 * - documentation: This may be used to uniquely identify a meeting room. | Dedicated or non-dedicated space or area in which to hold a meeting.
 * @subpackage Structs
 */
class MeetingRoom extends AbstractStructBase
{
    /**
     * The Codes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Codes
     */
    public $Codes;
    /**
     * The Dimension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Dimension
     */
    public $Dimension;
    /**
     * The AvailableCapacities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AvailableCapacities
     */
    public $AvailableCapacities;
    /**
     * The Features
     * Meta information extracted from the WSDL
     * - documentation: Collection of features.
     * - minOccurs: 0
     * @var \StructType\FeaturesType
     */
    public $Features;
    /**
     * The MultimediaDescriptions
     * Meta information extracted from the WSDL
     * - documentation: Information describing the meeting room.
     * - minOccurs: 0
     * @var \StructType\MultimediaDescriptionsType
     */
    public $MultimediaDescriptions;
    /**
     * The Irregular
     * Meta information extracted from the WSDL
     * - documentation: This provides information as to whether the room has an irregular shape, if true the room would not be of a traditional square or rectangular style.
     * - use: optional
     * @var bool
     */
    public $Irregular;
    /**
     * The PropertySystemName
     * Meta information extracted from the WSDL
     * - documentation: This is the room name as it is defined by the system. The name used internally may differ from the name used by guests.
     * - use: optional
     * @var string
     */
    public $PropertySystemName;
    /**
     * The RoomName
     * Meta information extracted from the WSDL
     * - documentation: This is the meeting room name as provided to the guests.
     * - use: optional
     * @var string
     */
    public $RoomName;
    /**
     * The Sort
     * Meta information extracted from the WSDL
     * - documentation: This is a number assigned to rooms, usually used to define the display order.
     * - use: optional
     * @var int
     */
    public $Sort;
    /**
     * The MeetingRoomCapacity
     * Meta information extracted from the WSDL
     * - documentation: The total number of people permitted in the meeting room.
     * - use: optional
     * @var int
     */
    public $MeetingRoomCapacity;
    /**
     * The Access
     * Meta information extracted from the WSDL
     * - documentation: Used to imply the type of access to the meeting space (e.g. private access, public access, etc.)
     * - use: optional
     * @var string
     */
    public $Access;
    /**
     * The MeetingRoomTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Defines the type of the meeting room being described (eg. boardroom, ballroom, exhibit space). Refer to OpenTravel Codelist Meeting Room Format Code (MRF). | Used for codes in the OpenTravel Code tables. Possible values of this
     * pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $MeetingRoomTypeCode;
    /**
     * The MeetingRoomLevel
     * Meta information extracted from the WSDL
     * - documentation: Defines the level in the facility where the meeting room is located (i.e., lobby, mezzanine, first floor, ground, outdoor, etc.) | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $MeetingRoomLevel;
    /**
     * The DedicatedIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, the room is used for a single purpose as indicated by the MeetingRoomTypeCode attribute.
     * - use: optional
     * @var bool
     */
    public $DedicatedIndicator;
    /**
     * The Removal
     * @var bool
     */
    public $Removal;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $ID;
    /**
     * Constructor method for MeetingRoom
     * @uses MeetingRoom::setCodes()
     * @uses MeetingRoom::setDimension()
     * @uses MeetingRoom::setAvailableCapacities()
     * @uses MeetingRoom::setFeatures()
     * @uses MeetingRoom::setMultimediaDescriptions()
     * @uses MeetingRoom::setIrregular()
     * @uses MeetingRoom::setPropertySystemName()
     * @uses MeetingRoom::setRoomName()
     * @uses MeetingRoom::setSort()
     * @uses MeetingRoom::setMeetingRoomCapacity()
     * @uses MeetingRoom::setAccess()
     * @uses MeetingRoom::setMeetingRoomTypeCode()
     * @uses MeetingRoom::setMeetingRoomLevel()
     * @uses MeetingRoom::setDedicatedIndicator()
     * @uses MeetingRoom::setRemoval()
     * @uses MeetingRoom::setID()
     * @param \StructType\Codes $codes
     * @param \StructType\Dimension $dimension
     * @param \StructType\AvailableCapacities $availableCapacities
     * @param \StructType\FeaturesType $features
     * @param \StructType\MultimediaDescriptionsType $multimediaDescriptions
     * @param bool $irregular
     * @param string $propertySystemName
     * @param string $roomName
     * @param int $sort
     * @param int $meetingRoomCapacity
     * @param string $access
     * @param string $meetingRoomTypeCode
     * @param string $meetingRoomLevel
     * @param bool $dedicatedIndicator
     * @param bool $removal
     * @param string $iD
     */
    public function __construct(\StructType\Codes $codes = null, \StructType\Dimension $dimension = null, \StructType\AvailableCapacities $availableCapacities = null, \StructType\FeaturesType $features = null, \StructType\MultimediaDescriptionsType $multimediaDescriptions = null, $irregular = null, $propertySystemName = null, $roomName = null, $sort = null, $meetingRoomCapacity = null, $access = null, $meetingRoomTypeCode = null, $meetingRoomLevel = null, $dedicatedIndicator = null, $removal = null, $iD = null)
    {
        $this
            ->setCodes($codes)
            ->setDimension($dimension)
            ->setAvailableCapacities($availableCapacities)
            ->setFeatures($features)
            ->setMultimediaDescriptions($multimediaDescriptions)
            ->setIrregular($irregular)
            ->setPropertySystemName($propertySystemName)
            ->setRoomName($roomName)
            ->setSort($sort)
            ->setMeetingRoomCapacity($meetingRoomCapacity)
            ->setAccess($access)
            ->setMeetingRoomTypeCode($meetingRoomTypeCode)
            ->setMeetingRoomLevel($meetingRoomLevel)
            ->setDedicatedIndicator($dedicatedIndicator)
            ->setRemoval($removal)
            ->setID($iD);
    }
    /**
     * Get Codes value
     * @return \StructType\Codes|null
     */
    public function getCodes()
    {
        return $this->Codes;
    }
    /**
     * Set Codes value
     * @param \StructType\Codes $codes
     * @return \StructType\MeetingRoom
     */
    public function setCodes(\StructType\Codes $codes = null)
    {
        $this->Codes = $codes;
        return $this;
    }
    /**
     * Get Dimension value
     * @return \StructType\Dimension|null
     */
    public function getDimension()
    {
        return $this->Dimension;
    }
    /**
     * Set Dimension value
     * @param \StructType\Dimension $dimension
     * @return \StructType\MeetingRoom
     */
    public function setDimension(\StructType\Dimension $dimension = null)
    {
        $this->Dimension = $dimension;
        return $this;
    }
    /**
     * Get AvailableCapacities value
     * @return \StructType\AvailableCapacities|null
     */
    public function getAvailableCapacities()
    {
        return $this->AvailableCapacities;
    }
    /**
     * Set AvailableCapacities value
     * @param \StructType\AvailableCapacities $availableCapacities
     * @return \StructType\MeetingRoom
     */
    public function setAvailableCapacities(\StructType\AvailableCapacities $availableCapacities = null)
    {
        $this->AvailableCapacities = $availableCapacities;
        return $this;
    }
    /**
     * Get Features value
     * @return \StructType\FeaturesType|null
     */
    public function getFeatures()
    {
        return $this->Features;
    }
    /**
     * Set Features value
     * @param \StructType\FeaturesType $features
     * @return \StructType\MeetingRoom
     */
    public function setFeatures(\StructType\FeaturesType $features = null)
    {
        $this->Features = $features;
        return $this;
    }
    /**
     * Get MultimediaDescriptions value
     * @return \StructType\MultimediaDescriptionsType|null
     */
    public function getMultimediaDescriptions()
    {
        return $this->MultimediaDescriptions;
    }
    /**
     * Set MultimediaDescriptions value
     * @param \StructType\MultimediaDescriptionsType $multimediaDescriptions
     * @return \StructType\MeetingRoom
     */
    public function setMultimediaDescriptions(\StructType\MultimediaDescriptionsType $multimediaDescriptions = null)
    {
        $this->MultimediaDescriptions = $multimediaDescriptions;
        return $this;
    }
    /**
     * Get Irregular value
     * @return bool|null
     */
    public function getIrregular()
    {
        return $this->Irregular;
    }
    /**
     * Set Irregular value
     * @param bool $irregular
     * @return \StructType\MeetingRoom
     */
    public function setIrregular($irregular = null)
    {
        // validation for constraint: boolean
        if (!is_null($irregular) && !is_bool($irregular)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($irregular, true), gettype($irregular)), __LINE__);
        }
        $this->Irregular = $irregular;
        return $this;
    }
    /**
     * Get PropertySystemName value
     * @return string|null
     */
    public function getPropertySystemName()
    {
        return $this->PropertySystemName;
    }
    /**
     * Set PropertySystemName value
     * @param string $propertySystemName
     * @return \StructType\MeetingRoom
     */
    public function setPropertySystemName($propertySystemName = null)
    {
        // validation for constraint: string
        if (!is_null($propertySystemName) && !is_string($propertySystemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertySystemName, true), gettype($propertySystemName)), __LINE__);
        }
        $this->PropertySystemName = $propertySystemName;
        return $this;
    }
    /**
     * Get RoomName value
     * @return string|null
     */
    public function getRoomName()
    {
        return $this->RoomName;
    }
    /**
     * Set RoomName value
     * @param string $roomName
     * @return \StructType\MeetingRoom
     */
    public function setRoomName($roomName = null)
    {
        // validation for constraint: string
        if (!is_null($roomName) && !is_string($roomName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomName, true), gettype($roomName)), __LINE__);
        }
        $this->RoomName = $roomName;
        return $this;
    }
    /**
     * Get Sort value
     * @return int|null
     */
    public function getSort()
    {
        return $this->Sort;
    }
    /**
     * Set Sort value
     * @param int $sort
     * @return \StructType\MeetingRoom
     */
    public function setSort($sort = null)
    {
        // validation for constraint: int
        if (!is_null($sort) && !(is_int($sort) || ctype_digit($sort))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sort, true), gettype($sort)), __LINE__);
        }
        $this->Sort = $sort;
        return $this;
    }
    /**
     * Get MeetingRoomCapacity value
     * @return int|null
     */
    public function getMeetingRoomCapacity()
    {
        return $this->MeetingRoomCapacity;
    }
    /**
     * Set MeetingRoomCapacity value
     * @param int $meetingRoomCapacity
     * @return \StructType\MeetingRoom
     */
    public function setMeetingRoomCapacity($meetingRoomCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($meetingRoomCapacity) && !(is_int($meetingRoomCapacity) || ctype_digit($meetingRoomCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($meetingRoomCapacity, true), gettype($meetingRoomCapacity)), __LINE__);
        }
        $this->MeetingRoomCapacity = $meetingRoomCapacity;
        return $this;
    }
    /**
     * Get Access value
     * @return string|null
     */
    public function getAccess()
    {
        return $this->Access;
    }
    /**
     * Set Access value
     * @param string $access
     * @return \StructType\MeetingRoom
     */
    public function setAccess($access = null)
    {
        // validation for constraint: string
        if (!is_null($access) && !is_string($access)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($access, true), gettype($access)), __LINE__);
        }
        $this->Access = $access;
        return $this;
    }
    /**
     * Get MeetingRoomTypeCode value
     * @return string|null
     */
    public function getMeetingRoomTypeCode()
    {
        return $this->MeetingRoomTypeCode;
    }
    /**
     * Set MeetingRoomTypeCode value
     * @param string $meetingRoomTypeCode
     * @return \StructType\MeetingRoom
     */
    public function setMeetingRoomTypeCode($meetingRoomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($meetingRoomTypeCode) && !is_string($meetingRoomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($meetingRoomTypeCode, true), gettype($meetingRoomTypeCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($meetingRoomTypeCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $meetingRoomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($meetingRoomTypeCode, true)), __LINE__);
        }
        $this->MeetingRoomTypeCode = $meetingRoomTypeCode;
        return $this;
    }
    /**
     * Get MeetingRoomLevel value
     * @return string|null
     */
    public function getMeetingRoomLevel()
    {
        return $this->MeetingRoomLevel;
    }
    /**
     * Set MeetingRoomLevel value
     * @param string $meetingRoomLevel
     * @return \StructType\MeetingRoom
     */
    public function setMeetingRoomLevel($meetingRoomLevel = null)
    {
        // validation for constraint: string
        if (!is_null($meetingRoomLevel) && !is_string($meetingRoomLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($meetingRoomLevel, true), gettype($meetingRoomLevel)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($meetingRoomLevel) && mb_strlen($meetingRoomLevel) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($meetingRoomLevel)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($meetingRoomLevel) && mb_strlen($meetingRoomLevel) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($meetingRoomLevel)), __LINE__);
        }
        $this->MeetingRoomLevel = $meetingRoomLevel;
        return $this;
    }
    /**
     * Get DedicatedIndicator value
     * @return bool|null
     */
    public function getDedicatedIndicator()
    {
        return $this->DedicatedIndicator;
    }
    /**
     * Set DedicatedIndicator value
     * @param bool $dedicatedIndicator
     * @return \StructType\MeetingRoom
     */
    public function setDedicatedIndicator($dedicatedIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($dedicatedIndicator) && !is_bool($dedicatedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dedicatedIndicator, true), gettype($dedicatedIndicator)), __LINE__);
        }
        $this->DedicatedIndicator = $dedicatedIndicator;
        return $this;
    }
    /**
     * Get Removal value
     * @return bool|null
     */
    public function getRemoval()
    {
        return $this->Removal;
    }
    /**
     * Set Removal value
     * @param bool $removal
     * @return \StructType\MeetingRoom
     */
    public function setRemoval($removal = null)
    {
        // validation for constraint: boolean
        if (!is_null($removal) && !is_bool($removal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($removal, true), gettype($removal)), __LINE__);
        }
        $this->Removal = $removal;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\MeetingRoom
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($iD) && mb_strlen($iD) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($iD)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($iD) && mb_strlen($iD) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MeetingRoom
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
