<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MealPlan StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to search for hotels that offer types of meal plan, such as "all-inclusive". This matches against the static property content, not the meal included in the rate.
 * @subpackage Structs
 */
class MealPlan extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: Refer to OpenTravel Code List Meal Plan Type (MPT). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X. | List of OpenTravel Codes.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * @var string[]
     */
    public $Code;
    /**
     * Constructor method for MealPlan
     * @uses MealPlan::setCode()
     * @param string[] $code
     */
    public function __construct(array $code = array())
    {
        $this
            ->setCode($code);
    }
    /**
     * Get Code value
     * @return string[]|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * This method is responsible for validating the values passed to the setCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCodeForArrayConstraintsFromSetCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $mealPlanCodeItem) {
            // validation for constraint: itemType
            if (!is_string($mealPlanCodeItem)) {
                $invalidValues[] = is_object($mealPlanCodeItem) ? get_class($mealPlanCodeItem) : sprintf('%s(%s)', gettype($mealPlanCodeItem), var_export($mealPlanCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Code property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Code value
     * @param string[] $code
     * @return \StructType\MealPlan
     */
    public function setCode(array $code = array())
    {
        // validation for constraint: list
        if ('' !== ($codeArrayErrorMessage = self::validateCodeForArrayConstraintsFromSetCode($code))) {
            throw new \InvalidArgumentException($codeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($code) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($code, true)), __LINE__);
        }
        $this->Code = is_array($code) ? implode(' ', $code) : null;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MealPlan
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
