<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Meal StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifies any meal and/or beverage services that are provided.
 * @subpackage Structs
 */
class Meal extends AbstractStructBase
{
    /**
     * The MealCode
     * Meta information extracted from the WSDL
     * - documentation: Used to designate a meal or beverage service.
     * - use: required
     * @var string
     */
    public $MealCode;
    /**
     * Constructor method for Meal
     * @uses Meal::setMealCode()
     * @param string $mealCode
     */
    public function __construct($mealCode = null)
    {
        $this
            ->setMealCode($mealCode);
    }
    /**
     * Get MealCode value
     * @return string
     */
    public function getMealCode()
    {
        return $this->MealCode;
    }
    /**
     * Set MealCode value
     * @uses \EnumType\MealServiceType::valueIsValid()
     * @uses \EnumType\MealServiceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mealCode
     * @return \StructType\Meal
     */
    public function setMealCode($mealCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MealServiceType::valueIsValid($mealCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MealServiceType', is_array($mealCode) ? implode(', ', $mealCode) : var_export($mealCode, true), implode(', ', \EnumType\MealServiceType::getValidValues())), __LINE__);
        }
        $this->MealCode = $mealCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Meal
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
