<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MarketingAirline StructType
 * Meta information extracted from the WSDL
 * - documentation: To specifiy if an airline is a member of an alliance. | The marketing airline. This is required for use with scheduled airline messages but may be omitted for requests by tour operators.
 * @subpackage Structs
 */
class MarketingAirline extends CompanyNameType
{
    /**
     * The _
     * @var \StructType\CompanyNameType
     */
    public $_;
    /**
     * The SingleVendorInd
     * @var string
     */
    public $SingleVendorInd;
    /**
     * Constructor method for MarketingAirline
     * @uses MarketingAirline::set_()
     * @uses MarketingAirline::setSingleVendorInd()
     * @param \StructType\CompanyNameType $_
     * @param string $singleVendorInd
     */
    public function __construct(\StructType\CompanyNameType $_ = null, $singleVendorInd = null)
    {
        $this
            ->set_($_)
            ->setSingleVendorInd($singleVendorInd);
    }
    /**
     * Get _ value
     * @return \StructType\CompanyNameType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \StructType\CompanyNameType $_
     * @return \StructType\MarketingAirline
     */
    public function set_(\StructType\CompanyNameType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get SingleVendorInd value
     * @return string|null
     */
    public function getSingleVendorInd()
    {
        return $this->SingleVendorInd;
    }
    /**
     * Set SingleVendorInd value
     * @param string $singleVendorInd
     * @return \StructType\MarketingAirline
     */
    public function setSingleVendorInd($singleVendorInd = null)
    {
        // validation for constraint: string
        if (!is_null($singleVendorInd) && !is_string($singleVendorInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($singleVendorInd, true), gettype($singleVendorInd)), __LINE__);
        }
        $this->SingleVendorInd = $singleVendorInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MarketingAirline
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
