<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MapArea StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides coordinates used to define the area of a map.
 * @subpackage Structs
 */
class MapArea extends AbstractStructBase
{
    /**
     * The NorthLatitude
     * Meta information extracted from the WSDL
     * - documentation: The latitude of the northern boundary of the map. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $NorthLatitude;
    /**
     * The SouthLatitude
     * Meta information extracted from the WSDL
     * - documentation: The latitude of the southern boundary of the map. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $SouthLatitude;
    /**
     * The EastLongitude
     * Meta information extracted from the WSDL
     * - documentation: The longitude of the eastern boundary of the map. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $EastLongitude;
    /**
     * The WestLongitude
     * Meta information extracted from the WSDL
     * - documentation: The longitude of the western boundary of the map. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $WestLongitude;
    /**
     * Constructor method for MapArea
     * @uses MapArea::setNorthLatitude()
     * @uses MapArea::setSouthLatitude()
     * @uses MapArea::setEastLongitude()
     * @uses MapArea::setWestLongitude()
     * @param string $northLatitude
     * @param string $southLatitude
     * @param string $eastLongitude
     * @param string $westLongitude
     */
    public function __construct($northLatitude = null, $southLatitude = null, $eastLongitude = null, $westLongitude = null)
    {
        $this
            ->setNorthLatitude($northLatitude)
            ->setSouthLatitude($southLatitude)
            ->setEastLongitude($eastLongitude)
            ->setWestLongitude($westLongitude);
    }
    /**
     * Get NorthLatitude value
     * @return string|null
     */
    public function getNorthLatitude()
    {
        return $this->NorthLatitude;
    }
    /**
     * Set NorthLatitude value
     * @param string $northLatitude
     * @return \StructType\MapArea
     */
    public function setNorthLatitude($northLatitude = null)
    {
        // validation for constraint: string
        if (!is_null($northLatitude) && !is_string($northLatitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($northLatitude, true), gettype($northLatitude)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($northLatitude) && mb_strlen($northLatitude) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($northLatitude)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($northLatitude) && mb_strlen($northLatitude) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($northLatitude)), __LINE__);
        }
        $this->NorthLatitude = $northLatitude;
        return $this;
    }
    /**
     * Get SouthLatitude value
     * @return string|null
     */
    public function getSouthLatitude()
    {
        return $this->SouthLatitude;
    }
    /**
     * Set SouthLatitude value
     * @param string $southLatitude
     * @return \StructType\MapArea
     */
    public function setSouthLatitude($southLatitude = null)
    {
        // validation for constraint: string
        if (!is_null($southLatitude) && !is_string($southLatitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($southLatitude, true), gettype($southLatitude)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($southLatitude) && mb_strlen($southLatitude) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($southLatitude)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($southLatitude) && mb_strlen($southLatitude) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($southLatitude)), __LINE__);
        }
        $this->SouthLatitude = $southLatitude;
        return $this;
    }
    /**
     * Get EastLongitude value
     * @return string|null
     */
    public function getEastLongitude()
    {
        return $this->EastLongitude;
    }
    /**
     * Set EastLongitude value
     * @param string $eastLongitude
     * @return \StructType\MapArea
     */
    public function setEastLongitude($eastLongitude = null)
    {
        // validation for constraint: string
        if (!is_null($eastLongitude) && !is_string($eastLongitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eastLongitude, true), gettype($eastLongitude)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($eastLongitude) && mb_strlen($eastLongitude) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($eastLongitude)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($eastLongitude) && mb_strlen($eastLongitude) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($eastLongitude)), __LINE__);
        }
        $this->EastLongitude = $eastLongitude;
        return $this;
    }
    /**
     * Get WestLongitude value
     * @return string|null
     */
    public function getWestLongitude()
    {
        return $this->WestLongitude;
    }
    /**
     * Set WestLongitude value
     * @param string $westLongitude
     * @return \StructType\MapArea
     */
    public function setWestLongitude($westLongitude = null)
    {
        // validation for constraint: string
        if (!is_null($westLongitude) && !is_string($westLongitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($westLongitude, true), gettype($westLongitude)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($westLongitude) && mb_strlen($westLongitude) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($westLongitude)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($westLongitude) && mb_strlen($westLongitude) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($westLongitude)), __LINE__);
        }
        $this->WestLongitude = $westLongitude;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MapArea
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
