<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ManifestType StructType
 * @subpackage Structs
 */
class ManifestType extends AbstractStructBase
{
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ds:Reference
     * @var \StructType\ReferenceType[]
     */
    public $Reference;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for ManifestType
     * @uses ManifestType::setReference()
     * @uses ManifestType::setId()
     * @param \StructType\ReferenceType[] $reference
     * @param string $id
     */
    public function __construct(array $reference = array(), $id = null)
    {
        $this
            ->setReference($reference)
            ->setId($id);
    }
    /**
     * Get Reference value
     * @return \StructType\ReferenceType[]|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferenceForArrayConstraintsFromSetReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $manifestTypeReferenceItem) {
            // validation for constraint: itemType
            if (!$manifestTypeReferenceItem instanceof \StructType\ReferenceType) {
                $invalidValues[] = is_object($manifestTypeReferenceItem) ? get_class($manifestTypeReferenceItem) : sprintf('%s(%s)', gettype($manifestTypeReferenceItem), var_export($manifestTypeReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Reference property can only contain items of type \StructType\ReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\ReferenceType[] $reference
     * @return \StructType\ManifestType
     */
    public function setReference(array $reference = array())
    {
        // validation for constraint: array
        if ('' !== ($referenceArrayErrorMessage = self::validateReferenceForArrayConstraintsFromSetReference($reference))) {
            throw new \InvalidArgumentException($referenceArrayErrorMessage, __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Add item to Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\ReferenceType $item
     * @return \StructType\ManifestType
     */
    public function addToReference(\StructType\ReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReferenceType) {
            throw new \InvalidArgumentException(sprintf('The Reference property can only contain items of type \StructType\ReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Reference[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\ManifestType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ManifestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
