<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoyaltyProgramType StructType
 * Meta information extracted from the WSDL
 * - documentation: Indicates the alliance status of the loyalty program. | Identifies a membership or loyalty program offered by the company by name of the program. | Used for Character Strings, length 0 to 32.
 * - base: xs:string
 * - maxLength: 32
 * - minLength: 0
 * @subpackage Structs
 */
class LoyaltyProgramType extends AbstractStructBase
{
    /**
     * The _
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 0 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 0
     * @var string
     */
    public $_;
    /**
     * The ProgramCode
     * Meta information extracted from the WSDL
     * - documentation: Identification of the loyalty program by code. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $ProgramCode;
    /**
     * The LoyaltyLevel
     * Meta information extracted from the WSDL
     * - documentation: Indicates special privileges in program assigned to individual. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $LoyaltyLevel;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: A unique reference for a loyalty program within this message. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients to
     * particular itinerary items).
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The PrimaryLoyaltyIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates this is the primary loyalty program and when false, indicates this is not the primary loyalty program.
     * - use: optional
     * @var bool
     */
    public $PrimaryLoyaltyIndicator;
    /**
     * The SingleVendorInd
     * @var string
     */
    public $SingleVendorInd;
    /**
     * Constructor method for LoyaltyProgramType
     * @uses LoyaltyProgramType::set_()
     * @uses LoyaltyProgramType::setProgramCode()
     * @uses LoyaltyProgramType::setLoyaltyLevel()
     * @uses LoyaltyProgramType::setRPH()
     * @uses LoyaltyProgramType::setPrimaryLoyaltyIndicator()
     * @uses LoyaltyProgramType::setSingleVendorInd()
     * @param string $_
     * @param string $programCode
     * @param string $loyaltyLevel
     * @param string $rPH
     * @param bool $primaryLoyaltyIndicator
     * @param string $singleVendorInd
     */
    public function __construct($_ = null, $programCode = null, $loyaltyLevel = null, $rPH = null, $primaryLoyaltyIndicator = null, $singleVendorInd = null)
    {
        $this
            ->set_($_)
            ->setProgramCode($programCode)
            ->setLoyaltyLevel($loyaltyLevel)
            ->setRPH($rPH)
            ->setPrimaryLoyaltyIndicator($primaryLoyaltyIndicator)
            ->setSingleVendorInd($singleVendorInd);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\LoyaltyProgramType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($_) && mb_strlen($_) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($_)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($_) && mb_strlen($_) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get ProgramCode value
     * @return string|null
     */
    public function getProgramCode()
    {
        return $this->ProgramCode;
    }
    /**
     * Set ProgramCode value
     * @param string $programCode
     * @return \StructType\LoyaltyProgramType
     */
    public function setProgramCode($programCode = null)
    {
        // validation for constraint: string
        if (!is_null($programCode) && !is_string($programCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programCode, true), gettype($programCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($programCode) && mb_strlen($programCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($programCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($programCode) && mb_strlen($programCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($programCode)), __LINE__);
        }
        $this->ProgramCode = $programCode;
        return $this;
    }
    /**
     * Get LoyaltyLevel value
     * @return string|null
     */
    public function getLoyaltyLevel()
    {
        return $this->LoyaltyLevel;
    }
    /**
     * Set LoyaltyLevel value
     * @param string $loyaltyLevel
     * @return \StructType\LoyaltyProgramType
     */
    public function setLoyaltyLevel($loyaltyLevel = null)
    {
        // validation for constraint: string
        if (!is_null($loyaltyLevel) && !is_string($loyaltyLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loyaltyLevel, true), gettype($loyaltyLevel)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($loyaltyLevel) && mb_strlen($loyaltyLevel) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($loyaltyLevel)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($loyaltyLevel) && mb_strlen($loyaltyLevel) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($loyaltyLevel)), __LINE__);
        }
        $this->LoyaltyLevel = $loyaltyLevel;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\LoyaltyProgramType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($rPH) && !preg_match('/[0-9]{1,8}/', $rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($rPH, true)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get PrimaryLoyaltyIndicator value
     * @return bool|null
     */
    public function getPrimaryLoyaltyIndicator()
    {
        return $this->PrimaryLoyaltyIndicator;
    }
    /**
     * Set PrimaryLoyaltyIndicator value
     * @param bool $primaryLoyaltyIndicator
     * @return \StructType\LoyaltyProgramType
     */
    public function setPrimaryLoyaltyIndicator($primaryLoyaltyIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($primaryLoyaltyIndicator) && !is_bool($primaryLoyaltyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($primaryLoyaltyIndicator, true), gettype($primaryLoyaltyIndicator)), __LINE__);
        }
        $this->PrimaryLoyaltyIndicator = $primaryLoyaltyIndicator;
        return $this;
    }
    /**
     * Get SingleVendorInd value
     * @return string|null
     */
    public function getSingleVendorInd()
    {
        return $this->SingleVendorInd;
    }
    /**
     * Set SingleVendorInd value
     * @param string $singleVendorInd
     * @return \StructType\LoyaltyProgramType
     */
    public function setSingleVendorInd($singleVendorInd = null)
    {
        // validation for constraint: string
        if (!is_null($singleVendorInd) && !is_string($singleVendorInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($singleVendorInd, true), gettype($singleVendorInd)), __LINE__);
        }
        $this->SingleVendorInd = $singleVendorInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LoyaltyProgramType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
