<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LatestReturn StructType
 * Meta information extracted from the WSDL
 * - documentation: The latest day and time a vehicle can be returned to qualify for a specific rate.
 * @subpackage Structs
 */
class LatestReturn extends AbstractStructBase
{
    /**
     * The DayOfWeek
     * Meta information extracted from the WSDL
     * - documentation: The latest day of the week the rental can terminate to qualify for the specific rate.
     * - use: optional
     * @var string
     */
    public $DayOfWeek;
    /**
     * The Time
     * Meta information extracted from the WSDL
     * - documentation: The latest time, in conjunction with the DayOfWeek, the rental can terminate to qualify for the specific rate. | Allows for the specification of a date time or just time.
     * - union: dateTime | time
     * - use: optional
     * @var string
     */
    public $Time;
    /**
     * Constructor method for LatestReturn
     * @uses LatestReturn::setDayOfWeek()
     * @uses LatestReturn::setTime()
     * @param string $dayOfWeek
     * @param string $time
     */
    public function __construct($dayOfWeek = null, $time = null)
    {
        $this
            ->setDayOfWeek($dayOfWeek)
            ->setTime($time);
    }
    /**
     * Get DayOfWeek value
     * @return string|null
     */
    public function getDayOfWeek()
    {
        return $this->DayOfWeek;
    }
    /**
     * Set DayOfWeek value
     * @uses \EnumType\DayOfWeekType::valueIsValid()
     * @uses \EnumType\DayOfWeekType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dayOfWeek
     * @return \StructType\LatestReturn
     */
    public function setDayOfWeek($dayOfWeek = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DayOfWeekType::valueIsValid($dayOfWeek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DayOfWeekType', is_array($dayOfWeek) ? implode(', ', $dayOfWeek) : var_export($dayOfWeek, true), implode(', ', \EnumType\DayOfWeekType::getValidValues())), __LINE__);
        }
        $this->DayOfWeek = $dayOfWeek;
        return $this;
    }
    /**
     * Get Time value
     * @return string|null
     */
    public function getTime()
    {
        return $this->Time;
    }
    /**
     * This method is responsible for validating the value passed to the setTime method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTime method
     * This is a set of validation rules based on the union types associated to the property being set by the setTime method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTimeForUnionConstraintsFromSetTime($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set Time value
     * @param string $time
     * @return \StructType\LatestReturn
     */
    public function setTime($time = null)
    {
        // validation for constraint: string
        if (!is_null($time) && !is_string($time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($time, true), gettype($time)), __LINE__);
        }
        // validation for constraint: union(dateTime, time)
        if ('' !== ($timeUnionErrorMessage = self::validateTimeForUnionConstraintsFromSetTime($time))) {
            throw new \InvalidArgumentException($timeUnionErrorMessage, __LINE__);
        }
        $this->Time = $time;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LatestReturn
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
