<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvBlockDates StructType
 * Meta information extracted from the WSDL
 * - documentation: This is used to indicate the date or date range applicable to this inventory block.
 * @subpackage Structs
 */
class InvBlockDates extends AbstractStructBase
{
    /**
     * The EndDateExtensionIndicator
     * Meta information extracted from the WSDL
     * - documentation: If true, this indicates that the block has no tangible end date. The block continues indefinitely.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $EndDateExtensionIndicator;
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a time or a dateTime value.
     * - union: date | dateTime | time
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - documentation: Allows for the specification of a night duration.
     * - union: duration | NightDurationType
     * @var string
     */
    public $Duration;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a time or a dateTime value.
     * - union: date | dateTime | time
     * @var string
     */
    public $End;
    /**
     * The AbsoluteCutoff
     * Meta information extracted from the WSDL
     * - documentation: Defines the absolute deadline. Either this or the offset attributes may be used. | A construct to validate either a date or a time or a dateTime value.
     * - type: DateOrTimeOrDateTimeType
     * - union: date | dateTime | time
     * - use: optional
     * @var string
     */
    public $AbsoluteCutoff;
    /**
     * The OffsetDuration
     * Meta information extracted from the WSDL
     * - documentation: The units of time, e.g.: days, hours, etc., that apply to the deadline.
     * - type: xs:duration
     * - use: optional
     * @var string
     */
    public $OffsetDuration;
    /**
     * The OffsetCalculationMode
     * @var string
     */
    public $OffsetCalculationMode;
    /**
     * Constructor method for InvBlockDates
     * @uses InvBlockDates::setEndDateExtensionIndicator()
     * @uses InvBlockDates::setStart()
     * @uses InvBlockDates::setDuration()
     * @uses InvBlockDates::setEnd()
     * @uses InvBlockDates::setAbsoluteCutoff()
     * @uses InvBlockDates::setOffsetDuration()
     * @uses InvBlockDates::setOffsetCalculationMode()
     * @param bool $endDateExtensionIndicator
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param string $absoluteCutoff
     * @param string $offsetDuration
     * @param string $offsetCalculationMode
     */
    public function __construct($endDateExtensionIndicator = null, $start = null, $duration = null, $end = null, $absoluteCutoff = null, $offsetDuration = null, $offsetCalculationMode = null)
    {
        $this
            ->setEndDateExtensionIndicator($endDateExtensionIndicator)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setAbsoluteCutoff($absoluteCutoff)
            ->setOffsetDuration($offsetDuration)
            ->setOffsetCalculationMode($offsetCalculationMode);
    }
    /**
     * Get EndDateExtensionIndicator value
     * @return bool|null
     */
    public function getEndDateExtensionIndicator()
    {
        return $this->EndDateExtensionIndicator;
    }
    /**
     * Set EndDateExtensionIndicator value
     * @param bool $endDateExtensionIndicator
     * @return \StructType\InvBlockDates
     */
    public function setEndDateExtensionIndicator($endDateExtensionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($endDateExtensionIndicator) && !is_bool($endDateExtensionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($endDateExtensionIndicator, true), gettype($endDateExtensionIndicator)), __LINE__);
        }
        $this->EndDateExtensionIndicator = $endDateExtensionIndicator;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * This method is responsible for validating the value passed to the setStart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStart method
     * This is a set of validation rules based on the union types associated to the property being set by the setStart method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStartForUnionConstraintsFromSetStart($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\InvBlockDates
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($startUnionErrorMessage = self::validateStartForUnionConstraintsFromSetStart($start))) {
            throw new \InvalidArgumentException($startUnionErrorMessage, __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * This method is responsible for validating the value passed to the setDuration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDuration method
     * This is a set of validation rules based on the union types associated to the property being set by the setDuration method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDurationForUnionConstraintsFromSetDuration($value)
    {
        $message = '';
        // validation for constraint: pattern(P[0-9]{1,3}N)
        if (!is_null($value) && !preg_match('/P[0-9]{1,3}N/', $value)) {
            $exception0 = new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression P[0-9]{1,3}N', var_export($value, true)), __LINE__);
        }
        if (isset($exception0)) {
            $message = sprintf("The value %s does not match any of the union rules: duration, NightDurationType. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [$exception0])));
        }
        unset($exception0);
        return $message;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\InvBlockDates
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        // validation for constraint: union(duration, NightDurationType)
        if ('' !== ($durationUnionErrorMessage = self::validateDurationForUnionConstraintsFromSetDuration($duration))) {
            throw new \InvalidArgumentException($durationUnionErrorMessage, __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * This method is responsible for validating the value passed to the setEnd method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEnd method
     * This is a set of validation rules based on the union types associated to the property being set by the setEnd method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEndForUnionConstraintsFromSetEnd($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\InvBlockDates
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($endUnionErrorMessage = self::validateEndForUnionConstraintsFromSetEnd($end))) {
            throw new \InvalidArgumentException($endUnionErrorMessage, __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get AbsoluteCutoff value
     * @return string|null
     */
    public function getAbsoluteCutoff()
    {
        return $this->AbsoluteCutoff;
    }
    /**
     * This method is responsible for validating the value passed to the setAbsoluteCutoff method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAbsoluteCutoff method
     * This is a set of validation rules based on the union types associated to the property being set by the setAbsoluteCutoff method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAbsoluteCutoffForUnionConstraintsFromSetAbsoluteCutoff($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set AbsoluteCutoff value
     * @param string $absoluteCutoff
     * @return \StructType\InvBlockDates
     */
    public function setAbsoluteCutoff($absoluteCutoff = null)
    {
        // validation for constraint: string
        if (!is_null($absoluteCutoff) && !is_string($absoluteCutoff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($absoluteCutoff, true), gettype($absoluteCutoff)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($absoluteCutoffUnionErrorMessage = self::validateAbsoluteCutoffForUnionConstraintsFromSetAbsoluteCutoff($absoluteCutoff))) {
            throw new \InvalidArgumentException($absoluteCutoffUnionErrorMessage, __LINE__);
        }
        $this->AbsoluteCutoff = $absoluteCutoff;
        return $this;
    }
    /**
     * Get OffsetDuration value
     * @return string|null
     */
    public function getOffsetDuration()
    {
        return $this->OffsetDuration;
    }
    /**
     * Set OffsetDuration value
     * @param string $offsetDuration
     * @return \StructType\InvBlockDates
     */
    public function setOffsetDuration($offsetDuration = null)
    {
        // validation for constraint: string
        if (!is_null($offsetDuration) && !is_string($offsetDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offsetDuration, true), gettype($offsetDuration)), __LINE__);
        }
        $this->OffsetDuration = $offsetDuration;
        return $this;
    }
    /**
     * Get OffsetCalculationMode value
     * @return string|null
     */
    public function getOffsetCalculationMode()
    {
        return $this->OffsetCalculationMode;
    }
    /**
     * Set OffsetCalculationMode value
     * @param string $offsetCalculationMode
     * @return \StructType\InvBlockDates
     */
    public function setOffsetCalculationMode($offsetCalculationMode = null)
    {
        // validation for constraint: string
        if (!is_null($offsetCalculationMode) && !is_string($offsetCalculationMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offsetCalculationMode, true), gettype($offsetCalculationMode)), __LINE__);
        }
        $this->OffsetCalculationMode = $offsetCalculationMode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvBlockDates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
