<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelStay StructType
 * Meta information extracted from the WSDL
 * - documentation: A quick view of the requested hotels' general availability for each day in the requested range.
 * @subpackage Structs
 */
class HotelStay extends AbstractStructBase
{
    /**
     * The Availability
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Availability[]
     */
    public $Availability;
    /**
     * The BasicPropertyInfo
     * Meta information extracted from the WSDL
     * - documentation: Property Information for the Hotel Stay.
     * - minOccurs: 0
     * @var \StructType\BasicPropertyInfoType
     */
    public $BasicPropertyInfo;
    /**
     * The RoomStayRPH
     * Meta information extracted from the WSDL
     * - documentation: References one or more room stays associated with this hotel stay. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients
     * to particular itinerary items). | List of Reference Place Holders.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string[]
     */
    public $RoomStayRPH;
    /**
     * Constructor method for HotelStay
     * @uses HotelStay::setAvailability()
     * @uses HotelStay::setBasicPropertyInfo()
     * @uses HotelStay::setRoomStayRPH()
     * @param \StructType\Availability[] $availability
     * @param \StructType\BasicPropertyInfoType $basicPropertyInfo
     * @param string[] $roomStayRPH
     */
    public function __construct(array $availability = array(), \StructType\BasicPropertyInfoType $basicPropertyInfo = null, array $roomStayRPH = array())
    {
        $this
            ->setAvailability($availability)
            ->setBasicPropertyInfo($basicPropertyInfo)
            ->setRoomStayRPH($roomStayRPH);
    }
    /**
     * Get Availability value
     * @return \StructType\Availability[]|null
     */
    public function getAvailability()
    {
        return $this->Availability;
    }
    /**
     * This method is responsible for validating the values passed to the setAvailability method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAvailability method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAvailabilityForArrayConstraintsFromSetAvailability(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelStayAvailabilityItem) {
            // validation for constraint: itemType
            if (!$hotelStayAvailabilityItem instanceof \StructType\Availability) {
                $invalidValues[] = is_object($hotelStayAvailabilityItem) ? get_class($hotelStayAvailabilityItem) : sprintf('%s(%s)', gettype($hotelStayAvailabilityItem), var_export($hotelStayAvailabilityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Availability property can only contain items of type \StructType\Availability, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Availability value
     * @throws \InvalidArgumentException
     * @param \StructType\Availability[] $availability
     * @return \StructType\HotelStay
     */
    public function setAvailability(array $availability = array())
    {
        // validation for constraint: array
        if ('' !== ($availabilityArrayErrorMessage = self::validateAvailabilityForArrayConstraintsFromSetAvailability($availability))) {
            throw new \InvalidArgumentException($availabilityArrayErrorMessage, __LINE__);
        }
        $this->Availability = $availability;
        return $this;
    }
    /**
     * Add item to Availability value
     * @throws \InvalidArgumentException
     * @param \StructType\Availability $item
     * @return \StructType\HotelStay
     */
    public function addToAvailability(\StructType\Availability $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Availability) {
            throw new \InvalidArgumentException(sprintf('The Availability property can only contain items of type \StructType\Availability, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Availability[] = $item;
        return $this;
    }
    /**
     * Get BasicPropertyInfo value
     * @return \StructType\BasicPropertyInfoType|null
     */
    public function getBasicPropertyInfo()
    {
        return $this->BasicPropertyInfo;
    }
    /**
     * Set BasicPropertyInfo value
     * @param \StructType\BasicPropertyInfoType $basicPropertyInfo
     * @return \StructType\HotelStay
     */
    public function setBasicPropertyInfo(\StructType\BasicPropertyInfoType $basicPropertyInfo = null)
    {
        $this->BasicPropertyInfo = $basicPropertyInfo;
        return $this;
    }
    /**
     * Get RoomStayRPH value
     * @return string[]|null
     */
    public function getRoomStayRPH()
    {
        return $this->RoomStayRPH;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomStayRPH method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomStayRPH method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomStayRPHForArrayConstraintsFromSetRoomStayRPH(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelStayRoomStayRPHItem) {
            // validation for constraint: itemType
            if (!is_string($hotelStayRoomStayRPHItem)) {
                $invalidValues[] = is_object($hotelStayRoomStayRPHItem) ? get_class($hotelStayRoomStayRPHItem) : sprintf('%s(%s)', gettype($hotelStayRoomStayRPHItem), var_export($hotelStayRoomStayRPHItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomStayRPH property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomStayRPH value
     * @param string[] $roomStayRPH
     * @return \StructType\HotelStay
     */
    public function setRoomStayRPH(array $roomStayRPH = array())
    {
        // validation for constraint: list
        if ('' !== ($roomStayRPHArrayErrorMessage = self::validateRoomStayRPHForArrayConstraintsFromSetRoomStayRPH($roomStayRPH))) {
            throw new \InvalidArgumentException($roomStayRPHArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($roomStayRPH) && !preg_match('/[0-9]{1,8}/', $roomStayRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($roomStayRPH, true)), __LINE__);
        }
        $this->RoomStayRPH = is_array($roomStayRPH) ? implode(' ', $roomStayRPH) : null;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelStay
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
