<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelRoomListType StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides the details of a rooming list.
 * @subpackage Structs
 */
class HotelRoomListType extends AbstractStructBase
{
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - documentation: The unique indicator for the group rooming list or tour operator booking reference.
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type
     */
    public $UniqueID;
    /**
     * The Guests
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Guests
     */
    public $Guests;
    /**
     * The MasterContact
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MasterContact
     */
    public $MasterContact;
    /**
     * The MasterAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MasterAccount
     */
    public $MasterAccount;
    /**
     * The RoomStays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RoomStays
     */
    public $RoomStays;
    /**
     * The Event
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Event
     */
    public $Event;
    /**
     * The GroupBlockCode
     * Meta information extracted from the WSDL
     * - documentation: The code that identifies which group within a specific hotel for which this room list has been provided. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $GroupBlockCode;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - documentation: Date this room list was initially created.
     * - use: optional
     * @var string
     */
    public $CreationDate;
    /**
     * The ChainCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $ChainCode;
    /**
     * The BrandCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $BrandCode;
    /**
     * The HotelCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $HotelCode;
    /**
     * The HotelCityCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $HotelCityCode;
    /**
     * The HotelName
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 128.
     * - base: xs:string
     * - maxLength: 128
     * - minLength: 1
     * @var string
     */
    public $HotelName;
    /**
     * The HotelCodeContext
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $HotelCodeContext;
    /**
     * The ChainName
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $ChainName;
    /**
     * The BrandName
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $BrandName;
    /**
     * The AreaID
     * Meta information extracted from the WSDL
     * - documentation: Used for Numeric Strings, length 1 to 8.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * @var string
     */
    public $AreaID;
    /**
     * Constructor method for HotelRoomListType
     * @uses HotelRoomListType::setUniqueID()
     * @uses HotelRoomListType::setGuests()
     * @uses HotelRoomListType::setMasterContact()
     * @uses HotelRoomListType::setMasterAccount()
     * @uses HotelRoomListType::setRoomStays()
     * @uses HotelRoomListType::setEvent()
     * @uses HotelRoomListType::setGroupBlockCode()
     * @uses HotelRoomListType::setCreationDate()
     * @uses HotelRoomListType::setChainCode()
     * @uses HotelRoomListType::setBrandCode()
     * @uses HotelRoomListType::setHotelCode()
     * @uses HotelRoomListType::setHotelCityCode()
     * @uses HotelRoomListType::setHotelName()
     * @uses HotelRoomListType::setHotelCodeContext()
     * @uses HotelRoomListType::setChainName()
     * @uses HotelRoomListType::setBrandName()
     * @uses HotelRoomListType::setAreaID()
     * @param \StructType\UniqueID_Type $uniqueID
     * @param \StructType\Guests $guests
     * @param \StructType\MasterContact $masterContact
     * @param \StructType\MasterAccount $masterAccount
     * @param \StructType\RoomStays $roomStays
     * @param \StructType\Event $event
     * @param string $groupBlockCode
     * @param string $creationDate
     * @param string $chainCode
     * @param string $brandCode
     * @param string $hotelCode
     * @param string $hotelCityCode
     * @param string $hotelName
     * @param string $hotelCodeContext
     * @param string $chainName
     * @param string $brandName
     * @param string $areaID
     */
    public function __construct(\StructType\UniqueID_Type $uniqueID = null, \StructType\Guests $guests = null, \StructType\MasterContact $masterContact = null, \StructType\MasterAccount $masterAccount = null, \StructType\RoomStays $roomStays = null, \StructType\Event $event = null, $groupBlockCode = null, $creationDate = null, $chainCode = null, $brandCode = null, $hotelCode = null, $hotelCityCode = null, $hotelName = null, $hotelCodeContext = null, $chainName = null, $brandName = null, $areaID = null)
    {
        $this
            ->setUniqueID($uniqueID)
            ->setGuests($guests)
            ->setMasterContact($masterContact)
            ->setMasterAccount($masterAccount)
            ->setRoomStays($roomStays)
            ->setEvent($event)
            ->setGroupBlockCode($groupBlockCode)
            ->setCreationDate($creationDate)
            ->setChainCode($chainCode)
            ->setBrandCode($brandCode)
            ->setHotelCode($hotelCode)
            ->setHotelCityCode($hotelCityCode)
            ->setHotelName($hotelName)
            ->setHotelCodeContext($hotelCodeContext)
            ->setChainName($chainName)
            ->setBrandName($brandName)
            ->setAreaID($areaID);
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID_Type|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \StructType\UniqueID_Type $uniqueID
     * @return \StructType\HotelRoomListType
     */
    public function setUniqueID(\StructType\UniqueID_Type $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get Guests value
     * @return \StructType\Guests|null
     */
    public function getGuests()
    {
        return $this->Guests;
    }
    /**
     * Set Guests value
     * @param \StructType\Guests $guests
     * @return \StructType\HotelRoomListType
     */
    public function setGuests(\StructType\Guests $guests = null)
    {
        $this->Guests = $guests;
        return $this;
    }
    /**
     * Get MasterContact value
     * @return \StructType\MasterContact|null
     */
    public function getMasterContact()
    {
        return $this->MasterContact;
    }
    /**
     * Set MasterContact value
     * @param \StructType\MasterContact $masterContact
     * @return \StructType\HotelRoomListType
     */
    public function setMasterContact(\StructType\MasterContact $masterContact = null)
    {
        $this->MasterContact = $masterContact;
        return $this;
    }
    /**
     * Get MasterAccount value
     * @return \StructType\MasterAccount|null
     */
    public function getMasterAccount()
    {
        return $this->MasterAccount;
    }
    /**
     * Set MasterAccount value
     * @param \StructType\MasterAccount $masterAccount
     * @return \StructType\HotelRoomListType
     */
    public function setMasterAccount(\StructType\MasterAccount $masterAccount = null)
    {
        $this->MasterAccount = $masterAccount;
        return $this;
    }
    /**
     * Get RoomStays value
     * @return \StructType\RoomStays|null
     */
    public function getRoomStays()
    {
        return $this->RoomStays;
    }
    /**
     * Set RoomStays value
     * @param \StructType\RoomStays $roomStays
     * @return \StructType\HotelRoomListType
     */
    public function setRoomStays(\StructType\RoomStays $roomStays = null)
    {
        $this->RoomStays = $roomStays;
        return $this;
    }
    /**
     * Get Event value
     * @return \StructType\Event|null
     */
    public function getEvent()
    {
        return $this->Event;
    }
    /**
     * Set Event value
     * @param \StructType\Event $event
     * @return \StructType\HotelRoomListType
     */
    public function setEvent(\StructType\Event $event = null)
    {
        $this->Event = $event;
        return $this;
    }
    /**
     * Get GroupBlockCode value
     * @return string|null
     */
    public function getGroupBlockCode()
    {
        return $this->GroupBlockCode;
    }
    /**
     * Set GroupBlockCode value
     * @param string $groupBlockCode
     * @return \StructType\HotelRoomListType
     */
    public function setGroupBlockCode($groupBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($groupBlockCode) && !is_string($groupBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupBlockCode, true), gettype($groupBlockCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($groupBlockCode) && mb_strlen($groupBlockCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($groupBlockCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($groupBlockCode) && mb_strlen($groupBlockCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($groupBlockCode)), __LINE__);
        }
        $this->GroupBlockCode = $groupBlockCode;
        return $this;
    }
    /**
     * Get CreationDate value
     * @return string|null
     */
    public function getCreationDate()
    {
        return $this->CreationDate;
    }
    /**
     * Set CreationDate value
     * @param string $creationDate
     * @return \StructType\HotelRoomListType
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        $this->CreationDate = $creationDate;
        return $this;
    }
    /**
     * Get ChainCode value
     * @return string|null
     */
    public function getChainCode()
    {
        return $this->ChainCode;
    }
    /**
     * Set ChainCode value
     * @param string $chainCode
     * @return \StructType\HotelRoomListType
     */
    public function setChainCode($chainCode = null)
    {
        // validation for constraint: string
        if (!is_null($chainCode) && !is_string($chainCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chainCode, true), gettype($chainCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($chainCode) && mb_strlen($chainCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($chainCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($chainCode) && mb_strlen($chainCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($chainCode)), __LINE__);
        }
        $this->ChainCode = $chainCode;
        return $this;
    }
    /**
     * Get BrandCode value
     * @return string|null
     */
    public function getBrandCode()
    {
        return $this->BrandCode;
    }
    /**
     * Set BrandCode value
     * @param string $brandCode
     * @return \StructType\HotelRoomListType
     */
    public function setBrandCode($brandCode = null)
    {
        // validation for constraint: string
        if (!is_null($brandCode) && !is_string($brandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brandCode, true), gettype($brandCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($brandCode) && mb_strlen($brandCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($brandCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($brandCode) && mb_strlen($brandCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($brandCode)), __LINE__);
        }
        $this->BrandCode = $brandCode;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \StructType\HotelRoomListType
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCode, true), gettype($hotelCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($hotelCode) && mb_strlen($hotelCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($hotelCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($hotelCode) && mb_strlen($hotelCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get HotelCityCode value
     * @return string|null
     */
    public function getHotelCityCode()
    {
        return $this->HotelCityCode;
    }
    /**
     * Set HotelCityCode value
     * @param string $hotelCityCode
     * @return \StructType\HotelRoomListType
     */
    public function setHotelCityCode($hotelCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCityCode) && !is_string($hotelCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCityCode, true), gettype($hotelCityCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($hotelCityCode) && mb_strlen($hotelCityCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($hotelCityCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($hotelCityCode) && mb_strlen($hotelCityCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($hotelCityCode)), __LINE__);
        }
        $this->HotelCityCode = $hotelCityCode;
        return $this;
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \StructType\HotelRoomListType
     */
    public function setHotelName($hotelName = null)
    {
        // validation for constraint: string
        if (!is_null($hotelName) && !is_string($hotelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelName, true), gettype($hotelName)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($hotelName) && mb_strlen($hotelName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($hotelName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($hotelName) && mb_strlen($hotelName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($hotelName)), __LINE__);
        }
        $this->HotelName = $hotelName;
        return $this;
    }
    /**
     * Get HotelCodeContext value
     * @return string|null
     */
    public function getHotelCodeContext()
    {
        return $this->HotelCodeContext;
    }
    /**
     * Set HotelCodeContext value
     * @param string $hotelCodeContext
     * @return \StructType\HotelRoomListType
     */
    public function setHotelCodeContext($hotelCodeContext = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCodeContext) && !is_string($hotelCodeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCodeContext, true), gettype($hotelCodeContext)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($hotelCodeContext) && mb_strlen($hotelCodeContext) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($hotelCodeContext)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($hotelCodeContext) && mb_strlen($hotelCodeContext) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($hotelCodeContext)), __LINE__);
        }
        $this->HotelCodeContext = $hotelCodeContext;
        return $this;
    }
    /**
     * Get ChainName value
     * @return string|null
     */
    public function getChainName()
    {
        return $this->ChainName;
    }
    /**
     * Set ChainName value
     * @param string $chainName
     * @return \StructType\HotelRoomListType
     */
    public function setChainName($chainName = null)
    {
        // validation for constraint: string
        if (!is_null($chainName) && !is_string($chainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chainName, true), gettype($chainName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($chainName) && mb_strlen($chainName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($chainName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($chainName) && mb_strlen($chainName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($chainName)), __LINE__);
        }
        $this->ChainName = $chainName;
        return $this;
    }
    /**
     * Get BrandName value
     * @return string|null
     */
    public function getBrandName()
    {
        return $this->BrandName;
    }
    /**
     * Set BrandName value
     * @param string $brandName
     * @return \StructType\HotelRoomListType
     */
    public function setBrandName($brandName = null)
    {
        // validation for constraint: string
        if (!is_null($brandName) && !is_string($brandName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brandName, true), gettype($brandName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($brandName) && mb_strlen($brandName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($brandName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($brandName) && mb_strlen($brandName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($brandName)), __LINE__);
        }
        $this->BrandName = $brandName;
        return $this;
    }
    /**
     * Get AreaID value
     * @return string|null
     */
    public function getAreaID()
    {
        return $this->AreaID;
    }
    /**
     * Set AreaID value
     * @param string $areaID
     * @return \StructType\HotelRoomListType
     */
    public function setAreaID($areaID = null)
    {
        // validation for constraint: string
        if (!is_null($areaID) && !is_string($areaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaID, true), gettype($areaID)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($areaID) && !preg_match('/[0-9]{1,8}/', $areaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($areaID, true)), __LINE__);
        }
        $this->AreaID = $areaID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelRoomListType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
