<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelReservationType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Reservation class contains the current reservation being created or altered.
 * @subpackage Structs
 */
class HotelReservationType extends AbstractStructBase
{
    /**
     * The POS
     * Meta information extracted from the WSDL
     * - documentation: Identifies who made the original reservation.
     * - minOccurs: 0
     * @var \StructType\POS_Type
     */
    public $POS;
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - documentation: Used to provide PMS and/or CRS identifiers.
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type[]
     */
    public $UniqueID;
    /**
     * The RoomStays
     * Meta information extracted from the WSDL
     * - documentation: Collection of room stays.
     * - minOccurs: 0
     * @var \StructType\RoomStaysType
     */
    public $RoomStays;
    /**
     * The Services
     * Meta information extracted from the WSDL
     * - documentation: Collection of services.
     * - minOccurs: 0
     * @var \StructType\ServicesType
     */
    public $Services;
    /**
     * The ResGuests
     * Meta information extracted from the WSDL
     * - documentation: Collection of guests associated with the reservation.
     * - minOccurs: 0
     * @var \StructType\ResGuestsType
     */
    public $ResGuests;
    /**
     * The ResGlobalInfo
     * Meta information extracted from the WSDL
     * - documentation: ResGlobalInfo is a container for various information that affects the Reservation as a whole. These include global comments, counts, reservation IDs, loyalty programs, and payment methods.
     * - minOccurs: 0
     * @var \StructType\ResGlobalInfoType
     */
    public $ResGlobalInfo;
    /**
     * The WrittenConfInst
     * Meta information extracted from the WSDL
     * - documentation: To indicate a confirmation is to be sent for this reservation.
     * - minOccurs: 0
     * @var \StructType\WrittenConfInstType
     */
    public $WrittenConfInst;
    /**
     * The Queue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Queue
     */
    public $Queue;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var \StructType\TPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The RoomStayReservation
     * Meta information extracted from the WSDL
     * - documentation: Boolean True if this reservation is reserving rooms. False if it is only reserving services.
     * - use: optional
     * @var bool
     */
    public $RoomStayReservation;
    /**
     * The ResStatus
     * Meta information extracted from the WSDL
     * - documentation: Indicates the status of the reservation. | A union between TransactionActionType and PMS_ResStatusType. Used in messages that communicate between reservation systems as well as between a reservation and property management system. In
     * addition to the TransactionActionType and PMS_ResStatusType, the UpperCaseAlphaLength1to2 may be used for company specifc codes.
     * - union: PMS_ResStatusType | TransactionActionType | UpperCaseAlphaLength1to2
     * - use: optional
     * @var string
     */
    public $ResStatus;
    /**
     * The ForcedSellIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates a sell was forced even if there are restrictions or no availability.
     * - use: optional
     * @var bool
     */
    public $ForcedSellIndicator;
    /**
     * The ServiceOverrideIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates a service has been overridden.
     * - use: optional
     * @var bool
     */
    public $ServiceOverrideIndicator;
    /**
     * The RateOverrideIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates a rate has been overridden.
     * - use: optional
     * @var bool
     */
    public $RateOverrideIndicator;
    /**
     * The WalkInIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates the reservation is for a guest that walks-in without a reservation. When false, the reservation is not a walk-in.
     * - use: optional
     * @var bool
     */
    public $WalkInIndicator;
    /**
     * The RoomNumberLockedIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates a room number cannot be changed. When false, indicates a room number may be changed.
     * - use: optional
     * @var bool
     */
    public $RoomNumberLockedIndicator;
    /**
     * The OriginalDeliveryMethodCode
     * Meta information extracted from the WSDL
     * - documentation: The method by which the original reservation was delivered. Refer to OpenTravel Code list Distribution Type (DTB). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $OriginalDeliveryMethodCode;
    /**
     * The PassiveIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates that this item is included for information only and no action should be taken.
     * - use: optional
     * @var bool
     */
    public $PassiveIndicator;
    /**
     * The CreateDateTime
     * @var string
     */
    public $CreateDateTime;
    /**
     * The CreatorID
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $CreatorID;
    /**
     * The LastModifyDateTime
     * @var string
     */
    public $LastModifyDateTime;
    /**
     * The LastModifierID
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $LastModifierID;
    /**
     * The PurgeDate
     * @var string
     */
    public $PurgeDate;
    /**
     * Constructor method for HotelReservationType
     * @uses HotelReservationType::setPOS()
     * @uses HotelReservationType::setUniqueID()
     * @uses HotelReservationType::setRoomStays()
     * @uses HotelReservationType::setServices()
     * @uses HotelReservationType::setResGuests()
     * @uses HotelReservationType::setResGlobalInfo()
     * @uses HotelReservationType::setWrittenConfInst()
     * @uses HotelReservationType::setQueue()
     * @uses HotelReservationType::setTPA_Extensions()
     * @uses HotelReservationType::setRoomStayReservation()
     * @uses HotelReservationType::setResStatus()
     * @uses HotelReservationType::setForcedSellIndicator()
     * @uses HotelReservationType::setServiceOverrideIndicator()
     * @uses HotelReservationType::setRateOverrideIndicator()
     * @uses HotelReservationType::setWalkInIndicator()
     * @uses HotelReservationType::setRoomNumberLockedIndicator()
     * @uses HotelReservationType::setOriginalDeliveryMethodCode()
     * @uses HotelReservationType::setPassiveIndicator()
     * @uses HotelReservationType::setCreateDateTime()
     * @uses HotelReservationType::setCreatorID()
     * @uses HotelReservationType::setLastModifyDateTime()
     * @uses HotelReservationType::setLastModifierID()
     * @uses HotelReservationType::setPurgeDate()
     * @param \StructType\POS_Type $pOS
     * @param \StructType\UniqueID_Type[] $uniqueID
     * @param \StructType\RoomStaysType $roomStays
     * @param \StructType\ServicesType $services
     * @param \StructType\ResGuestsType $resGuests
     * @param \StructType\ResGlobalInfoType $resGlobalInfo
     * @param \StructType\WrittenConfInstType $writtenConfInst
     * @param \StructType\Queue $queue
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @param bool $roomStayReservation
     * @param string $resStatus
     * @param bool $forcedSellIndicator
     * @param bool $serviceOverrideIndicator
     * @param bool $rateOverrideIndicator
     * @param bool $walkInIndicator
     * @param bool $roomNumberLockedIndicator
     * @param string $originalDeliveryMethodCode
     * @param bool $passiveIndicator
     * @param string $createDateTime
     * @param string $creatorID
     * @param string $lastModifyDateTime
     * @param string $lastModifierID
     * @param string $purgeDate
     */
    public function __construct(\StructType\POS_Type $pOS = null, array $uniqueID = array(), \StructType\RoomStaysType $roomStays = null, \StructType\ServicesType $services = null, \StructType\ResGuestsType $resGuests = null, \StructType\ResGlobalInfoType $resGlobalInfo = null, \StructType\WrittenConfInstType $writtenConfInst = null, \StructType\Queue $queue = null, \StructType\TPA_ExtensionsType $tPA_Extensions = null, $roomStayReservation = null, $resStatus = null, $forcedSellIndicator = null, $serviceOverrideIndicator = null, $rateOverrideIndicator = null, $walkInIndicator = null, $roomNumberLockedIndicator = null, $originalDeliveryMethodCode = null, $passiveIndicator = null, $createDateTime = null, $creatorID = null, $lastModifyDateTime = null, $lastModifierID = null, $purgeDate = null)
    {
        $this
            ->setPOS($pOS)
            ->setUniqueID($uniqueID)
            ->setRoomStays($roomStays)
            ->setServices($services)
            ->setResGuests($resGuests)
            ->setResGlobalInfo($resGlobalInfo)
            ->setWrittenConfInst($writtenConfInst)
            ->setQueue($queue)
            ->setTPA_Extensions($tPA_Extensions)
            ->setRoomStayReservation($roomStayReservation)
            ->setResStatus($resStatus)
            ->setForcedSellIndicator($forcedSellIndicator)
            ->setServiceOverrideIndicator($serviceOverrideIndicator)
            ->setRateOverrideIndicator($rateOverrideIndicator)
            ->setWalkInIndicator($walkInIndicator)
            ->setRoomNumberLockedIndicator($roomNumberLockedIndicator)
            ->setOriginalDeliveryMethodCode($originalDeliveryMethodCode)
            ->setPassiveIndicator($passiveIndicator)
            ->setCreateDateTime($createDateTime)
            ->setCreatorID($creatorID)
            ->setLastModifyDateTime($lastModifyDateTime)
            ->setLastModifierID($lastModifierID)
            ->setPurgeDate($purgeDate);
    }
    /**
     * Get POS value
     * @return \StructType\POS_Type|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \StructType\POS_Type $pOS
     * @return \StructType\HotelReservationType
     */
    public function setPOS(\StructType\POS_Type $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID_Type[]|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * This method is responsible for validating the values passed to the setUniqueID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUniqueID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUniqueIDForArrayConstraintsFromSetUniqueID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelReservationTypeUniqueIDItem) {
            // validation for constraint: itemType
            if (!$hotelReservationTypeUniqueIDItem instanceof \StructType\UniqueID_Type) {
                $invalidValues[] = is_object($hotelReservationTypeUniqueIDItem) ? get_class($hotelReservationTypeUniqueIDItem) : sprintf('%s(%s)', gettype($hotelReservationTypeUniqueIDItem), var_export($hotelReservationTypeUniqueIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UniqueID property can only contain items of type \StructType\UniqueID_Type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UniqueID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID_Type[] $uniqueID
     * @return \StructType\HotelReservationType
     */
    public function setUniqueID(array $uniqueID = array())
    {
        // validation for constraint: array
        if ('' !== ($uniqueIDArrayErrorMessage = self::validateUniqueIDForArrayConstraintsFromSetUniqueID($uniqueID))) {
            throw new \InvalidArgumentException($uniqueIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($uniqueID) && count($uniqueID) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($uniqueID)), __LINE__);
        }
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Add item to UniqueID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID_Type $item
     * @return \StructType\HotelReservationType
     */
    public function addToUniqueID(\StructType\UniqueID_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UniqueID_Type) {
            throw new \InvalidArgumentException(sprintf('The UniqueID property can only contain items of type \StructType\UniqueID_Type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->UniqueID) && count($this->UniqueID) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->UniqueID)), __LINE__);
        }
        $this->UniqueID[] = $item;
        return $this;
    }
    /**
     * Get RoomStays value
     * @return \StructType\RoomStaysType|null
     */
    public function getRoomStays()
    {
        return $this->RoomStays;
    }
    /**
     * Set RoomStays value
     * @param \StructType\RoomStaysType $roomStays
     * @return \StructType\HotelReservationType
     */
    public function setRoomStays(\StructType\RoomStaysType $roomStays = null)
    {
        $this->RoomStays = $roomStays;
        return $this;
    }
    /**
     * Get Services value
     * @return \StructType\ServicesType|null
     */
    public function getServices()
    {
        return $this->Services;
    }
    /**
     * Set Services value
     * @param \StructType\ServicesType $services
     * @return \StructType\HotelReservationType
     */
    public function setServices(\StructType\ServicesType $services = null)
    {
        $this->Services = $services;
        return $this;
    }
    /**
     * Get ResGuests value
     * @return \StructType\ResGuestsType|null
     */
    public function getResGuests()
    {
        return $this->ResGuests;
    }
    /**
     * Set ResGuests value
     * @param \StructType\ResGuestsType $resGuests
     * @return \StructType\HotelReservationType
     */
    public function setResGuests(\StructType\ResGuestsType $resGuests = null)
    {
        $this->ResGuests = $resGuests;
        return $this;
    }
    /**
     * Get ResGlobalInfo value
     * @return \StructType\ResGlobalInfoType|null
     */
    public function getResGlobalInfo()
    {
        return $this->ResGlobalInfo;
    }
    /**
     * Set ResGlobalInfo value
     * @param \StructType\ResGlobalInfoType $resGlobalInfo
     * @return \StructType\HotelReservationType
     */
    public function setResGlobalInfo(\StructType\ResGlobalInfoType $resGlobalInfo = null)
    {
        $this->ResGlobalInfo = $resGlobalInfo;
        return $this;
    }
    /**
     * Get WrittenConfInst value
     * @return \StructType\WrittenConfInstType|null
     */
    public function getWrittenConfInst()
    {
        return $this->WrittenConfInst;
    }
    /**
     * Set WrittenConfInst value
     * @param \StructType\WrittenConfInstType $writtenConfInst
     * @return \StructType\HotelReservationType
     */
    public function setWrittenConfInst(\StructType\WrittenConfInstType $writtenConfInst = null)
    {
        $this->WrittenConfInst = $writtenConfInst;
        return $this;
    }
    /**
     * Get Queue value
     * @return \StructType\Queue|null
     */
    public function getQueue()
    {
        return $this->Queue;
    }
    /**
     * Set Queue value
     * @param \StructType\Queue $queue
     * @return \StructType\HotelReservationType
     */
    public function setQueue(\StructType\Queue $queue = null)
    {
        $this->Queue = $queue;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @return \StructType\HotelReservationType
     */
    public function setTPA_Extensions(\StructType\TPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get RoomStayReservation value
     * @return bool|null
     */
    public function getRoomStayReservation()
    {
        return $this->RoomStayReservation;
    }
    /**
     * Set RoomStayReservation value
     * @param bool $roomStayReservation
     * @return \StructType\HotelReservationType
     */
    public function setRoomStayReservation($roomStayReservation = null)
    {
        // validation for constraint: boolean
        if (!is_null($roomStayReservation) && !is_bool($roomStayReservation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($roomStayReservation, true), gettype($roomStayReservation)), __LINE__);
        }
        $this->RoomStayReservation = $roomStayReservation;
        return $this;
    }
    /**
     * Get ResStatus value
     * @return string|null
     */
    public function getResStatus()
    {
        return $this->ResStatus;
    }
    /**
     * This method is responsible for validating the value passed to the setResStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResStatus method
     * This is a set of validation rules based on the union types associated to the property being set by the setResStatus method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResStatusForUnionConstraintsFromSetResStatus($value)
    {
        $message = '';
        // validation for constraint: enumeration
        if (!\EnumType\PMS_ResStatusType::valueIsValid($value)) {
            $exception0 = new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PMS_ResStatusType', is_array($value) ? implode(', ', $value) : var_export($value, true), implode(', ', \EnumType\PMS_ResStatusType::getValidValues())), __LINE__);
        }
        // validation for constraint: enumeration
        if (!\EnumType\TransactionActionType::valueIsValid($value)) {
            $exception1 = new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransactionActionType', is_array($value) ? implode(', ', $value) : var_export($value, true), implode(', ', \EnumType\TransactionActionType::getValidValues())), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{1,2})
        if (!is_null($value) && !preg_match('/[A-Z]{1,2}/', $value)) {
            $exception2 = new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{1,2}', var_export($value, true)), __LINE__);
        }
        if (isset($exception0) && isset($exception1) && isset($exception2)) {
            $message = sprintf("The value %s does not match any of the union rules: PMS_ResStatusType, TransactionActionType, UpperCaseAlphaLength1to2. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [$exception0, $exception1, $exception2])));
        }
        unset($exception0, $exception1, $exception2);
        return $message;
    }
    /**
     * Set ResStatus value
     * @param string $resStatus
     * @return \StructType\HotelReservationType
     */
    public function setResStatus($resStatus = null)
    {
        // validation for constraint: string
        if (!is_null($resStatus) && !is_string($resStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resStatus, true), gettype($resStatus)), __LINE__);
        }
        // validation for constraint: union(PMS_ResStatusType, TransactionActionType, UpperCaseAlphaLength1to2)
        if ('' !== ($resStatusUnionErrorMessage = self::validateResStatusForUnionConstraintsFromSetResStatus($resStatus))) {
            throw new \InvalidArgumentException($resStatusUnionErrorMessage, __LINE__);
        }
        $this->ResStatus = $resStatus;
        return $this;
    }
    /**
     * Get ForcedSellIndicator value
     * @return bool|null
     */
    public function getForcedSellIndicator()
    {
        return $this->ForcedSellIndicator;
    }
    /**
     * Set ForcedSellIndicator value
     * @param bool $forcedSellIndicator
     * @return \StructType\HotelReservationType
     */
    public function setForcedSellIndicator($forcedSellIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($forcedSellIndicator) && !is_bool($forcedSellIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forcedSellIndicator, true), gettype($forcedSellIndicator)), __LINE__);
        }
        $this->ForcedSellIndicator = $forcedSellIndicator;
        return $this;
    }
    /**
     * Get ServiceOverrideIndicator value
     * @return bool|null
     */
    public function getServiceOverrideIndicator()
    {
        return $this->ServiceOverrideIndicator;
    }
    /**
     * Set ServiceOverrideIndicator value
     * @param bool $serviceOverrideIndicator
     * @return \StructType\HotelReservationType
     */
    public function setServiceOverrideIndicator($serviceOverrideIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($serviceOverrideIndicator) && !is_bool($serviceOverrideIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($serviceOverrideIndicator, true), gettype($serviceOverrideIndicator)), __LINE__);
        }
        $this->ServiceOverrideIndicator = $serviceOverrideIndicator;
        return $this;
    }
    /**
     * Get RateOverrideIndicator value
     * @return bool|null
     */
    public function getRateOverrideIndicator()
    {
        return $this->RateOverrideIndicator;
    }
    /**
     * Set RateOverrideIndicator value
     * @param bool $rateOverrideIndicator
     * @return \StructType\HotelReservationType
     */
    public function setRateOverrideIndicator($rateOverrideIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($rateOverrideIndicator) && !is_bool($rateOverrideIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rateOverrideIndicator, true), gettype($rateOverrideIndicator)), __LINE__);
        }
        $this->RateOverrideIndicator = $rateOverrideIndicator;
        return $this;
    }
    /**
     * Get WalkInIndicator value
     * @return bool|null
     */
    public function getWalkInIndicator()
    {
        return $this->WalkInIndicator;
    }
    /**
     * Set WalkInIndicator value
     * @param bool $walkInIndicator
     * @return \StructType\HotelReservationType
     */
    public function setWalkInIndicator($walkInIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($walkInIndicator) && !is_bool($walkInIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($walkInIndicator, true), gettype($walkInIndicator)), __LINE__);
        }
        $this->WalkInIndicator = $walkInIndicator;
        return $this;
    }
    /**
     * Get RoomNumberLockedIndicator value
     * @return bool|null
     */
    public function getRoomNumberLockedIndicator()
    {
        return $this->RoomNumberLockedIndicator;
    }
    /**
     * Set RoomNumberLockedIndicator value
     * @param bool $roomNumberLockedIndicator
     * @return \StructType\HotelReservationType
     */
    public function setRoomNumberLockedIndicator($roomNumberLockedIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($roomNumberLockedIndicator) && !is_bool($roomNumberLockedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($roomNumberLockedIndicator, true), gettype($roomNumberLockedIndicator)), __LINE__);
        }
        $this->RoomNumberLockedIndicator = $roomNumberLockedIndicator;
        return $this;
    }
    /**
     * Get OriginalDeliveryMethodCode value
     * @return string|null
     */
    public function getOriginalDeliveryMethodCode()
    {
        return $this->OriginalDeliveryMethodCode;
    }
    /**
     * Set OriginalDeliveryMethodCode value
     * @param string $originalDeliveryMethodCode
     * @return \StructType\HotelReservationType
     */
    public function setOriginalDeliveryMethodCode($originalDeliveryMethodCode = null)
    {
        // validation for constraint: string
        if (!is_null($originalDeliveryMethodCode) && !is_string($originalDeliveryMethodCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalDeliveryMethodCode, true), gettype($originalDeliveryMethodCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($originalDeliveryMethodCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $originalDeliveryMethodCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($originalDeliveryMethodCode, true)), __LINE__);
        }
        $this->OriginalDeliveryMethodCode = $originalDeliveryMethodCode;
        return $this;
    }
    /**
     * Get PassiveIndicator value
     * @return bool|null
     */
    public function getPassiveIndicator()
    {
        return $this->PassiveIndicator;
    }
    /**
     * Set PassiveIndicator value
     * @param bool $passiveIndicator
     * @return \StructType\HotelReservationType
     */
    public function setPassiveIndicator($passiveIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($passiveIndicator) && !is_bool($passiveIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($passiveIndicator, true), gettype($passiveIndicator)), __LINE__);
        }
        $this->PassiveIndicator = $passiveIndicator;
        return $this;
    }
    /**
     * Get CreateDateTime value
     * @return string|null
     */
    public function getCreateDateTime()
    {
        return $this->CreateDateTime;
    }
    /**
     * Set CreateDateTime value
     * @param string $createDateTime
     * @return \StructType\HotelReservationType
     */
    public function setCreateDateTime($createDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($createDateTime) && !is_string($createDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDateTime, true), gettype($createDateTime)), __LINE__);
        }
        $this->CreateDateTime = $createDateTime;
        return $this;
    }
    /**
     * Get CreatorID value
     * @return string|null
     */
    public function getCreatorID()
    {
        return $this->CreatorID;
    }
    /**
     * Set CreatorID value
     * @param string $creatorID
     * @return \StructType\HotelReservationType
     */
    public function setCreatorID($creatorID = null)
    {
        // validation for constraint: string
        if (!is_null($creatorID) && !is_string($creatorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creatorID, true), gettype($creatorID)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($creatorID) && mb_strlen($creatorID) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($creatorID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($creatorID) && mb_strlen($creatorID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($creatorID)), __LINE__);
        }
        $this->CreatorID = $creatorID;
        return $this;
    }
    /**
     * Get LastModifyDateTime value
     * @return string|null
     */
    public function getLastModifyDateTime()
    {
        return $this->LastModifyDateTime;
    }
    /**
     * Set LastModifyDateTime value
     * @param string $lastModifyDateTime
     * @return \StructType\HotelReservationType
     */
    public function setLastModifyDateTime($lastModifyDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifyDateTime) && !is_string($lastModifyDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifyDateTime, true), gettype($lastModifyDateTime)), __LINE__);
        }
        $this->LastModifyDateTime = $lastModifyDateTime;
        return $this;
    }
    /**
     * Get LastModifierID value
     * @return string|null
     */
    public function getLastModifierID()
    {
        return $this->LastModifierID;
    }
    /**
     * Set LastModifierID value
     * @param string $lastModifierID
     * @return \StructType\HotelReservationType
     */
    public function setLastModifierID($lastModifierID = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifierID) && !is_string($lastModifierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifierID, true), gettype($lastModifierID)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($lastModifierID) && mb_strlen($lastModifierID) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($lastModifierID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($lastModifierID) && mb_strlen($lastModifierID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($lastModifierID)), __LINE__);
        }
        $this->LastModifierID = $lastModifierID;
        return $this;
    }
    /**
     * Get PurgeDate value
     * @return string|null
     */
    public function getPurgeDate()
    {
        return $this->PurgeDate;
    }
    /**
     * Set PurgeDate value
     * @param string $purgeDate
     * @return \StructType\HotelReservationType
     */
    public function setPurgeDate($purgeDate = null)
    {
        // validation for constraint: string
        if (!is_null($purgeDate) && !is_string($purgeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purgeDate, true), gettype($purgeDate)), __LINE__);
        }
        $this->PurgeDate = $purgeDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelReservationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
