<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelResModifyType StructType
 * Meta information extracted from the WSDL
 * - documentation: Full structure of a hotel reservation modification.
 * @subpackage Structs
 */
class HotelResModifyType extends AbstractStructBase
{
    /**
     * The HotelResModify
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\HotelResModify[]
     */
    public $HotelResModify;
    /**
     * The RoutingHops
     * Meta information extracted from the WSDL
     * - documentation: A collection of routing hops.
     * - minOccurs: 0
     * @var \StructType\RoutingHopType
     */
    public $RoutingHops;
    /**
     * The WrittenConfInst
     * Meta information extracted from the WSDL
     * - documentation: To indicate a confirmation is to be sent for this batch of reservations.
     * - minOccurs: 0
     * @var \StructType\WrittenConfInstType
     */
    public $WrittenConfInst;
    /**
     * Constructor method for HotelResModifyType
     * @uses HotelResModifyType::setHotelResModify()
     * @uses HotelResModifyType::setRoutingHops()
     * @uses HotelResModifyType::setWrittenConfInst()
     * @param \StructType\HotelResModify[] $hotelResModify
     * @param \StructType\RoutingHopType $routingHops
     * @param \StructType\WrittenConfInstType $writtenConfInst
     */
    public function __construct(array $hotelResModify = array(), \StructType\RoutingHopType $routingHops = null, \StructType\WrittenConfInstType $writtenConfInst = null)
    {
        $this
            ->setHotelResModify($hotelResModify)
            ->setRoutingHops($routingHops)
            ->setWrittenConfInst($writtenConfInst);
    }
    /**
     * Get HotelResModify value
     * @return \StructType\HotelResModify[]|null
     */
    public function getHotelResModify()
    {
        return $this->HotelResModify;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelResModify method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelResModify method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelResModifyForArrayConstraintsFromSetHotelResModify(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelResModifyTypeHotelResModifyItem) {
            // validation for constraint: itemType
            if (!$hotelResModifyTypeHotelResModifyItem instanceof \StructType\HotelResModify) {
                $invalidValues[] = is_object($hotelResModifyTypeHotelResModifyItem) ? get_class($hotelResModifyTypeHotelResModifyItem) : sprintf('%s(%s)', gettype($hotelResModifyTypeHotelResModifyItem), var_export($hotelResModifyTypeHotelResModifyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelResModify property can only contain items of type \StructType\HotelResModify, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelResModify value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelResModify[] $hotelResModify
     * @return \StructType\HotelResModifyType
     */
    public function setHotelResModify(array $hotelResModify = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelResModifyArrayErrorMessage = self::validateHotelResModifyForArrayConstraintsFromSetHotelResModify($hotelResModify))) {
            throw new \InvalidArgumentException($hotelResModifyArrayErrorMessage, __LINE__);
        }
        $this->HotelResModify = $hotelResModify;
        return $this;
    }
    /**
     * Add item to HotelResModify value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelResModify $item
     * @return \StructType\HotelResModifyType
     */
    public function addToHotelResModify(\StructType\HotelResModify $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelResModify) {
            throw new \InvalidArgumentException(sprintf('The HotelResModify property can only contain items of type \StructType\HotelResModify, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelResModify[] = $item;
        return $this;
    }
    /**
     * Get RoutingHops value
     * @return \StructType\RoutingHopType|null
     */
    public function getRoutingHops()
    {
        return $this->RoutingHops;
    }
    /**
     * Set RoutingHops value
     * @param \StructType\RoutingHopType $routingHops
     * @return \StructType\HotelResModifyType
     */
    public function setRoutingHops(\StructType\RoutingHopType $routingHops = null)
    {
        $this->RoutingHops = $routingHops;
        return $this;
    }
    /**
     * Get WrittenConfInst value
     * @return \StructType\WrittenConfInstType|null
     */
    public function getWrittenConfInst()
    {
        return $this->WrittenConfInst;
    }
    /**
     * Set WrittenConfInst value
     * @param \StructType\WrittenConfInstType $writtenConfInst
     * @return \StructType\HotelResModifyType
     */
    public function setWrittenConfInst(\StructType\WrittenConfInstType $writtenConfInst = null)
    {
        $this->WrittenConfInst = $writtenConfInst;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelResModifyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
