<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelAmenity StructType
 * Meta information extracted from the WSDL
 * - documentation: Hotel level amenities for searches. | Hotel-level amenities (pool, etc) for searching.
 * @subpackage Structs
 */
class HotelAmenity extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: Refer to OpenTravel Code List Hotel Amenity Code (HAC). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The ComplimentaryInd
     * Meta information extracted from the WSDL
     * - documentation: When true, there is no charge for the amenity. When false, there is a fee associated with the amenity.
     * - use: optional
     * @var bool
     */
    public $ComplimentaryInd;
    /**
     * Constructor method for HotelAmenity
     * @uses HotelAmenity::setCode()
     * @uses HotelAmenity::setComplimentaryInd()
     * @param string $code
     * @param bool $complimentaryInd
     */
    public function __construct($code = null, $complimentaryInd = null)
    {
        $this
            ->setCode($code)
            ->setComplimentaryInd($complimentaryInd);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\HotelAmenity
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($code) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($code, true)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get ComplimentaryInd value
     * @return bool|null
     */
    public function getComplimentaryInd()
    {
        return $this->ComplimentaryInd;
    }
    /**
     * Set ComplimentaryInd value
     * @param bool $complimentaryInd
     * @return \StructType\HotelAmenity
     */
    public function setComplimentaryInd($complimentaryInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($complimentaryInd) && !is_bool($complimentaryInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($complimentaryInd, true), gettype($complimentaryInd)), __LINE__);
        }
        $this->ComplimentaryInd = $complimentaryInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelAmenity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
