<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelAdditionalChargesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Currency code and number of decimal places used.
 * @subpackage Structs
 */
class HotelAdditionalChargesType extends AbstractStructBase
{
    /**
     * The AdditionalCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\AdditionalCharge[]
     */
    public $AdditionalCharge;
    /**
     * The AmountBeforeTax
     * Meta information extracted from the WSDL
     * - documentation: Total additional charges before taxes. | Specifies an amount, max 3 decimals.
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $AmountBeforeTax;
    /**
     * The AmountAfterTax
     * Meta information extracted from the WSDL
     * - documentation: Total additional charges after taxes. | Specifies an amount, max 3 decimals.
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $AmountAfterTax;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Used for an Alpha String, length exactly 3.
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * Constructor method for HotelAdditionalChargesType
     * @uses HotelAdditionalChargesType::setAdditionalCharge()
     * @uses HotelAdditionalChargesType::setAmountBeforeTax()
     * @uses HotelAdditionalChargesType::setAmountAfterTax()
     * @uses HotelAdditionalChargesType::setCurrencyCode()
     * @uses HotelAdditionalChargesType::setDecimalPlaces()
     * @param \StructType\AdditionalCharge[] $additionalCharge
     * @param float $amountBeforeTax
     * @param float $amountAfterTax
     * @param string $currencyCode
     * @param int $decimalPlaces
     */
    public function __construct(array $additionalCharge = array(), $amountBeforeTax = null, $amountAfterTax = null, $currencyCode = null, $decimalPlaces = null)
    {
        $this
            ->setAdditionalCharge($additionalCharge)
            ->setAmountBeforeTax($amountBeforeTax)
            ->setAmountAfterTax($amountAfterTax)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces);
    }
    /**
     * Get AdditionalCharge value
     * @return \StructType\AdditionalCharge[]|null
     */
    public function getAdditionalCharge()
    {
        return $this->AdditionalCharge;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalChargeForArrayConstraintsFromSetAdditionalCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelAdditionalChargesTypeAdditionalChargeItem) {
            // validation for constraint: itemType
            if (!$hotelAdditionalChargesTypeAdditionalChargeItem instanceof \StructType\AdditionalCharge) {
                $invalidValues[] = is_object($hotelAdditionalChargesTypeAdditionalChargeItem) ? get_class($hotelAdditionalChargesTypeAdditionalChargeItem) : sprintf('%s(%s)', gettype($hotelAdditionalChargesTypeAdditionalChargeItem), var_export($hotelAdditionalChargesTypeAdditionalChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalCharge property can only contain items of type \StructType\AdditionalCharge, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalCharge value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalCharge[] $additionalCharge
     * @return \StructType\HotelAdditionalChargesType
     */
    public function setAdditionalCharge(array $additionalCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalChargeArrayErrorMessage = self::validateAdditionalChargeForArrayConstraintsFromSetAdditionalCharge($additionalCharge))) {
            throw new \InvalidArgumentException($additionalChargeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($additionalCharge) && count($additionalCharge) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($additionalCharge)), __LINE__);
        }
        $this->AdditionalCharge = $additionalCharge;
        return $this;
    }
    /**
     * Add item to AdditionalCharge value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalCharge $item
     * @return \StructType\HotelAdditionalChargesType
     */
    public function addToAdditionalCharge(\StructType\AdditionalCharge $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AdditionalCharge) {
            throw new \InvalidArgumentException(sprintf('The AdditionalCharge property can only contain items of type \StructType\AdditionalCharge, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->AdditionalCharge) && count($this->AdditionalCharge) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->AdditionalCharge)), __LINE__);
        }
        $this->AdditionalCharge[] = $item;
        return $this;
    }
    /**
     * Get AmountBeforeTax value
     * @return float|null
     */
    public function getAmountBeforeTax()
    {
        return $this->AmountBeforeTax;
    }
    /**
     * Set AmountBeforeTax value
     * @param float $amountBeforeTax
     * @return \StructType\HotelAdditionalChargesType
     */
    public function setAmountBeforeTax($amountBeforeTax = null)
    {
        // validation for constraint: float
        if (!is_null($amountBeforeTax) && !(is_float($amountBeforeTax) || is_numeric($amountBeforeTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountBeforeTax, true), gettype($amountBeforeTax)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($amountBeforeTax) && mb_strlen(mb_substr($amountBeforeTax, mb_strpos($amountBeforeTax, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($amountBeforeTax, true), mb_strlen(mb_substr($amountBeforeTax, mb_strpos($amountBeforeTax, '.') + 1))), __LINE__);
        }
        $this->AmountBeforeTax = $amountBeforeTax;
        return $this;
    }
    /**
     * Get AmountAfterTax value
     * @return float|null
     */
    public function getAmountAfterTax()
    {
        return $this->AmountAfterTax;
    }
    /**
     * Set AmountAfterTax value
     * @param float $amountAfterTax
     * @return \StructType\HotelAdditionalChargesType
     */
    public function setAmountAfterTax($amountAfterTax = null)
    {
        // validation for constraint: float
        if (!is_null($amountAfterTax) && !(is_float($amountAfterTax) || is_numeric($amountAfterTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountAfterTax, true), gettype($amountAfterTax)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($amountAfterTax) && mb_strlen(mb_substr($amountAfterTax, mb_strpos($amountAfterTax, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($amountAfterTax, true), mb_strlen(mb_substr($amountAfterTax, mb_strpos($amountAfterTax, '.') + 1))), __LINE__);
        }
        $this->AmountAfterTax = $amountAfterTax;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\HotelAdditionalChargesType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{3})
        if (!is_null($currencyCode) && !preg_match('/[a-zA-Z]{3}/', $currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{3}', var_export($currencyCode, true)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\HotelAdditionalChargesType
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelAdditionalChargesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
