<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuaranteePolicies StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of Guarantee Policies.
 * @subpackage Structs
 */
class GuaranteePolicies extends AbstractStructBase
{
    /**
     * The GuaranteePolicy
     * Meta information extracted from the WSDL
     * - documentation: GuaranteePolicy.
     * - maxOccurs: unbounded
     * @var \StructType\GuaranteeType[]
     */
    public $GuaranteePolicy;
    /**
     * Constructor method for GuaranteePolicies
     * @uses GuaranteePolicies::setGuaranteePolicy()
     * @param \StructType\GuaranteeType[] $guaranteePolicy
     */
    public function __construct(array $guaranteePolicy = array())
    {
        $this
            ->setGuaranteePolicy($guaranteePolicy);
    }
    /**
     * Get GuaranteePolicy value
     * @return \StructType\GuaranteeType[]|null
     */
    public function getGuaranteePolicy()
    {
        return $this->GuaranteePolicy;
    }
    /**
     * This method is responsible for validating the values passed to the setGuaranteePolicy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuaranteePolicy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuaranteePolicyForArrayConstraintsFromSetGuaranteePolicy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guaranteePoliciesGuaranteePolicyItem) {
            // validation for constraint: itemType
            if (!$guaranteePoliciesGuaranteePolicyItem instanceof \StructType\GuaranteeType) {
                $invalidValues[] = is_object($guaranteePoliciesGuaranteePolicyItem) ? get_class($guaranteePoliciesGuaranteePolicyItem) : sprintf('%s(%s)', gettype($guaranteePoliciesGuaranteePolicyItem), var_export($guaranteePoliciesGuaranteePolicyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GuaranteePolicy property can only contain items of type \StructType\GuaranteeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GuaranteePolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\GuaranteeType[] $guaranteePolicy
     * @return \StructType\GuaranteePolicies
     */
    public function setGuaranteePolicy(array $guaranteePolicy = array())
    {
        // validation for constraint: array
        if ('' !== ($guaranteePolicyArrayErrorMessage = self::validateGuaranteePolicyForArrayConstraintsFromSetGuaranteePolicy($guaranteePolicy))) {
            throw new \InvalidArgumentException($guaranteePolicyArrayErrorMessage, __LINE__);
        }
        $this->GuaranteePolicy = $guaranteePolicy;
        return $this;
    }
    /**
     * Add item to GuaranteePolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\GuaranteeType $item
     * @return \StructType\GuaranteePolicies
     */
    public function addToGuaranteePolicy(\StructType\GuaranteeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GuaranteeType) {
            throw new \InvalidArgumentException(sprintf('The GuaranteePolicy property can only contain items of type \StructType\GuaranteeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GuaranteePolicy[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GuaranteePolicies
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
