<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GDS_CodeDetail StructType
 * Meta information extracted from the WSDL
 * - documentation: This holds detailed information pertaining to the agencies authorized to book this rate.
 * @subpackage Structs
 */
class GDS_CodeDetail extends AbstractStructBase
{
    /**
     * The PseudoCityCode
     * Meta information extracted from the WSDL
     * - documentation: This is used to pass the pseudo city code (i.e., the code that identifies a specific agency location) of the agency that has authority to book the negotiated rate(s)). | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The AgencyName
     * Meta information extracted from the WSDL
     * - documentation: This is the agency with authority to book the negotiated rate(s). | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $AgencyName;
    /**
     * Constructor method for GDS_CodeDetail
     * @uses GDS_CodeDetail::setPseudoCityCode()
     * @uses GDS_CodeDetail::setAgencyName()
     * @param string $pseudoCityCode
     * @param string $agencyName
     */
    public function __construct($pseudoCityCode = null, $agencyName = null)
    {
        $this
            ->setPseudoCityCode($pseudoCityCode)
            ->setAgencyName($agencyName);
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \StructType\GDS_CodeDetail
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($pseudoCityCode) && !is_string($pseudoCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pseudoCityCode, true), gettype($pseudoCityCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($pseudoCityCode) && mb_strlen($pseudoCityCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($pseudoCityCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($pseudoCityCode) && mb_strlen($pseudoCityCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($pseudoCityCode)), __LINE__);
        }
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get AgencyName value
     * @return string|null
     */
    public function getAgencyName()
    {
        return $this->AgencyName;
    }
    /**
     * Set AgencyName value
     * @param string $agencyName
     * @return \StructType\GDS_CodeDetail
     */
    public function setAgencyName($agencyName = null)
    {
        // validation for constraint: string
        if (!is_null($agencyName) && !is_string($agencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyName, true), gettype($agencyName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($agencyName) && mb_strlen($agencyName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($agencyName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($agencyName) && mb_strlen($agencyName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($agencyName)), __LINE__);
        }
        $this->AgencyName = $agencyName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GDS_CodeDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
