<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormattedTextSubSectionType StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to provide subsection formatted text information.
 * @subpackage Structs
 */
class FormattedTextSubSectionType extends AbstractStructBase
{
    /**
     * The Paragraph
     * Meta information extracted from the WSDL
     * - documentation: Details and content of a paragraph for a formatted text message.
     * - maxOccurs: 99
     * @var \StructType\ParagraphType[]
     */
    public $Paragraph;
    /**
     * The SubTitle
     * Meta information extracted from the WSDL
     * - documentation: This attribute may be used to provide a title for a sub-section of the formatted free text. A sub-section may have multiple related paragraphs of information. For example, if used to provide driving directions there may be multiple
     * paragraphs, and these paragraphs may be grouped into a sub-section called "Driving from the North". A second subsection may be titled "Driving from the South", and may contain several paragraphs to describe the driving directions when driving from
     * the south. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $SubTitle;
    /**
     * The SubCode
     * Meta information extracted from the WSDL
     * - documentation: An optional code that may be assigned to this sub-section of formatted free text. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $SubCode;
    /**
     * The SubSectionNumber
     * Meta information extracted from the WSDL
     * - documentation: This attribute may be used when there is a need to number all of the sub-sections of information that is to be presented. | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $SubSectionNumber;
    /**
     * Constructor method for FormattedTextSubSectionType
     * @uses FormattedTextSubSectionType::setParagraph()
     * @uses FormattedTextSubSectionType::setSubTitle()
     * @uses FormattedTextSubSectionType::setSubCode()
     * @uses FormattedTextSubSectionType::setSubSectionNumber()
     * @param \StructType\ParagraphType[] $paragraph
     * @param string $subTitle
     * @param string $subCode
     * @param int $subSectionNumber
     */
    public function __construct(array $paragraph = array(), $subTitle = null, $subCode = null, $subSectionNumber = null)
    {
        $this
            ->setParagraph($paragraph)
            ->setSubTitle($subTitle)
            ->setSubCode($subCode)
            ->setSubSectionNumber($subSectionNumber);
    }
    /**
     * Get Paragraph value
     * @return \StructType\ParagraphType[]|null
     */
    public function getParagraph()
    {
        return $this->Paragraph;
    }
    /**
     * This method is responsible for validating the values passed to the setParagraph method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParagraph method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParagraphForArrayConstraintsFromSetParagraph(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $formattedTextSubSectionTypeParagraphItem) {
            // validation for constraint: itemType
            if (!$formattedTextSubSectionTypeParagraphItem instanceof \StructType\ParagraphType) {
                $invalidValues[] = is_object($formattedTextSubSectionTypeParagraphItem) ? get_class($formattedTextSubSectionTypeParagraphItem) : sprintf('%s(%s)', gettype($formattedTextSubSectionTypeParagraphItem), var_export($formattedTextSubSectionTypeParagraphItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Paragraph property can only contain items of type \StructType\ParagraphType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Paragraph value
     * @throws \InvalidArgumentException
     * @param \StructType\ParagraphType[] $paragraph
     * @return \StructType\FormattedTextSubSectionType
     */
    public function setParagraph(array $paragraph = array())
    {
        // validation for constraint: array
        if ('' !== ($paragraphArrayErrorMessage = self::validateParagraphForArrayConstraintsFromSetParagraph($paragraph))) {
            throw new \InvalidArgumentException($paragraphArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($paragraph) && count($paragraph) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($paragraph)), __LINE__);
        }
        $this->Paragraph = $paragraph;
        return $this;
    }
    /**
     * Add item to Paragraph value
     * @throws \InvalidArgumentException
     * @param \StructType\ParagraphType $item
     * @return \StructType\FormattedTextSubSectionType
     */
    public function addToParagraph(\StructType\ParagraphType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ParagraphType) {
            throw new \InvalidArgumentException(sprintf('The Paragraph property can only contain items of type \StructType\ParagraphType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Paragraph) && count($this->Paragraph) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Paragraph)), __LINE__);
        }
        $this->Paragraph[] = $item;
        return $this;
    }
    /**
     * Get SubTitle value
     * @return string|null
     */
    public function getSubTitle()
    {
        return $this->SubTitle;
    }
    /**
     * Set SubTitle value
     * @param string $subTitle
     * @return \StructType\FormattedTextSubSectionType
     */
    public function setSubTitle($subTitle = null)
    {
        // validation for constraint: string
        if (!is_null($subTitle) && !is_string($subTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subTitle, true), gettype($subTitle)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($subTitle) && mb_strlen($subTitle) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($subTitle)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($subTitle) && mb_strlen($subTitle) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($subTitle)), __LINE__);
        }
        $this->SubTitle = $subTitle;
        return $this;
    }
    /**
     * Get SubCode value
     * @return string|null
     */
    public function getSubCode()
    {
        return $this->SubCode;
    }
    /**
     * Set SubCode value
     * @param string $subCode
     * @return \StructType\FormattedTextSubSectionType
     */
    public function setSubCode($subCode = null)
    {
        // validation for constraint: string
        if (!is_null($subCode) && !is_string($subCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subCode, true), gettype($subCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($subCode) && mb_strlen($subCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($subCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($subCode) && mb_strlen($subCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($subCode)), __LINE__);
        }
        $this->SubCode = $subCode;
        return $this;
    }
    /**
     * Get SubSectionNumber value
     * @return int|null
     */
    public function getSubSectionNumber()
    {
        return $this->SubSectionNumber;
    }
    /**
     * Set SubSectionNumber value
     * @param int $subSectionNumber
     * @return \StructType\FormattedTextSubSectionType
     */
    public function setSubSectionNumber($subSectionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($subSectionNumber) && !(is_int($subSectionNumber) || ctype_digit($subSectionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($subSectionNumber, true), gettype($subSectionNumber)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($subSectionNumber) && $subSectionNumber > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($subSectionNumber, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($subSectionNumber) && $subSectionNumber < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($subSectionNumber, true)), __LINE__);
        }
        $this->SubSectionNumber = $subSectionNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FormattedTextSubSectionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
