<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FolioIDsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of strings (recommended length - 20 characters) indicating the PMS folio identifiers associated with this revenue detail item.
 * @subpackage Structs
 */
class FolioIDsType extends AbstractStructBase
{
    /**
     * The FolioID
     * Meta information extracted from the WSDL
     * - documentation: The PMS folio identifier associated with this revenue detail item. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - maxOccurs: 99
     * - minLength: 1
     * @var string[]
     */
    public $FolioID;
    /**
     * Constructor method for FolioIDsType
     * @uses FolioIDsType::setFolioID()
     * @param string[] $folioID
     */
    public function __construct(array $folioID = array())
    {
        $this
            ->setFolioID($folioID);
    }
    /**
     * Get FolioID value
     * @return string[]|null
     */
    public function getFolioID()
    {
        return $this->FolioID;
    }
    /**
     * This method is responsible for validating the values passed to the setFolioID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFolioID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFolioIDForArrayConstraintsFromSetFolioID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $folioIDsTypeFolioIDItem) {
            // validation for constraint: itemType
            if (!is_string($folioIDsTypeFolioIDItem)) {
                $invalidValues[] = is_object($folioIDsTypeFolioIDItem) ? get_class($folioIDsTypeFolioIDItem) : sprintf('%s(%s)', gettype($folioIDsTypeFolioIDItem), var_export($folioIDsTypeFolioIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FolioID property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setFolioID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFolioID method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFolioIDForMaxLengthConstraintFromSetFolioID($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $folioIDsTypeFolioIDItem) {
            // validation for constraint: maxLength(32)
            if (mb_strlen($folioIDsTypeFolioIDItem) > 32) {
                $invalidValues[] = var_export($folioIDsTypeFolioIDItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 32', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setFolioID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFolioID method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFolioIDForMinLengthConstraintFromSetFolioID($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $folioIDsTypeFolioIDItem) {
            // validation for constraint: minLength(1)
            if (mb_strlen($folioIDsTypeFolioIDItem) < 1) {
                $invalidValues[] = var_export($folioIDsTypeFolioIDItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 1', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FolioID value
     * @throws \InvalidArgumentException
     * @param string[] $folioID
     * @return \StructType\FolioIDsType
     */
    public function setFolioID(array $folioID = array())
    {
        // validation for constraint: array
        if ('' !== ($folioIDArrayErrorMessage = self::validateFolioIDForArrayConstraintsFromSetFolioID($folioID))) {
            throw new \InvalidArgumentException($folioIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(32)
        if ('' !== ($folioIDMaxLengthErrorMessage = self::validateFolioIDForMaxLengthConstraintFromSetFolioID($folioID))) {
            throw new \InvalidArgumentException($folioIDMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($folioID) && count($folioID) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($folioID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if ('' !== ($folioIDMinLengthErrorMessage = self::validateFolioIDForMinLengthConstraintFromSetFolioID($folioID))) {
            throw new \InvalidArgumentException($folioIDMinLengthErrorMessage, __LINE__);
        }
        $this->FolioID = $folioID;
        return $this;
    }
    /**
     * Add item to FolioID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\FolioIDsType
     */
    public function addToFolioID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The FolioID property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (mb_strlen($item) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->FolioID) && count($this->FolioID) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->FolioID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (mb_strlen($item) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($item)), __LINE__);
        }
        $this->FolioID[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FolioIDsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
