<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightReference StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies a flight to which the discount pricing applies.
 * @subpackage Structs
 */
class FlightReference extends AbstractStructBase
{
    /**
     * The FlightRefNumber
     * Meta information extracted from the WSDL
     * - documentation: The flight segment to which the discount pricing should be applied. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $FlightRefNumber;
    /**
     * Constructor method for FlightReference
     * @uses FlightReference::setFlightRefNumber()
     * @param string $flightRefNumber
     */
    public function __construct($flightRefNumber = null)
    {
        $this
            ->setFlightRefNumber($flightRefNumber);
    }
    /**
     * Get FlightRefNumber value
     * @return string
     */
    public function getFlightRefNumber()
    {
        return $this->FlightRefNumber;
    }
    /**
     * Set FlightRefNumber value
     * @param string $flightRefNumber
     * @return \StructType\FlightReference
     */
    public function setFlightRefNumber($flightRefNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightRefNumber) && !is_string($flightRefNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightRefNumber, true), gettype($flightRefNumber)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($flightRefNumber) && mb_strlen($flightRefNumber) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($flightRefNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($flightRefNumber) && mb_strlen($flightRefNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($flightRefNumber)), __LINE__);
        }
        $this->FlightRefNumber = $flightRefNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FlightReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
