<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Fee StructType
 * Meta information extracted from the WSDL
 * - documentation: The ticket fee code. | This element is used to describe one specific fee that may apply.
 * @subpackage Structs
 */
class Fee extends VehicleChargeType
{
    /**
     * The FeeCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $FeeCode;
    /**
     * The BaseFee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BaseFee
     */
    public $BaseFee;
    /**
     * The Taxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Taxes
     */
    public $Taxes;
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Total
     */
    public $Total;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 0 to 128.
     * - base: xs:string
     * - maxLength: 128
     * - minLength: 0
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The Info
     * Meta information extracted from the WSDL
     * - documentation: Information on this one specific feeincluding a description, etc.
     * - minOccurs: 0
     * @var \StructType\FormattedTextType
     */
    public $Info;
    /**
     * Constructor method for Fee
     * @uses Fee::setFeeCode()
     * @uses Fee::setBaseFee()
     * @uses Fee::setTaxes()
     * @uses Fee::setTotal()
     * @uses Fee::setDescription()
     * @uses Fee::setInfo()
     * @param string $feeCode
     * @param \StructType\BaseFee $baseFee
     * @param \StructType\Taxes $taxes
     * @param \StructType\Total $total
     * @param string $description
     * @param \StructType\FormattedTextType $info
     */
    public function __construct($feeCode = null, \StructType\BaseFee $baseFee = null, \StructType\Taxes $taxes = null, \StructType\Total $total = null, $description = null, \StructType\FormattedTextType $info = null)
    {
        $this
            ->setFeeCode($feeCode)
            ->setBaseFee($baseFee)
            ->setTaxes($taxes)
            ->setTotal($total)
            ->setDescription($description)
            ->setInfo($info);
    }
    /**
     * Get FeeCode value
     * @return string
     */
    public function getFeeCode()
    {
        return $this->FeeCode;
    }
    /**
     * Set FeeCode value
     * @param string $feeCode
     * @return \StructType\Fee
     */
    public function setFeeCode($feeCode = null)
    {
        // validation for constraint: string
        if (!is_null($feeCode) && !is_string($feeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feeCode, true), gettype($feeCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($feeCode) && mb_strlen($feeCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($feeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($feeCode) && mb_strlen($feeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($feeCode)), __LINE__);
        }
        $this->FeeCode = $feeCode;
        return $this;
    }
    /**
     * Get BaseFee value
     * @return \StructType\BaseFee|null
     */
    public function getBaseFee()
    {
        return $this->BaseFee;
    }
    /**
     * Set BaseFee value
     * @param \StructType\BaseFee $baseFee
     * @return \StructType\Fee
     */
    public function setBaseFee(\StructType\BaseFee $baseFee = null)
    {
        $this->BaseFee = $baseFee;
        return $this;
    }
    /**
     * Get Taxes value
     * @return \StructType\Taxes|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \StructType\Taxes $taxes
     * @return \StructType\Fee
     */
    public function setTaxes(\StructType\Taxes $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get Total value
     * @return \StructType\Total|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param \StructType\Total $total
     * @return \StructType\Fee
     */
    public function setTotal(\StructType\Total $total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Fee
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($description) && mb_strlen($description) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($description)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($description) && mb_strlen($description) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Info value
     * @return \StructType\FormattedTextType|null
     */
    public function getInfo()
    {
        return $this->Info;
    }
    /**
     * Set Info value
     * @param \StructType\FormattedTextType $info
     * @return \StructType\Fee
     */
    public function setInfo(\StructType\FormattedTextType $info = null)
    {
        $this->Info = $info;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Fee
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
