<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareReference StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to provide the fare basis code, the fare class code, and/or ticket designator. | Used for Character Strings, length 0 to 8.
 * - base: xs:string
 * - maxLength: 8
 * - minLength: 0
 * @subpackage Structs
 */
class FareReference extends AbstractStructBase
{
    /**
     * The _
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 0 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 0
     * @var string
     */
    public $_;
    /**
     * The ResBookDesigCode
     * Meta information extracted from the WSDL
     * - documentation: Identifies the class of service for the specified fare basis code. | Used for an Alpha String, length 1 to 2 (for letter codes).
     * - base: xs:string
     * - pattern: [A-Z]{1,2}
     * - use: optional
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * The TicketDesignatorCode
     * Meta information extracted from the WSDL
     * - documentation: Specifies the discount code applicable to the fare that is associated with this fare basis code. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $TicketDesignatorCode;
    /**
     * The AccountCode
     * Meta information extracted from the WSDL
     * - documentation: A code to uniquely identify a fare account. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $AccountCode;
    /**
     * Constructor method for FareReference
     * @uses FareReference::set_()
     * @uses FareReference::setResBookDesigCode()
     * @uses FareReference::setTicketDesignatorCode()
     * @uses FareReference::setAccountCode()
     * @param string $_
     * @param string $resBookDesigCode
     * @param string $ticketDesignatorCode
     * @param string $accountCode
     */
    public function __construct($_ = null, $resBookDesigCode = null, $ticketDesignatorCode = null, $accountCode = null)
    {
        $this
            ->set_($_)
            ->setResBookDesigCode($resBookDesigCode)
            ->setTicketDesignatorCode($ticketDesignatorCode)
            ->setAccountCode($accountCode);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\FareReference
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($_) && mb_strlen($_) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($_)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($_) && mb_strlen($_) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get ResBookDesigCode value
     * @return string|null
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \StructType\FareReference
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($resBookDesigCode) && !is_string($resBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resBookDesigCode, true), gettype($resBookDesigCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{1,2})
        if (!is_null($resBookDesigCode) && !preg_match('/[A-Z]{1,2}/', $resBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{1,2}', var_export($resBookDesigCode, true)), __LINE__);
        }
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Get TicketDesignatorCode value
     * @return string|null
     */
    public function getTicketDesignatorCode()
    {
        return $this->TicketDesignatorCode;
    }
    /**
     * Set TicketDesignatorCode value
     * @param string $ticketDesignatorCode
     * @return \StructType\FareReference
     */
    public function setTicketDesignatorCode($ticketDesignatorCode = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDesignatorCode) && !is_string($ticketDesignatorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketDesignatorCode, true), gettype($ticketDesignatorCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($ticketDesignatorCode) && mb_strlen($ticketDesignatorCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($ticketDesignatorCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ticketDesignatorCode) && mb_strlen($ticketDesignatorCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ticketDesignatorCode)), __LINE__);
        }
        $this->TicketDesignatorCode = $ticketDesignatorCode;
        return $this;
    }
    /**
     * Get AccountCode value
     * @return string|null
     */
    public function getAccountCode()
    {
        return $this->AccountCode;
    }
    /**
     * Set AccountCode value
     * @param string $accountCode
     * @return \StructType\FareReference
     */
    public function setAccountCode($accountCode = null)
    {
        // validation for constraint: string
        if (!is_null($accountCode) && !is_string($accountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountCode, true), gettype($accountCode)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($accountCode) && mb_strlen($accountCode) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($accountCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($accountCode) && mb_strlen($accountCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($accountCode)), __LINE__);
        }
        $this->AccountCode = $accountCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FareReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
