<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FarePref StructType
 * Meta information extracted from the WSDL
 * - documentation: Indicates preferred fare.
 * @subpackage Structs
 */
class FarePref extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: Code indicating the type of fare preference (e.g., FM=commission, FD=fare discount). | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Free text describing the fare preference. | Used for Character Strings, length 1 to 128.
     * - base: xs:string
     * - maxLength: 128
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The AirlineVendorPrefRPH
     * Meta information extracted from the WSDL
     * - documentation: Reference to one or more airlines in AirlinePrefType/VendorPref. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients to
     * particular itinerary items). | List of Reference Place Holders.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string[]
     */
    public $AirlineVendorPrefRPH;
    /**
     * The RateCategoryCode
     * Meta information extracted from the WSDL
     * - documentation: Provides a rate category for the fare preference. Refer to OpenTravel code list Rate Category (RTC). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $RateCategoryCode;
    /**
     * The TransferAction
     * Meta information extracted from the WSDL
     * - documentation: Indicates under what conditions this element will be transfered to the booking.
     * - use: optional
     * @var string
     */
    public $TransferAction;
    /**
     * Constructor method for FarePref
     * @uses FarePref::setCode()
     * @uses FarePref::setDescription()
     * @uses FarePref::setAirlineVendorPrefRPH()
     * @uses FarePref::setRateCategoryCode()
     * @uses FarePref::setTransferAction()
     * @param string $code
     * @param string $description
     * @param string[] $airlineVendorPrefRPH
     * @param string $rateCategoryCode
     * @param string $transferAction
     */
    public function __construct($code = null, $description = null, array $airlineVendorPrefRPH = array(), $rateCategoryCode = null, $transferAction = null)
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setAirlineVendorPrefRPH($airlineVendorPrefRPH)
            ->setRateCategoryCode($rateCategoryCode)
            ->setTransferAction($transferAction);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\FarePref
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($code) && mb_strlen($code) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($code)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($code) && mb_strlen($code) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\FarePref
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($description) && mb_strlen($description) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($description)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($description) && mb_strlen($description) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get AirlineVendorPrefRPH value
     * @return string[]|null
     */
    public function getAirlineVendorPrefRPH()
    {
        return $this->AirlineVendorPrefRPH;
    }
    /**
     * This method is responsible for validating the values passed to the setAirlineVendorPrefRPH method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirlineVendorPrefRPH method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirlineVendorPrefRPHForArrayConstraintsFromSetAirlineVendorPrefRPH(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $farePrefAirlineVendorPrefRPHItem) {
            // validation for constraint: itemType
            if (!is_string($farePrefAirlineVendorPrefRPHItem)) {
                $invalidValues[] = is_object($farePrefAirlineVendorPrefRPHItem) ? get_class($farePrefAirlineVendorPrefRPHItem) : sprintf('%s(%s)', gettype($farePrefAirlineVendorPrefRPHItem), var_export($farePrefAirlineVendorPrefRPHItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirlineVendorPrefRPH property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirlineVendorPrefRPH value
     * @param string[] $airlineVendorPrefRPH
     * @return \StructType\FarePref
     */
    public function setAirlineVendorPrefRPH(array $airlineVendorPrefRPH = array())
    {
        // validation for constraint: list
        if ('' !== ($airlineVendorPrefRPHArrayErrorMessage = self::validateAirlineVendorPrefRPHForArrayConstraintsFromSetAirlineVendorPrefRPH($airlineVendorPrefRPH))) {
            throw new \InvalidArgumentException($airlineVendorPrefRPHArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($airlineVendorPrefRPH) && !preg_match('/[0-9]{1,8}/', $airlineVendorPrefRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($airlineVendorPrefRPH, true)), __LINE__);
        }
        $this->AirlineVendorPrefRPH = is_array($airlineVendorPrefRPH) ? implode(' ', $airlineVendorPrefRPH) : null;
        return $this;
    }
    /**
     * Get RateCategoryCode value
     * @return string|null
     */
    public function getRateCategoryCode()
    {
        return $this->RateCategoryCode;
    }
    /**
     * Set RateCategoryCode value
     * @param string $rateCategoryCode
     * @return \StructType\FarePref
     */
    public function setRateCategoryCode($rateCategoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($rateCategoryCode) && !is_string($rateCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateCategoryCode, true), gettype($rateCategoryCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($rateCategoryCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $rateCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($rateCategoryCode, true)), __LINE__);
        }
        $this->RateCategoryCode = $rateCategoryCode;
        return $this;
    }
    /**
     * Get TransferAction value
     * @return string|null
     */
    public function getTransferAction()
    {
        return $this->TransferAction;
    }
    /**
     * Set TransferAction value
     * @uses \EnumType\TransferActionType::valueIsValid()
     * @uses \EnumType\TransferActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transferAction
     * @return \StructType\FarePref
     */
    public function setTransferAction($transferAction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransferActionType::valueIsValid($transferAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransferActionType', is_array($transferAction) ? implode(', ', $transferAction) : var_export($transferAction, true), implode(', ', \EnumType\TransferActionType::getValidValues())), __LINE__);
        }
        $this->TransferAction = $transferAction;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FarePref
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
