<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareBasisCodes StructType
 * Meta information extracted from the WSDL
 * - documentation: This is a collection of fare basis codes.
 * @subpackage Structs
 */
class FareBasisCodes extends AbstractStructBase
{
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - documentation: Fare basis code for the price for this PTC
     * - maxOccurs: 299
     * @var \StructType\FareBasisCodeType[]
     */
    public $FareBasisCode;
    /**
     * Constructor method for FareBasisCodes
     * @uses FareBasisCodes::setFareBasisCode()
     * @param \StructType\FareBasisCodeType[] $fareBasisCode
     */
    public function __construct(array $fareBasisCode = array())
    {
        $this
            ->setFareBasisCode($fareBasisCode);
    }
    /**
     * Get FareBasisCode value
     * @return \StructType\FareBasisCodeType[]|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * This method is responsible for validating the values passed to the setFareBasisCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareBasisCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareBasisCodeForArrayConstraintsFromSetFareBasisCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareBasisCodesFareBasisCodeItem) {
            // validation for constraint: itemType
            if (!$fareBasisCodesFareBasisCodeItem instanceof \StructType\FareBasisCodeType) {
                $invalidValues[] = is_object($fareBasisCodesFareBasisCodeItem) ? get_class($fareBasisCodesFareBasisCodeItem) : sprintf('%s(%s)', gettype($fareBasisCodesFareBasisCodeItem), var_export($fareBasisCodesFareBasisCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareBasisCode property can only contain items of type \StructType\FareBasisCodeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareBasisCode value
     * @throws \InvalidArgumentException
     * @param \StructType\FareBasisCodeType[] $fareBasisCode
     * @return \StructType\FareBasisCodes
     */
    public function setFareBasisCode(array $fareBasisCode = array())
    {
        // validation for constraint: array
        if ('' !== ($fareBasisCodeArrayErrorMessage = self::validateFareBasisCodeForArrayConstraintsFromSetFareBasisCode($fareBasisCode))) {
            throw new \InvalidArgumentException($fareBasisCodeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(299)
        if (is_array($fareBasisCode) && count($fareBasisCode) > 299) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 299', count($fareBasisCode)), __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Add item to FareBasisCode value
     * @throws \InvalidArgumentException
     * @param \StructType\FareBasisCodeType $item
     * @return \StructType\FareBasisCodes
     */
    public function addToFareBasisCode(\StructType\FareBasisCodeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareBasisCodeType) {
            throw new \InvalidArgumentException(sprintf('The FareBasisCode property can only contain items of type \StructType\FareBasisCodeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(299)
        if (is_array($this->FareBasisCode) && count($this->FareBasisCode) >= 299) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 299', count($this->FareBasisCode)), __LINE__);
        }
        $this->FareBasisCode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FareBasisCodes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
