<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExchangeInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Exchange ticket/document information.
 * @subpackage Structs
 */
class ExchangeInfo extends AbstractStructBase
{
    /**
     * The CouponInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var \StructType\CouponInfo[]
     */
    public $CouponInfo;
    /**
     * The OriginalOriginDestination
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OriginalOriginDestination
     */
    public $OriginalOriginDestination;
    /**
     * The TicketDocumentNbr
     * Meta information extracted from the WSDL
     * - documentation: The new ticket/document number. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $TicketDocumentNbr;
    /**
     * Constructor method for ExchangeInfo
     * @uses ExchangeInfo::setCouponInfo()
     * @uses ExchangeInfo::setOriginalOriginDestination()
     * @uses ExchangeInfo::setTicketDocumentNbr()
     * @param \StructType\CouponInfo[] $couponInfo
     * @param \StructType\OriginalOriginDestination $originalOriginDestination
     * @param string $ticketDocumentNbr
     */
    public function __construct(array $couponInfo = array(), \StructType\OriginalOriginDestination $originalOriginDestination = null, $ticketDocumentNbr = null)
    {
        $this
            ->setCouponInfo($couponInfo)
            ->setOriginalOriginDestination($originalOriginDestination)
            ->setTicketDocumentNbr($ticketDocumentNbr);
    }
    /**
     * Get CouponInfo value
     * @return \StructType\CouponInfo[]|null
     */
    public function getCouponInfo()
    {
        return $this->CouponInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setCouponInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCouponInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCouponInfoForArrayConstraintsFromSetCouponInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $exchangeInfoCouponInfoItem) {
            // validation for constraint: itemType
            if (!$exchangeInfoCouponInfoItem instanceof \StructType\CouponInfo) {
                $invalidValues[] = is_object($exchangeInfoCouponInfoItem) ? get_class($exchangeInfoCouponInfoItem) : sprintf('%s(%s)', gettype($exchangeInfoCouponInfoItem), var_export($exchangeInfoCouponInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CouponInfo property can only contain items of type \StructType\CouponInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CouponInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\CouponInfo[] $couponInfo
     * @return \StructType\ExchangeInfo
     */
    public function setCouponInfo(array $couponInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($couponInfoArrayErrorMessage = self::validateCouponInfoForArrayConstraintsFromSetCouponInfo($couponInfo))) {
            throw new \InvalidArgumentException($couponInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($couponInfo) && count($couponInfo) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($couponInfo)), __LINE__);
        }
        $this->CouponInfo = $couponInfo;
        return $this;
    }
    /**
     * Add item to CouponInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\CouponInfo $item
     * @return \StructType\ExchangeInfo
     */
    public function addToCouponInfo(\StructType\CouponInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CouponInfo) {
            throw new \InvalidArgumentException(sprintf('The CouponInfo property can only contain items of type \StructType\CouponInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->CouponInfo) && count($this->CouponInfo) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->CouponInfo)), __LINE__);
        }
        $this->CouponInfo[] = $item;
        return $this;
    }
    /**
     * Get OriginalOriginDestination value
     * @return \StructType\OriginalOriginDestination|null
     */
    public function getOriginalOriginDestination()
    {
        return $this->OriginalOriginDestination;
    }
    /**
     * Set OriginalOriginDestination value
     * @param \StructType\OriginalOriginDestination $originalOriginDestination
     * @return \StructType\ExchangeInfo
     */
    public function setOriginalOriginDestination(\StructType\OriginalOriginDestination $originalOriginDestination = null)
    {
        $this->OriginalOriginDestination = $originalOriginDestination;
        return $this;
    }
    /**
     * Get TicketDocumentNbr value
     * @return string|null
     */
    public function getTicketDocumentNbr()
    {
        return $this->TicketDocumentNbr;
    }
    /**
     * Set TicketDocumentNbr value
     * @param string $ticketDocumentNbr
     * @return \StructType\ExchangeInfo
     */
    public function setTicketDocumentNbr($ticketDocumentNbr = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDocumentNbr) && !is_string($ticketDocumentNbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketDocumentNbr, true), gettype($ticketDocumentNbr)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($ticketDocumentNbr) && mb_strlen($ticketDocumentNbr) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($ticketDocumentNbr)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ticketDocumentNbr) && mb_strlen($ticketDocumentNbr) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ticketDocumentNbr)), __LINE__);
        }
        $this->TicketDocumentNbr = $ticketDocumentNbr;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExchangeInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
