<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EquipmentTypePref StructType
 * Meta information extracted from the WSDL
 * - documentation: Indicates preferences for type of airplane.
 * @subpackage Structs
 */
class EquipmentTypePref extends EquipmentType
{
    /**
     * The _
     * @var \StructType\EquipmentType
     */
    public $_;
    /**
     * The WideBody
     * Meta information extracted from the WSDL
     * - documentation: Indicates if an airplane with multiple aisles is preferred.
     * - use: optional
     * @var bool
     */
    public $WideBody;
    /**
     * The PreferLevel
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for EquipmentTypePref
     * @uses EquipmentTypePref::set_()
     * @uses EquipmentTypePref::setWideBody()
     * @uses EquipmentTypePref::setPreferLevel()
     * @param \StructType\EquipmentType $_
     * @param bool $wideBody
     * @param string $preferLevel
     */
    public function __construct(\StructType\EquipmentType $_ = null, $wideBody = null, $preferLevel = null)
    {
        $this
            ->set_($_)
            ->setWideBody($wideBody)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get _ value
     * @return \StructType\EquipmentType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \StructType\EquipmentType $_
     * @return \StructType\EquipmentTypePref
     */
    public function set_(\StructType\EquipmentType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get WideBody value
     * @return bool|null
     */
    public function getWideBody()
    {
        return $this->WideBody;
    }
    /**
     * Set WideBody value
     * @param bool $wideBody
     * @return \StructType\EquipmentTypePref
     */
    public function setWideBody($wideBody = null)
    {
        // validation for constraint: boolean
        if (!is_null($wideBody) && !is_bool($wideBody)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($wideBody, true), gettype($wideBody)), __LINE__);
        }
        $this->WideBody = $wideBody;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \StructType\EquipmentTypePref
     */
    public function setPreferLevel($preferLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EquipmentTypePref
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
