<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EndpointReferenceType StructType
 * Meta information extracted from the WSDL
 * - documentation: If "Policy" elements from namespace "http://schemas.xmlsoap.org/ws/2002/12/policy#policy" are used, they must appear first (before any extensibility elements).
 * @subpackage Structs
 */
class EndpointReferenceType extends AbstractStructBase
{
    /**
     * The Address
     * @var \StructType\AttributedURI
     */
    public $Address;
    /**
     * The ReferenceProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReferencePropertiesType
     */
    public $ReferenceProperties;
    /**
     * The ReferenceParameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReferenceParametersType
     */
    public $ReferenceParameters;
    /**
     * The PortType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AttributedQName
     */
    public $PortType;
    /**
     * The ServiceName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ServiceNameType
     */
    public $ServiceName;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for EndpointReferenceType
     * @uses EndpointReferenceType::setAddress()
     * @uses EndpointReferenceType::setReferenceProperties()
     * @uses EndpointReferenceType::setReferenceParameters()
     * @uses EndpointReferenceType::setPortType()
     * @uses EndpointReferenceType::setServiceName()
     * @uses EndpointReferenceType::setAny()
     * @param \StructType\AttributedURI $address
     * @param \StructType\ReferencePropertiesType $referenceProperties
     * @param \StructType\ReferenceParametersType $referenceParameters
     * @param \StructType\AttributedQName $portType
     * @param \StructType\ServiceNameType $serviceName
     * @param \DOMDocument $any
     */
    public function __construct(\StructType\AttributedURI $address = null, \StructType\ReferencePropertiesType $referenceProperties = null, \StructType\ReferenceParametersType $referenceParameters = null, \StructType\AttributedQName $portType = null, \StructType\ServiceNameType $serviceName = null, \DOMDocument $any = null)
    {
        $this
            ->setAddress($address)
            ->setReferenceProperties($referenceProperties)
            ->setReferenceParameters($referenceParameters)
            ->setPortType($portType)
            ->setServiceName($serviceName)
            ->setAny($any);
    }
    /**
     * Get Address value
     * @return \StructType\AttributedURI|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\AttributedURI $address
     * @return \StructType\EndpointReferenceType
     */
    public function setAddress(\StructType\AttributedURI $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ReferenceProperties value
     * @return \StructType\ReferencePropertiesType|null
     */
    public function getReferenceProperties()
    {
        return $this->ReferenceProperties;
    }
    /**
     * Set ReferenceProperties value
     * @param \StructType\ReferencePropertiesType $referenceProperties
     * @return \StructType\EndpointReferenceType
     */
    public function setReferenceProperties(\StructType\ReferencePropertiesType $referenceProperties = null)
    {
        $this->ReferenceProperties = $referenceProperties;
        return $this;
    }
    /**
     * Get ReferenceParameters value
     * @return \StructType\ReferenceParametersType|null
     */
    public function getReferenceParameters()
    {
        return $this->ReferenceParameters;
    }
    /**
     * Set ReferenceParameters value
     * @param \StructType\ReferenceParametersType $referenceParameters
     * @return \StructType\EndpointReferenceType
     */
    public function setReferenceParameters(\StructType\ReferenceParametersType $referenceParameters = null)
    {
        $this->ReferenceParameters = $referenceParameters;
        return $this;
    }
    /**
     * Get PortType value
     * @return \StructType\AttributedQName|null
     */
    public function getPortType()
    {
        return $this->PortType;
    }
    /**
     * Set PortType value
     * @param \StructType\AttributedQName $portType
     * @return \StructType\EndpointReferenceType
     */
    public function setPortType(\StructType\AttributedQName $portType = null)
    {
        $this->PortType = $portType;
        return $this;
    }
    /**
     * Get ServiceName value
     * @return \StructType\ServiceNameType|null
     */
    public function getServiceName()
    {
        return $this->ServiceName;
    }
    /**
     * Set ServiceName value
     * @param \StructType\ServiceNameType $serviceName
     * @return \StructType\EndpointReferenceType
     */
    public function setServiceName(\StructType\ServiceNameType $serviceName = null)
    {
        $this->ServiceName = $serviceName;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\EndpointReferenceType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EndpointReferenceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
