<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmployerType StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to send the effective date and/or expiration date. | Designates the office category within an organization. | Indicates that the receiving system should assume the default value if the user specifies no overriding value or
 * action. | Company or organization that employs the customer.
 * @subpackage Structs
 */
class EmployerType extends AbstractStructBase
{
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - documentation: The name of the company.
     * - minOccurs: 0
     * @var \StructType\CompanyNameType
     */
    public $CompanyName;
    /**
     * The RelatedEmployer
     * Meta information extracted from the WSDL
     * - documentation: The name of a company affiliated with the employer.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CompanyNameType[]
     */
    public $RelatedEmployer;
    /**
     * The EmployeeInfo
     * Meta information extracted from the WSDL
     * - documentation: Information about the employee.
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\EmployeeInfoType[]
     */
    public $EmployeeInfo;
    /**
     * The InternalRefNmbr
     * Meta information extracted from the WSDL
     * - documentation: Accounting code(s) assigned to travel for employer.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FreeTextType[]
     */
    public $InternalRefNmbr;
    /**
     * The TravelArranger
     * Meta information extracted from the WSDL
     * - documentation: Information on the organization responsible for arranging travel for the employer.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TravelArrangerType[]
     */
    public $TravelArranger;
    /**
     * The LoyaltyProgram
     * Meta information extracted from the WSDL
     * - documentation: Employer's loyalty program information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LoyaltyProgramType[]
     */
    public $LoyaltyProgram;
    /**
     * The DefaultInd
     * @var bool
     */
    public $DefaultInd;
    /**
     * The OfficeType
     * @var string
     */
    public $OfficeType;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The ExpireDateExclusiveIndicator
     * @var bool
     */
    public $ExpireDateExclusiveIndicator;
    /**
     * Constructor method for EmployerType
     * @uses EmployerType::setCompanyName()
     * @uses EmployerType::setRelatedEmployer()
     * @uses EmployerType::setEmployeeInfo()
     * @uses EmployerType::setInternalRefNmbr()
     * @uses EmployerType::setTravelArranger()
     * @uses EmployerType::setLoyaltyProgram()
     * @uses EmployerType::setDefaultInd()
     * @uses EmployerType::setOfficeType()
     * @uses EmployerType::setEffectiveDate()
     * @uses EmployerType::setExpireDate()
     * @uses EmployerType::setExpireDateExclusiveIndicator()
     * @param \StructType\CompanyNameType $companyName
     * @param \StructType\CompanyNameType[] $relatedEmployer
     * @param \StructType\EmployeeInfoType[] $employeeInfo
     * @param \StructType\FreeTextType[] $internalRefNmbr
     * @param \StructType\TravelArrangerType[] $travelArranger
     * @param \StructType\LoyaltyProgramType[] $loyaltyProgram
     * @param bool $defaultInd
     * @param string $officeType
     * @param string $effectiveDate
     * @param string $expireDate
     * @param bool $expireDateExclusiveIndicator
     */
    public function __construct(\StructType\CompanyNameType $companyName = null, array $relatedEmployer = array(), array $employeeInfo = array(), array $internalRefNmbr = array(), array $travelArranger = array(), array $loyaltyProgram = array(), $defaultInd = null, $officeType = null, $effectiveDate = null, $expireDate = null, $expireDateExclusiveIndicator = null)
    {
        $this
            ->setCompanyName($companyName)
            ->setRelatedEmployer($relatedEmployer)
            ->setEmployeeInfo($employeeInfo)
            ->setInternalRefNmbr($internalRefNmbr)
            ->setTravelArranger($travelArranger)
            ->setLoyaltyProgram($loyaltyProgram)
            ->setDefaultInd($defaultInd)
            ->setOfficeType($officeType)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setExpireDateExclusiveIndicator($expireDateExclusiveIndicator);
    }
    /**
     * Get CompanyName value
     * @return \StructType\CompanyNameType|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param \StructType\CompanyNameType $companyName
     * @return \StructType\EmployerType
     */
    public function setCompanyName(\StructType\CompanyNameType $companyName = null)
    {
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get RelatedEmployer value
     * @return \StructType\CompanyNameType[]|null
     */
    public function getRelatedEmployer()
    {
        return $this->RelatedEmployer;
    }
    /**
     * This method is responsible for validating the values passed to the setRelatedEmployer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelatedEmployer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelatedEmployerForArrayConstraintsFromSetRelatedEmployer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $employerTypeRelatedEmployerItem) {
            // validation for constraint: itemType
            if (!$employerTypeRelatedEmployerItem instanceof \StructType\CompanyNameType) {
                $invalidValues[] = is_object($employerTypeRelatedEmployerItem) ? get_class($employerTypeRelatedEmployerItem) : sprintf('%s(%s)', gettype($employerTypeRelatedEmployerItem), var_export($employerTypeRelatedEmployerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RelatedEmployer property can only contain items of type \StructType\CompanyNameType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RelatedEmployer value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyNameType[] $relatedEmployer
     * @return \StructType\EmployerType
     */
    public function setRelatedEmployer(array $relatedEmployer = array())
    {
        // validation for constraint: array
        if ('' !== ($relatedEmployerArrayErrorMessage = self::validateRelatedEmployerForArrayConstraintsFromSetRelatedEmployer($relatedEmployer))) {
            throw new \InvalidArgumentException($relatedEmployerArrayErrorMessage, __LINE__);
        }
        $this->RelatedEmployer = $relatedEmployer;
        return $this;
    }
    /**
     * Add item to RelatedEmployer value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyNameType $item
     * @return \StructType\EmployerType
     */
    public function addToRelatedEmployer(\StructType\CompanyNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompanyNameType) {
            throw new \InvalidArgumentException(sprintf('The RelatedEmployer property can only contain items of type \StructType\CompanyNameType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RelatedEmployer[] = $item;
        return $this;
    }
    /**
     * Get EmployeeInfo value
     * @return \StructType\EmployeeInfoType[]|null
     */
    public function getEmployeeInfo()
    {
        return $this->EmployeeInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setEmployeeInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmployeeInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmployeeInfoForArrayConstraintsFromSetEmployeeInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $employerTypeEmployeeInfoItem) {
            // validation for constraint: itemType
            if (!$employerTypeEmployeeInfoItem instanceof \StructType\EmployeeInfoType) {
                $invalidValues[] = is_object($employerTypeEmployeeInfoItem) ? get_class($employerTypeEmployeeInfoItem) : sprintf('%s(%s)', gettype($employerTypeEmployeeInfoItem), var_export($employerTypeEmployeeInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EmployeeInfo property can only contain items of type \StructType\EmployeeInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\EmployeeInfoType[] $employeeInfo
     * @return \StructType\EmployerType
     */
    public function setEmployeeInfo(array $employeeInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($employeeInfoArrayErrorMessage = self::validateEmployeeInfoForArrayConstraintsFromSetEmployeeInfo($employeeInfo))) {
            throw new \InvalidArgumentException($employeeInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($employeeInfo) && count($employeeInfo) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($employeeInfo)), __LINE__);
        }
        $this->EmployeeInfo = $employeeInfo;
        return $this;
    }
    /**
     * Add item to EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\EmployeeInfoType $item
     * @return \StructType\EmployerType
     */
    public function addToEmployeeInfo(\StructType\EmployeeInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EmployeeInfoType) {
            throw new \InvalidArgumentException(sprintf('The EmployeeInfo property can only contain items of type \StructType\EmployeeInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->EmployeeInfo) && count($this->EmployeeInfo) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->EmployeeInfo)), __LINE__);
        }
        $this->EmployeeInfo[] = $item;
        return $this;
    }
    /**
     * Get InternalRefNmbr value
     * @return \StructType\FreeTextType[]|null
     */
    public function getInternalRefNmbr()
    {
        return $this->InternalRefNmbr;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalRefNmbr method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalRefNmbr method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalRefNmbrForArrayConstraintsFromSetInternalRefNmbr(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $employerTypeInternalRefNmbrItem) {
            // validation for constraint: itemType
            if (!$employerTypeInternalRefNmbrItem instanceof \StructType\FreeTextType) {
                $invalidValues[] = is_object($employerTypeInternalRefNmbrItem) ? get_class($employerTypeInternalRefNmbrItem) : sprintf('%s(%s)', gettype($employerTypeInternalRefNmbrItem), var_export($employerTypeInternalRefNmbrItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InternalRefNmbr property can only contain items of type \StructType\FreeTextType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InternalRefNmbr value
     * @throws \InvalidArgumentException
     * @param \StructType\FreeTextType[] $internalRefNmbr
     * @return \StructType\EmployerType
     */
    public function setInternalRefNmbr(array $internalRefNmbr = array())
    {
        // validation for constraint: array
        if ('' !== ($internalRefNmbrArrayErrorMessage = self::validateInternalRefNmbrForArrayConstraintsFromSetInternalRefNmbr($internalRefNmbr))) {
            throw new \InvalidArgumentException($internalRefNmbrArrayErrorMessage, __LINE__);
        }
        $this->InternalRefNmbr = $internalRefNmbr;
        return $this;
    }
    /**
     * Add item to InternalRefNmbr value
     * @throws \InvalidArgumentException
     * @param \StructType\FreeTextType $item
     * @return \StructType\EmployerType
     */
    public function addToInternalRefNmbr(\StructType\FreeTextType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FreeTextType) {
            throw new \InvalidArgumentException(sprintf('The InternalRefNmbr property can only contain items of type \StructType\FreeTextType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InternalRefNmbr[] = $item;
        return $this;
    }
    /**
     * Get TravelArranger value
     * @return \StructType\TravelArrangerType[]|null
     */
    public function getTravelArranger()
    {
        return $this->TravelArranger;
    }
    /**
     * This method is responsible for validating the values passed to the setTravelArranger method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelArranger method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelArrangerForArrayConstraintsFromSetTravelArranger(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $employerTypeTravelArrangerItem) {
            // validation for constraint: itemType
            if (!$employerTypeTravelArrangerItem instanceof \StructType\TravelArrangerType) {
                $invalidValues[] = is_object($employerTypeTravelArrangerItem) ? get_class($employerTypeTravelArrangerItem) : sprintf('%s(%s)', gettype($employerTypeTravelArrangerItem), var_export($employerTypeTravelArrangerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TravelArranger property can only contain items of type \StructType\TravelArrangerType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TravelArranger value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelArrangerType[] $travelArranger
     * @return \StructType\EmployerType
     */
    public function setTravelArranger(array $travelArranger = array())
    {
        // validation for constraint: array
        if ('' !== ($travelArrangerArrayErrorMessage = self::validateTravelArrangerForArrayConstraintsFromSetTravelArranger($travelArranger))) {
            throw new \InvalidArgumentException($travelArrangerArrayErrorMessage, __LINE__);
        }
        $this->TravelArranger = $travelArranger;
        return $this;
    }
    /**
     * Add item to TravelArranger value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelArrangerType $item
     * @return \StructType\EmployerType
     */
    public function addToTravelArranger(\StructType\TravelArrangerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TravelArrangerType) {
            throw new \InvalidArgumentException(sprintf('The TravelArranger property can only contain items of type \StructType\TravelArrangerType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TravelArranger[] = $item;
        return $this;
    }
    /**
     * Get LoyaltyProgram value
     * @return \StructType\LoyaltyProgramType[]|null
     */
    public function getLoyaltyProgram()
    {
        return $this->LoyaltyProgram;
    }
    /**
     * This method is responsible for validating the values passed to the setLoyaltyProgram method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoyaltyProgram method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLoyaltyProgramForArrayConstraintsFromSetLoyaltyProgram(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $employerTypeLoyaltyProgramItem) {
            // validation for constraint: itemType
            if (!$employerTypeLoyaltyProgramItem instanceof \StructType\LoyaltyProgramType) {
                $invalidValues[] = is_object($employerTypeLoyaltyProgramItem) ? get_class($employerTypeLoyaltyProgramItem) : sprintf('%s(%s)', gettype($employerTypeLoyaltyProgramItem), var_export($employerTypeLoyaltyProgramItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LoyaltyProgram property can only contain items of type \StructType\LoyaltyProgramType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LoyaltyProgram value
     * @throws \InvalidArgumentException
     * @param \StructType\LoyaltyProgramType[] $loyaltyProgram
     * @return \StructType\EmployerType
     */
    public function setLoyaltyProgram(array $loyaltyProgram = array())
    {
        // validation for constraint: array
        if ('' !== ($loyaltyProgramArrayErrorMessage = self::validateLoyaltyProgramForArrayConstraintsFromSetLoyaltyProgram($loyaltyProgram))) {
            throw new \InvalidArgumentException($loyaltyProgramArrayErrorMessage, __LINE__);
        }
        $this->LoyaltyProgram = $loyaltyProgram;
        return $this;
    }
    /**
     * Add item to LoyaltyProgram value
     * @throws \InvalidArgumentException
     * @param \StructType\LoyaltyProgramType $item
     * @return \StructType\EmployerType
     */
    public function addToLoyaltyProgram(\StructType\LoyaltyProgramType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LoyaltyProgramType) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyProgram property can only contain items of type \StructType\LoyaltyProgramType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LoyaltyProgram[] = $item;
        return $this;
    }
    /**
     * Get DefaultInd value
     * @return bool|null
     */
    public function getDefaultInd()
    {
        return $this->DefaultInd;
    }
    /**
     * Set DefaultInd value
     * @param bool $defaultInd
     * @return \StructType\EmployerType
     */
    public function setDefaultInd($defaultInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($defaultInd) && !is_bool($defaultInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($defaultInd, true), gettype($defaultInd)), __LINE__);
        }
        $this->DefaultInd = $defaultInd;
        return $this;
    }
    /**
     * Get OfficeType value
     * @return string|null
     */
    public function getOfficeType()
    {
        return $this->OfficeType;
    }
    /**
     * Set OfficeType value
     * @uses \EnumType\OfficeLocationType::valueIsValid()
     * @uses \EnumType\OfficeLocationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $officeType
     * @return \StructType\EmployerType
     */
    public function setOfficeType($officeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OfficeLocationType::valueIsValid($officeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OfficeLocationType', is_array($officeType) ? implode(', ', $officeType) : var_export($officeType, true), implode(', ', \EnumType\OfficeLocationType::getValidValues())), __LINE__);
        }
        $this->OfficeType = $officeType;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\EmployerType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\EmployerType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get ExpireDateExclusiveIndicator value
     * @return bool|null
     */
    public function getExpireDateExclusiveIndicator()
    {
        return $this->ExpireDateExclusiveIndicator;
    }
    /**
     * Set ExpireDateExclusiveIndicator value
     * @param bool $expireDateExclusiveIndicator
     * @return \StructType\EmployerType
     */
    public function setExpireDateExclusiveIndicator($expireDateExclusiveIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($expireDateExclusiveIndicator) && !is_bool($expireDateExclusiveIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expireDateExclusiveIndicator, true), gettype($expireDateExclusiveIndicator)), __LINE__);
        }
        $this->ExpireDateExclusiveIndicator = $expireDateExclusiveIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EmployerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
