<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DistributorType StructType
 * @subpackage Structs
 */
class DistributorType extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The DistributorCode
     * Meta information extracted from the WSDL
     * - documentation: Code used to uniquely identify the distributor. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $DistributorCode;
    /**
     * The DistributorTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Type code is used to qualify the Distibutor into general classes of distributors. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $DistributorTypeCode;
    /**
     * Constructor method for DistributorType
     * @uses DistributorType::set_()
     * @uses DistributorType::setDistributorCode()
     * @uses DistributorType::setDistributorTypeCode()
     * @param string $_
     * @param string $distributorCode
     * @param string $distributorTypeCode
     */
    public function __construct($_ = null, $distributorCode = null, $distributorTypeCode = null)
    {
        $this
            ->set_($_)
            ->setDistributorCode($distributorCode)
            ->setDistributorTypeCode($distributorTypeCode);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\DistributorType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get DistributorCode value
     * @return string|null
     */
    public function getDistributorCode()
    {
        return $this->DistributorCode;
    }
    /**
     * Set DistributorCode value
     * @param string $distributorCode
     * @return \StructType\DistributorType
     */
    public function setDistributorCode($distributorCode = null)
    {
        // validation for constraint: string
        if (!is_null($distributorCode) && !is_string($distributorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distributorCode, true), gettype($distributorCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($distributorCode) && mb_strlen($distributorCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($distributorCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($distributorCode) && mb_strlen($distributorCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($distributorCode)), __LINE__);
        }
        $this->DistributorCode = $distributorCode;
        return $this;
    }
    /**
     * Get DistributorTypeCode value
     * @return string|null
     */
    public function getDistributorTypeCode()
    {
        return $this->DistributorTypeCode;
    }
    /**
     * Set DistributorTypeCode value
     * @param string $distributorTypeCode
     * @return \StructType\DistributorType
     */
    public function setDistributorTypeCode($distributorTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($distributorTypeCode) && !is_string($distributorTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distributorTypeCode, true), gettype($distributorTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($distributorTypeCode) && mb_strlen($distributorTypeCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($distributorTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($distributorTypeCode) && mb_strlen($distributorTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($distributorTypeCode)), __LINE__);
        }
        $this->DistributorTypeCode = $distributorTypeCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DistributorType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
