<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiscountPricing StructType
 * Meta information extracted from the WSDL
 * - documentation: The information needed when a passenger presents a discount/promotional coupon for a dollar/percentage of the fare or when a passenger qualifies for a percentage discount such as a senior discount. | The information needed when a
 * passenger presents a discount/promotional coupon for a dollar/percentage off the fare or when a passenger qualifies for a percentage discount such as a senior discount.
 * @subpackage Structs
 */
class DiscountPricing extends AbstractStructBase
{
    /**
     * The Purpose
     * @var string
     */
    public $Purpose;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Usage
     * @var string
     */
    public $Usage;
    /**
     * The Discount
     * Meta information extracted from the WSDL
     * - documentation: The monetary amount or percentage of discount that should be applied. | A union of money and percentage so that the appropriate data can be sent in a single field.
     * - type: MoneyOrPercentageType
     * - union: Money | Percentage
     * - use: optional
     * @var string
     */
    public $Discount;
    /**
     * The TicketDesignatorCode
     * Meta information extracted from the WSDL
     * - documentation: Specifies the code applicable to the fare that is being discounted. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $TicketDesignatorCode;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 128.
     * - base: xs:string
     * - maxLength: 128
     * - minLength: 1
     * - type: StringLength1to128
     * - use: optional
     * @var string
     */
    public $Text;
    /**
     * The FlightReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 16
     * - minOccurs: 0
     * @var \StructType\FlightReference[]
     */
    public $FlightReference;
    /**
     * Constructor method for DiscountPricing
     * @uses DiscountPricing::setPurpose()
     * @uses DiscountPricing::setType()
     * @uses DiscountPricing::setUsage()
     * @uses DiscountPricing::setDiscount()
     * @uses DiscountPricing::setTicketDesignatorCode()
     * @uses DiscountPricing::setText()
     * @uses DiscountPricing::setFlightReference()
     * @param string $purpose
     * @param string $type
     * @param string $usage
     * @param string $discount
     * @param string $ticketDesignatorCode
     * @param string $text
     * @param \StructType\FlightReference[] $flightReference
     */
    public function __construct($purpose = null, $type = null, $usage = null, $discount = null, $ticketDesignatorCode = null, $text = null, array $flightReference = array())
    {
        $this
            ->setPurpose($purpose)
            ->setType($type)
            ->setUsage($usage)
            ->setDiscount($discount)
            ->setTicketDesignatorCode($ticketDesignatorCode)
            ->setText($text)
            ->setFlightReference($flightReference);
    }
    /**
     * Get Purpose value
     * @return string|null
     */
    public function getPurpose()
    {
        return $this->Purpose;
    }
    /**
     * Set Purpose value
     * @param string $purpose
     * @return \StructType\DiscountPricing
     */
    public function setPurpose($purpose = null)
    {
        // validation for constraint: string
        if (!is_null($purpose) && !is_string($purpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purpose, true), gettype($purpose)), __LINE__);
        }
        $this->Purpose = $purpose;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\DiscountPricing
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Usage value
     * @return string|null
     */
    public function getUsage()
    {
        return $this->Usage;
    }
    /**
     * Set Usage value
     * @param string $usage
     * @return \StructType\DiscountPricing
     */
    public function setUsage($usage = null)
    {
        // validation for constraint: string
        if (!is_null($usage) && !is_string($usage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usage, true), gettype($usage)), __LINE__);
        }
        $this->Usage = $usage;
        return $this;
    }
    /**
     * Get Discount value
     * @return string|null
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * This method is responsible for validating the value passed to the setDiscount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDiscount method
     * This is a set of validation rules based on the union types associated to the property being set by the setDiscount method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDiscountForUnionConstraintsFromSetDiscount($value)
    {
        $message = '';
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            $exception0 = new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($value) && mb_strlen(mb_substr($value, mb_strpos($value, '.') + 1)) > 3) {
            $exception1 = new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($value, true), mb_strlen(mb_substr($value, mb_strpos($value, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(100.00)
        if (!is_null($value) && $value > 100.00) {
            $exception2 = new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 100.00', var_export($value, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($value) && $value < 0.00) {
            $exception3 = new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($value, true)), __LINE__);
        }
        if (isset($exception0) && isset($exception1) && isset($exception2) && isset($exception3)) {
            $message = sprintf("The value %s does not match any of the union rules: Money, Percentage. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [$exception0, $exception1, $exception2, $exception3])));
        }
        unset($exception0, $exception1, $exception2, $exception3);
        return $message;
    }
    /**
     * Set Discount value
     * @param string $discount
     * @return \StructType\DiscountPricing
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: string
        if (!is_null($discount) && !is_string($discount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discount, true), gettype($discount)), __LINE__);
        }
        // validation for constraint: union(Money, Percentage)
        if ('' !== ($discountUnionErrorMessage = self::validateDiscountForUnionConstraintsFromSetDiscount($discount))) {
            throw new \InvalidArgumentException($discountUnionErrorMessage, __LINE__);
        }
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get TicketDesignatorCode value
     * @return string|null
     */
    public function getTicketDesignatorCode()
    {
        return $this->TicketDesignatorCode;
    }
    /**
     * Set TicketDesignatorCode value
     * @param string $ticketDesignatorCode
     * @return \StructType\DiscountPricing
     */
    public function setTicketDesignatorCode($ticketDesignatorCode = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDesignatorCode) && !is_string($ticketDesignatorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketDesignatorCode, true), gettype($ticketDesignatorCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($ticketDesignatorCode) && mb_strlen($ticketDesignatorCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($ticketDesignatorCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ticketDesignatorCode) && mb_strlen($ticketDesignatorCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ticketDesignatorCode)), __LINE__);
        }
        $this->TicketDesignatorCode = $ticketDesignatorCode;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \StructType\DiscountPricing
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($text) && mb_strlen($text) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($text)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($text) && mb_strlen($text) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get FlightReference value
     * @return \StructType\FlightReference[]|null
     */
    public function getFlightReference()
    {
        return $this->FlightReference;
    }
    /**
     * This method is responsible for validating the values passed to the setFlightReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlightReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFlightReferenceForArrayConstraintsFromSetFlightReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $discountPricingFlightReferenceItem) {
            // validation for constraint: itemType
            if (!$discountPricingFlightReferenceItem instanceof \StructType\FlightReference) {
                $invalidValues[] = is_object($discountPricingFlightReferenceItem) ? get_class($discountPricingFlightReferenceItem) : sprintf('%s(%s)', gettype($discountPricingFlightReferenceItem), var_export($discountPricingFlightReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FlightReference property can only contain items of type \StructType\FlightReference, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FlightReference value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightReference[] $flightReference
     * @return \StructType\DiscountPricing
     */
    public function setFlightReference(array $flightReference = array())
    {
        // validation for constraint: array
        if ('' !== ($flightReferenceArrayErrorMessage = self::validateFlightReferenceForArrayConstraintsFromSetFlightReference($flightReference))) {
            throw new \InvalidArgumentException($flightReferenceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(16)
        if (is_array($flightReference) && count($flightReference) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 16', count($flightReference)), __LINE__);
        }
        $this->FlightReference = $flightReference;
        return $this;
    }
    /**
     * Add item to FlightReference value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightReference $item
     * @return \StructType\DiscountPricing
     */
    public function addToFlightReference(\StructType\FlightReference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FlightReference) {
            throw new \InvalidArgumentException(sprintf('The FlightReference property can only contain items of type \StructType\FlightReference, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(16)
        if (is_array($this->FlightReference) && count($this->FlightReference) >= 16) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 16', count($this->FlightReference)), __LINE__);
        }
        $this->FlightReference[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DiscountPricing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
