<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DirectBillType StructType
 * Meta information extracted from the WSDL
 * - documentation: Allows for control of the sharing of direct bill data between parties. | Company name and location for sending invoice for remittances for travel services.
 * @subpackage Structs
 */
class DirectBillType extends AbstractStructBase
{
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CompanyName
     */
    public $CompanyName;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - documentation: Address where remittance should be directed.
     * - minOccurs: 0
     * @var \StructType\AddressInfoType
     */
    public $Address;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - documentation: Email address to which remittance should be directed.
     * - minOccurs: 0
     * @var \StructType\EmailType
     */
    public $Email;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Telephone
     */
    public $Telephone;
    /**
     * The DirectBill_ID
     * Meta information extracted from the WSDL
     * - documentation: Identifier for the organization to be billed directly for travel services. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $DirectBill_ID;
    /**
     * The BillingNumber
     * Meta information extracted from the WSDL
     * - documentation: The number assigned by the subscriber for billing reconciliation of a corporate account. | Used for Character Strings, length 0 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 0
     * - use: optional
     * @var string
     */
    public $BillingNumber;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * Constructor method for DirectBillType
     * @uses DirectBillType::setCompanyName()
     * @uses DirectBillType::setAddress()
     * @uses DirectBillType::setEmail()
     * @uses DirectBillType::setTelephone()
     * @uses DirectBillType::setDirectBill_ID()
     * @uses DirectBillType::setBillingNumber()
     * @uses DirectBillType::setShareSynchInd()
     * @uses DirectBillType::setShareMarketInd()
     * @param \StructType\CompanyName $companyName
     * @param \StructType\AddressInfoType $address
     * @param \StructType\EmailType $email
     * @param \StructType\Telephone $telephone
     * @param string $directBill_ID
     * @param string $billingNumber
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     */
    public function __construct(\StructType\CompanyName $companyName = null, \StructType\AddressInfoType $address = null, \StructType\EmailType $email = null, \StructType\Telephone $telephone = null, $directBill_ID = null, $billingNumber = null, $shareSynchInd = null, $shareMarketInd = null)
    {
        $this
            ->setCompanyName($companyName)
            ->setAddress($address)
            ->setEmail($email)
            ->setTelephone($telephone)
            ->setDirectBill_ID($directBill_ID)
            ->setBillingNumber($billingNumber)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd);
    }
    /**
     * Get CompanyName value
     * @return \StructType\CompanyName|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param \StructType\CompanyName $companyName
     * @return \StructType\DirectBillType
     */
    public function setCompanyName(\StructType\CompanyName $companyName = null)
    {
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\AddressInfoType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\AddressInfoType $address
     * @return \StructType\DirectBillType
     */
    public function setAddress(\StructType\AddressInfoType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Email value
     * @return \StructType\EmailType|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param \StructType\EmailType $email
     * @return \StructType\DirectBillType
     */
    public function setEmail(\StructType\EmailType $email = null)
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \StructType\Telephone|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param \StructType\Telephone $telephone
     * @return \StructType\DirectBillType
     */
    public function setTelephone(\StructType\Telephone $telephone = null)
    {
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Get DirectBill_ID value
     * @return string|null
     */
    public function getDirectBill_ID()
    {
        return $this->DirectBill_ID;
    }
    /**
     * Set DirectBill_ID value
     * @param string $directBill_ID
     * @return \StructType\DirectBillType
     */
    public function setDirectBill_ID($directBill_ID = null)
    {
        // validation for constraint: string
        if (!is_null($directBill_ID) && !is_string($directBill_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directBill_ID, true), gettype($directBill_ID)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($directBill_ID) && mb_strlen($directBill_ID) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($directBill_ID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($directBill_ID) && mb_strlen($directBill_ID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($directBill_ID)), __LINE__);
        }
        $this->DirectBill_ID = $directBill_ID;
        return $this;
    }
    /**
     * Get BillingNumber value
     * @return string|null
     */
    public function getBillingNumber()
    {
        return $this->BillingNumber;
    }
    /**
     * Set BillingNumber value
     * @param string $billingNumber
     * @return \StructType\DirectBillType
     */
    public function setBillingNumber($billingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($billingNumber) && !is_string($billingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingNumber, true), gettype($billingNumber)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($billingNumber) && mb_strlen($billingNumber) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($billingNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($billingNumber) && mb_strlen($billingNumber) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($billingNumber)), __LINE__);
        }
        $this->BillingNumber = $billingNumber;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \StructType\DirectBillType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\DirectBillType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DirectBillType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
