<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeductibleType StructType
 * Meta information extracted from the WSDL
 * - documentation: The deductible amount for this coverage.
 * @subpackage Structs
 */
class DeductibleType extends AbstractStructBase
{
    /**
     * The LiabilityAmount
     * Meta information extracted from the WSDL
     * - documentation: The total liability amount for this coverage. | Specifies an amount, max 3 decimals.
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $LiabilityAmount;
    /**
     * The ExcessAmount
     * Meta information extracted from the WSDL
     * - documentation: The excess amount for this coverage. | Specifies an amount, max 3 decimals.
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $ExcessAmount;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Specifies an amount, max 3 decimals.
     * - base: xs:decimal
     * - fractionDigits: 3
     * @var float
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Used for an Alpha String, length exactly 3.
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * Constructor method for DeductibleType
     * @uses DeductibleType::setLiabilityAmount()
     * @uses DeductibleType::setExcessAmount()
     * @uses DeductibleType::setAmount()
     * @uses DeductibleType::setCurrencyCode()
     * @uses DeductibleType::setDecimalPlaces()
     * @param float $liabilityAmount
     * @param float $excessAmount
     * @param float $amount
     * @param string $currencyCode
     * @param int $decimalPlaces
     */
    public function __construct($liabilityAmount = null, $excessAmount = null, $amount = null, $currencyCode = null, $decimalPlaces = null)
    {
        $this
            ->setLiabilityAmount($liabilityAmount)
            ->setExcessAmount($excessAmount)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces);
    }
    /**
     * Get LiabilityAmount value
     * @return float|null
     */
    public function getLiabilityAmount()
    {
        return $this->LiabilityAmount;
    }
    /**
     * Set LiabilityAmount value
     * @param float $liabilityAmount
     * @return \StructType\DeductibleType
     */
    public function setLiabilityAmount($liabilityAmount = null)
    {
        // validation for constraint: float
        if (!is_null($liabilityAmount) && !(is_float($liabilityAmount) || is_numeric($liabilityAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($liabilityAmount, true), gettype($liabilityAmount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($liabilityAmount) && mb_strlen(mb_substr($liabilityAmount, mb_strpos($liabilityAmount, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($liabilityAmount, true), mb_strlen(mb_substr($liabilityAmount, mb_strpos($liabilityAmount, '.') + 1))), __LINE__);
        }
        $this->LiabilityAmount = $liabilityAmount;
        return $this;
    }
    /**
     * Get ExcessAmount value
     * @return float|null
     */
    public function getExcessAmount()
    {
        return $this->ExcessAmount;
    }
    /**
     * Set ExcessAmount value
     * @param float $excessAmount
     * @return \StructType\DeductibleType
     */
    public function setExcessAmount($excessAmount = null)
    {
        // validation for constraint: float
        if (!is_null($excessAmount) && !(is_float($excessAmount) || is_numeric($excessAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($excessAmount, true), gettype($excessAmount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($excessAmount) && mb_strlen(mb_substr($excessAmount, mb_strpos($excessAmount, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($excessAmount, true), mb_strlen(mb_substr($excessAmount, mb_strpos($excessAmount, '.') + 1))), __LINE__);
        }
        $this->ExcessAmount = $excessAmount;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\DeductibleType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($amount) && mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($amount, true), mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1))), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\DeductibleType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{3})
        if (!is_null($currencyCode) && !preg_match('/[a-zA-Z]{3}/', $currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{3}', var_export($currencyCode, true)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\DeductibleType
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeductibleType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
