<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Deadline StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides ability to give a deadline for the cancel penalty. It repeats to allow for a range (e.g., from 30 to 20 days before arrival). | Time by which a cancellation must be made before penalty fees are incurred or defines a period
 * of time for which a specific fee is applied if a cancellation were to occur. | Payment deadline, absolute or relative. | Guarantee deadline, absolute or relative. | The absolute deadline or amount of offset time before a deadline for a payment of
 * cancel goes into effect. | Cancellation deadline, absolute or relative.
 * @subpackage Structs
 */
class Deadline extends AbstractStructBase
{
    /**
     * The AbsoluteDeadline
     * Meta information extracted from the WSDL
     * - documentation: Allows for the specification of a date time or just time.
     * - union: dateTime | time
     * @var string
     */
    public $AbsoluteDeadline;
    /**
     * The OffsetTimeUnit
     * @var string
     */
    public $OffsetTimeUnit;
    /**
     * The OffsetUnitMultiplier
     * Meta information extracted from the WSDL
     * - documentation: Used for Numeric values, from 0 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 0
     * @var int
     */
    public $OffsetUnitMultiplier;
    /**
     * The OffsetDropTime
     * @var string
     */
    public $OffsetDropTime;
    /**
     * The OverrideIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates that the deadline has been overridden.
     * - use: optional
     * @var bool
     */
    public $OverrideIndicator;
    /**
     * Constructor method for Deadline
     * @uses Deadline::setAbsoluteDeadline()
     * @uses Deadline::setOffsetTimeUnit()
     * @uses Deadline::setOffsetUnitMultiplier()
     * @uses Deadline::setOffsetDropTime()
     * @uses Deadline::setOverrideIndicator()
     * @param string $absoluteDeadline
     * @param string $offsetTimeUnit
     * @param int $offsetUnitMultiplier
     * @param string $offsetDropTime
     * @param bool $overrideIndicator
     */
    public function __construct($absoluteDeadline = null, $offsetTimeUnit = null, $offsetUnitMultiplier = null, $offsetDropTime = null, $overrideIndicator = null)
    {
        $this
            ->setAbsoluteDeadline($absoluteDeadline)
            ->setOffsetTimeUnit($offsetTimeUnit)
            ->setOffsetUnitMultiplier($offsetUnitMultiplier)
            ->setOffsetDropTime($offsetDropTime)
            ->setOverrideIndicator($overrideIndicator);
    }
    /**
     * Get AbsoluteDeadline value
     * @return string|null
     */
    public function getAbsoluteDeadline()
    {
        return $this->AbsoluteDeadline;
    }
    /**
     * This method is responsible for validating the value passed to the setAbsoluteDeadline method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAbsoluteDeadline method
     * This is a set of validation rules based on the union types associated to the property being set by the setAbsoluteDeadline method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAbsoluteDeadlineForUnionConstraintsFromSetAbsoluteDeadline($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set AbsoluteDeadline value
     * @param string $absoluteDeadline
     * @return \StructType\Deadline
     */
    public function setAbsoluteDeadline($absoluteDeadline = null)
    {
        // validation for constraint: string
        if (!is_null($absoluteDeadline) && !is_string($absoluteDeadline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($absoluteDeadline, true), gettype($absoluteDeadline)), __LINE__);
        }
        // validation for constraint: union(dateTime, time)
        if ('' !== ($absoluteDeadlineUnionErrorMessage = self::validateAbsoluteDeadlineForUnionConstraintsFromSetAbsoluteDeadline($absoluteDeadline))) {
            throw new \InvalidArgumentException($absoluteDeadlineUnionErrorMessage, __LINE__);
        }
        $this->AbsoluteDeadline = $absoluteDeadline;
        return $this;
    }
    /**
     * Get OffsetTimeUnit value
     * @return string|null
     */
    public function getOffsetTimeUnit()
    {
        return $this->OffsetTimeUnit;
    }
    /**
     * Set OffsetTimeUnit value
     * @uses \EnumType\TimeUnitType::valueIsValid()
     * @uses \EnumType\TimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $offsetTimeUnit
     * @return \StructType\Deadline
     */
    public function setOffsetTimeUnit($offsetTimeUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TimeUnitType::valueIsValid($offsetTimeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TimeUnitType', is_array($offsetTimeUnit) ? implode(', ', $offsetTimeUnit) : var_export($offsetTimeUnit, true), implode(', ', \EnumType\TimeUnitType::getValidValues())), __LINE__);
        }
        $this->OffsetTimeUnit = $offsetTimeUnit;
        return $this;
    }
    /**
     * Get OffsetUnitMultiplier value
     * @return int|null
     */
    public function getOffsetUnitMultiplier()
    {
        return $this->OffsetUnitMultiplier;
    }
    /**
     * Set OffsetUnitMultiplier value
     * @param int $offsetUnitMultiplier
     * @return \StructType\Deadline
     */
    public function setOffsetUnitMultiplier($offsetUnitMultiplier = null)
    {
        // validation for constraint: int
        if (!is_null($offsetUnitMultiplier) && !(is_int($offsetUnitMultiplier) || ctype_digit($offsetUnitMultiplier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($offsetUnitMultiplier, true), gettype($offsetUnitMultiplier)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($offsetUnitMultiplier) && $offsetUnitMultiplier > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($offsetUnitMultiplier, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($offsetUnitMultiplier) && $offsetUnitMultiplier < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($offsetUnitMultiplier, true)), __LINE__);
        }
        $this->OffsetUnitMultiplier = $offsetUnitMultiplier;
        return $this;
    }
    /**
     * Get OffsetDropTime value
     * @return string|null
     */
    public function getOffsetDropTime()
    {
        return $this->OffsetDropTime;
    }
    /**
     * Set OffsetDropTime value
     * @param string $offsetDropTime
     * @return \StructType\Deadline
     */
    public function setOffsetDropTime($offsetDropTime = null)
    {
        // validation for constraint: string
        if (!is_null($offsetDropTime) && !is_string($offsetDropTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offsetDropTime, true), gettype($offsetDropTime)), __LINE__);
        }
        $this->OffsetDropTime = $offsetDropTime;
        return $this;
    }
    /**
     * Get OverrideIndicator value
     * @return bool|null
     */
    public function getOverrideIndicator()
    {
        return $this->OverrideIndicator;
    }
    /**
     * Set OverrideIndicator value
     * @param bool $overrideIndicator
     * @return \StructType\Deadline
     */
    public function setOverrideIndicator($overrideIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($overrideIndicator) && !is_bool($overrideIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($overrideIndicator, true), gettype($overrideIndicator)), __LINE__);
        }
        $this->OverrideIndicator = $overrideIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Deadline
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
