<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DateTimeSpanType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the date and/or time span. | Used to specify a time window range by either specifying an earliest and latest date for the start date and end date or by giving a date with a time period that can be applied before and/or after
 * the start date.
 * @subpackage Structs
 */
class DateTimeSpanType extends AbstractStructBase
{
    /**
     * The DateWindowRange
     * Meta information extracted from the WSDL
     * - documentation: Specifies a time period that can be applied before and/or after the start date.
     * - choice: DateWindowRange | StartDateWindow | EndDateWindow
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\TimeInstantType
     */
    public $DateWindowRange;
    /**
     * The StartDateWindow
     * Meta information extracted from the WSDL
     * - choice: DateWindowRange | StartDateWindow | EndDateWindow
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StartDateWindow
     */
    public $StartDateWindow;
    /**
     * The EndDateWindow
     * Meta information extracted from the WSDL
     * - choice: DateWindowRange | StartDateWindow | EndDateWindow
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EndDateWindow
     */
    public $EndDateWindow;
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - documentation: The starting value of the time span. | A construct to validate either a date or a time or a dateTime value.
     * - type: DateOrTimeOrDateTimeType
     * - union: date | dateTime | time
     * - use: optional
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - documentation: The duration datatype represents a combination of year, month, day and time values representing a single duration of time, encoded as a single string. | Allows for the specification of a night duration.
     * - type: DurationType
     * - union: duration | NightDurationType
     * - use: optional
     * @var string
     */
    public $Duration;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - documentation: The ending value of the time span. | A construct to validate either a date or a time or a dateTime value.
     * - type: DateOrTimeOrDateTimeType
     * - union: date | dateTime | time
     * - use: optional
     * @var string
     */
    public $End;
    /**
     * Constructor method for DateTimeSpanType
     * @uses DateTimeSpanType::setDateWindowRange()
     * @uses DateTimeSpanType::setStartDateWindow()
     * @uses DateTimeSpanType::setEndDateWindow()
     * @uses DateTimeSpanType::setStart()
     * @uses DateTimeSpanType::setDuration()
     * @uses DateTimeSpanType::setEnd()
     * @param \StructType\TimeInstantType $dateWindowRange
     * @param \StructType\StartDateWindow $startDateWindow
     * @param \StructType\EndDateWindow $endDateWindow
     * @param string $start
     * @param string $duration
     * @param string $end
     */
    public function __construct(\StructType\TimeInstantType $dateWindowRange = null, \StructType\StartDateWindow $startDateWindow = null, \StructType\EndDateWindow $endDateWindow = null, $start = null, $duration = null, $end = null)
    {
        $this
            ->setDateWindowRange($dateWindowRange)
            ->setStartDateWindow($startDateWindow)
            ->setEndDateWindow($endDateWindow)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end);
    }
    /**
     * Get DateWindowRange value
     * @return \StructType\TimeInstantType|null
     */
    public function getDateWindowRange()
    {
        return isset($this->DateWindowRange) ? $this->DateWindowRange : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDateWindowRange method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDateWindowRange method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDateWindowRangeForChoiceConstraintsFromSetDateWindowRange($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'StartDateWindow',
            'EndDateWindow',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DateWindowRange can\'t be set as the property %s is already set. Only one property must be set among these properties: DateWindowRange, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DateWindowRange value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TimeInstantType $dateWindowRange
     * @return \StructType\DateTimeSpanType
     */
    public function setDateWindowRange(\StructType\TimeInstantType $dateWindowRange = null)
    {
        // validation for constraint: choice(DateWindowRange, StartDateWindow, EndDateWindow)
        if ('' !== ($dateWindowRangeChoiceErrorMessage = self::validateDateWindowRangeForChoiceConstraintsFromSetDateWindowRange($dateWindowRange))) {
            throw new \InvalidArgumentException($dateWindowRangeChoiceErrorMessage, __LINE__);
        }
        if (is_null($dateWindowRange) || (is_array($dateWindowRange) && empty($dateWindowRange))) {
            unset($this->DateWindowRange);
        } else {
            $this->DateWindowRange = $dateWindowRange;
        }
        return $this;
    }
    /**
     * Get StartDateWindow value
     * @return \StructType\StartDateWindow|null
     */
    public function getStartDateWindow()
    {
        return isset($this->StartDateWindow) ? $this->StartDateWindow : null;
    }
    /**
     * This method is responsible for validating the value passed to the setStartDateWindow method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStartDateWindow method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateStartDateWindowForChoiceConstraintsFromSetStartDateWindow($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'DateWindowRange',
            'EndDateWindow',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property StartDateWindow can\'t be set as the property %s is already set. Only one property must be set among these properties: StartDateWindow, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set StartDateWindow value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\StartDateWindow $startDateWindow
     * @return \StructType\DateTimeSpanType
     */
    public function setStartDateWindow(\StructType\StartDateWindow $startDateWindow = null)
    {
        // validation for constraint: choice(DateWindowRange, StartDateWindow, EndDateWindow)
        if ('' !== ($startDateWindowChoiceErrorMessage = self::validateStartDateWindowForChoiceConstraintsFromSetStartDateWindow($startDateWindow))) {
            throw new \InvalidArgumentException($startDateWindowChoiceErrorMessage, __LINE__);
        }
        if (is_null($startDateWindow) || (is_array($startDateWindow) && empty($startDateWindow))) {
            unset($this->StartDateWindow);
        } else {
            $this->StartDateWindow = $startDateWindow;
        }
        return $this;
    }
    /**
     * Get EndDateWindow value
     * @return \StructType\EndDateWindow|null
     */
    public function getEndDateWindow()
    {
        return isset($this->EndDateWindow) ? $this->EndDateWindow : null;
    }
    /**
     * This method is responsible for validating the value passed to the setEndDateWindow method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEndDateWindow method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateEndDateWindowForChoiceConstraintsFromSetEndDateWindow($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'DateWindowRange',
            'StartDateWindow',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property EndDateWindow can\'t be set as the property %s is already set. Only one property must be set among these properties: EndDateWindow, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set EndDateWindow value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EndDateWindow $endDateWindow
     * @return \StructType\DateTimeSpanType
     */
    public function setEndDateWindow(\StructType\EndDateWindow $endDateWindow = null)
    {
        // validation for constraint: choice(DateWindowRange, StartDateWindow, EndDateWindow)
        if ('' !== ($endDateWindowChoiceErrorMessage = self::validateEndDateWindowForChoiceConstraintsFromSetEndDateWindow($endDateWindow))) {
            throw new \InvalidArgumentException($endDateWindowChoiceErrorMessage, __LINE__);
        }
        if (is_null($endDateWindow) || (is_array($endDateWindow) && empty($endDateWindow))) {
            unset($this->EndDateWindow);
        } else {
            $this->EndDateWindow = $endDateWindow;
        }
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * This method is responsible for validating the value passed to the setStart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStart method
     * This is a set of validation rules based on the union types associated to the property being set by the setStart method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStartForUnionConstraintsFromSetStart($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\DateTimeSpanType
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($startUnionErrorMessage = self::validateStartForUnionConstraintsFromSetStart($start))) {
            throw new \InvalidArgumentException($startUnionErrorMessage, __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * This method is responsible for validating the value passed to the setDuration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDuration method
     * This is a set of validation rules based on the union types associated to the property being set by the setDuration method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDurationForUnionConstraintsFromSetDuration($value)
    {
        $message = '';
        // validation for constraint: pattern(P[0-9]{1,3}N)
        if (!is_null($value) && !preg_match('/P[0-9]{1,3}N/', $value)) {
            $exception0 = new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression P[0-9]{1,3}N', var_export($value, true)), __LINE__);
        }
        if (isset($exception0)) {
            $message = sprintf("The value %s does not match any of the union rules: duration, NightDurationType. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [$exception0])));
        }
        unset($exception0);
        return $message;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\DateTimeSpanType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        // validation for constraint: union(duration, NightDurationType)
        if ('' !== ($durationUnionErrorMessage = self::validateDurationForUnionConstraintsFromSetDuration($duration))) {
            throw new \InvalidArgumentException($durationUnionErrorMessage, __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * This method is responsible for validating the value passed to the setEnd method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEnd method
     * This is a set of validation rules based on the union types associated to the property being set by the setEnd method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEndForUnionConstraintsFromSetEnd($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\DateTimeSpanType
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($endUnionErrorMessage = self::validateEndForUnionConstraintsFromSetEnd($end))) {
            throw new \InvalidArgumentException($endUnionErrorMessage, __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DateTimeSpanType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
