<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerPrimaryAdditionalType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information on the one primary driver and, optionally, several additional drivers. This may be used to provide a frequent renter number.
 * @subpackage Structs
 */
class CustomerPrimaryAdditionalType extends AbstractStructBase
{
    /**
     * The Primary
     * @var \StructType\Primary
     */
    public $Primary;
    /**
     * The Additional
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\Additional[]
     */
    public $Additional;
    /**
     * Constructor method for CustomerPrimaryAdditionalType
     * @uses CustomerPrimaryAdditionalType::setPrimary()
     * @uses CustomerPrimaryAdditionalType::setAdditional()
     * @param \StructType\Primary $primary
     * @param \StructType\Additional[] $additional
     */
    public function __construct(\StructType\Primary $primary = null, array $additional = array())
    {
        $this
            ->setPrimary($primary)
            ->setAdditional($additional);
    }
    /**
     * Get Primary value
     * @return \StructType\Primary|null
     */
    public function getPrimary()
    {
        return $this->Primary;
    }
    /**
     * Set Primary value
     * @param \StructType\Primary $primary
     * @return \StructType\CustomerPrimaryAdditionalType
     */
    public function setPrimary(\StructType\Primary $primary = null)
    {
        $this->Primary = $primary;
        return $this;
    }
    /**
     * Get Additional value
     * @return \StructType\Additional[]|null
     */
    public function getAdditional()
    {
        return $this->Additional;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditional method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditional method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalForArrayConstraintsFromSetAdditional(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerPrimaryAdditionalTypeAdditionalItem) {
            // validation for constraint: itemType
            if (!$customerPrimaryAdditionalTypeAdditionalItem instanceof \StructType\Additional) {
                $invalidValues[] = is_object($customerPrimaryAdditionalTypeAdditionalItem) ? get_class($customerPrimaryAdditionalTypeAdditionalItem) : sprintf('%s(%s)', gettype($customerPrimaryAdditionalTypeAdditionalItem), var_export($customerPrimaryAdditionalTypeAdditionalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Additional property can only contain items of type \StructType\Additional, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Additional value
     * @throws \InvalidArgumentException
     * @param \StructType\Additional[] $additional
     * @return \StructType\CustomerPrimaryAdditionalType
     */
    public function setAdditional(array $additional = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalArrayErrorMessage = self::validateAdditionalForArrayConstraintsFromSetAdditional($additional))) {
            throw new \InvalidArgumentException($additionalArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($additional) && count($additional) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($additional)), __LINE__);
        }
        $this->Additional = $additional;
        return $this;
    }
    /**
     * Add item to Additional value
     * @throws \InvalidArgumentException
     * @param \StructType\Additional $item
     * @return \StructType\CustomerPrimaryAdditionalType
     */
    public function addToAdditional(\StructType\Additional $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Additional) {
            throw new \InvalidArgumentException(sprintf('The Additional property can only contain items of type \StructType\Additional, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->Additional) && count($this->Additional) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->Additional)), __LINE__);
        }
        $this->Additional[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerPrimaryAdditionalType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
