<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustLoyalty StructType
 * Meta information extracted from the WSDL
 * - documentation: Details of the customer loyalty membership. | Loyalty program information. | Customer loyalty information. | Customer loyalty information used for additional authorization checks. | Program rewarding frequent use by accumulating
 * credits for services provided by vendors. | Loyalty program information for the customer. | Identifies the loyalty program(s) that the customer belongs to and associated information.
 * @subpackage Structs
 */
class CustLoyalty extends AbstractStructBase
{
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - documentation: A remark associated with the customer's loyalty program. | Used for Character Strings, length 1 to 128.
     * - base: xs:string
     * - maxLength: 128
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $Remark;
    /**
     * The ProgramID
     * Meta information extracted from the WSDL
     * - documentation: Identifier to indicate the company owner of the loyalty program. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * @var string
     */
    public $ProgramID;
    /**
     * The MembershipID
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier of the member in the program (membership number, account number, etc.). | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * @var string
     */
    public $MembershipID;
    /**
     * The TravelSector
     * Meta information extracted from the WSDL
     * - documentation: Identifies the travel sector. Refer to OpenTravel Code List Travel Sector (TVS). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $TravelSector;
    /**
     * The SingleVendorInd
     * @var string
     */
    public $SingleVendorInd;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: A reference placeholder for this loyalty membership. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients to particular
     * itinerary items).
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - type: RPH_Type
     * @var string
     */
    public $RPH;
    /**
     * The VendorCode
     * Meta information extracted from the WSDL
     * - documentation: Indicate the partner(s)/vendor(s) for which the customer loyalty number is valid. | Used for Character Strings, length 1 to 8. | List of StringLength1to8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - type: ListOfStringLength1to8
     * - use: optional
     * @var string[]
     */
    public $VendorCode;
    /**
     * The PrimaryLoyaltyIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates this is the primary customer loyalty program and when false, indicates this is not the primary customer loyalty program.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $PrimaryLoyaltyIndicator;
    /**
     * The AllianceLoyaltyLevelName
     * Meta information extracted from the WSDL
     * - documentation: Name of the alliance loyalty level (e.g.,OneWorld uses Emerald, Ruby, etc and SkyTeam uses Elite, etc.) | Used for Character Strings, length 1 to 128.
     * - base: xs:string
     * - maxLength: 128
     * - minLength: 1
     * - type: StringLength1to128
     * - use: optional
     * @var string
     */
    public $AllianceLoyaltyLevelName;
    /**
     * The CustomerType
     * Meta information extracted from the WSDL
     * - documentation: Original assessment of the customer by the travel agent. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - type: StringLength1to8
     * - use: optional
     * @var string
     */
    public $CustomerType;
    /**
     * The CustomerValue
     * Meta information extracted from the WSDL
     * - documentation: The supplier's ranking of the customer (e.g., VIP, numerical ranking). | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - type: StringLength1to8
     * - use: optional
     * @var string
     */
    public $CustomerValue;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The LoyalLevel
     * Meta information extracted from the WSDL
     * - documentation: Indicates special privileges in program assigned to individual. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $LoyalLevel;
    /**
     * The LoyalLevelCode
     * Meta information extracted from the WSDL
     * - documentation: Provides a numeric code assigned to a particular loyalty level. | Used for Numeric values, from 1 to 3 inclusive.
     * - base: xs:integer
     * - maxInclusive: 3
     * - minInclusive: 1
     * - type: Numeric1to3
     * - use: optional
     * @var int
     */
    public $LoyalLevelCode;
    /**
     * The SignupDate
     * Meta information extracted from the WSDL
     * - documentation: Indicates when the member signed up for the loyalty program.
     * - type: xs:date
     * - use: optional
     * @var string
     */
    public $SignupDate;
    /**
     * The EffectiveDate
     * Meta information extracted from the WSDL
     * - documentation: Indicates the starting date.
     * - type: xs:date
     * - use: optional
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * Meta information extracted from the WSDL
     * - documentation: Indicates the ending date.
     * - type: xs:date
     * - use: optional
     * @var string
     */
    public $ExpireDate;
    /**
     * The ExpireDateExclusiveIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates that the ExpireDate is the first day after the applicable period (e.g. when expire date is Oct 15 the last date of the period is Oct 14).
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $ExpireDateExclusiveIndicator;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - documentation: Indicates the required modification to the element.
     * - use: optional
     * @var string
     */
    public $Operation;
    /**
     * Constructor method for CustLoyalty
     * @uses CustLoyalty::setRemark()
     * @uses CustLoyalty::setProgramID()
     * @uses CustLoyalty::setMembershipID()
     * @uses CustLoyalty::setTravelSector()
     * @uses CustLoyalty::setSingleVendorInd()
     * @uses CustLoyalty::setRPH()
     * @uses CustLoyalty::setVendorCode()
     * @uses CustLoyalty::setPrimaryLoyaltyIndicator()
     * @uses CustLoyalty::setAllianceLoyaltyLevelName()
     * @uses CustLoyalty::setCustomerType()
     * @uses CustLoyalty::setCustomerValue()
     * @uses CustLoyalty::setShareSynchInd()
     * @uses CustLoyalty::setShareMarketInd()
     * @uses CustLoyalty::setLoyalLevel()
     * @uses CustLoyalty::setLoyalLevelCode()
     * @uses CustLoyalty::setSignupDate()
     * @uses CustLoyalty::setEffectiveDate()
     * @uses CustLoyalty::setExpireDate()
     * @uses CustLoyalty::setExpireDateExclusiveIndicator()
     * @uses CustLoyalty::setOperation()
     * @param string $remark
     * @param string $programID
     * @param string $membershipID
     * @param string $travelSector
     * @param string $singleVendorInd
     * @param string $rPH
     * @param string[] $vendorCode
     * @param bool $primaryLoyaltyIndicator
     * @param string $allianceLoyaltyLevelName
     * @param string $customerType
     * @param string $customerValue
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $loyalLevel
     * @param int $loyalLevelCode
     * @param string $signupDate
     * @param string $effectiveDate
     * @param string $expireDate
     * @param bool $expireDateExclusiveIndicator
     * @param string $operation
     */
    public function __construct($remark = null, $programID = null, $membershipID = null, $travelSector = null, $singleVendorInd = null, $rPH = null, array $vendorCode = array(), $primaryLoyaltyIndicator = null, $allianceLoyaltyLevelName = null, $customerType = null, $customerValue = null, $shareSynchInd = null, $shareMarketInd = null, $loyalLevel = null, $loyalLevelCode = null, $signupDate = null, $effectiveDate = null, $expireDate = null, $expireDateExclusiveIndicator = null, $operation = null)
    {
        $this
            ->setRemark($remark)
            ->setProgramID($programID)
            ->setMembershipID($membershipID)
            ->setTravelSector($travelSector)
            ->setSingleVendorInd($singleVendorInd)
            ->setRPH($rPH)
            ->setVendorCode($vendorCode)
            ->setPrimaryLoyaltyIndicator($primaryLoyaltyIndicator)
            ->setAllianceLoyaltyLevelName($allianceLoyaltyLevelName)
            ->setCustomerType($customerType)
            ->setCustomerValue($customerValue)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setLoyalLevel($loyalLevel)
            ->setLoyalLevelCode($loyalLevelCode)
            ->setSignupDate($signupDate)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setExpireDateExclusiveIndicator($expireDateExclusiveIndicator)
            ->setOperation($operation);
    }
    /**
     * Get Remark value
     * @return string|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @param string $remark
     * @return \StructType\CustLoyalty
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($remark) && mb_strlen($remark) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($remark)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($remark) && mb_strlen($remark) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($remark)), __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Get ProgramID value
     * @return string|null
     */
    public function getProgramID()
    {
        return $this->ProgramID;
    }
    /**
     * Set ProgramID value
     * @param string $programID
     * @return \StructType\CustLoyalty
     */
    public function setProgramID($programID = null)
    {
        // validation for constraint: string
        if (!is_null($programID) && !is_string($programID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programID, true), gettype($programID)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($programID) && mb_strlen($programID) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($programID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($programID) && mb_strlen($programID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($programID)), __LINE__);
        }
        $this->ProgramID = $programID;
        return $this;
    }
    /**
     * Get MembershipID value
     * @return string|null
     */
    public function getMembershipID()
    {
        return $this->MembershipID;
    }
    /**
     * Set MembershipID value
     * @param string $membershipID
     * @return \StructType\CustLoyalty
     */
    public function setMembershipID($membershipID = null)
    {
        // validation for constraint: string
        if (!is_null($membershipID) && !is_string($membershipID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipID, true), gettype($membershipID)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($membershipID) && mb_strlen($membershipID) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($membershipID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($membershipID) && mb_strlen($membershipID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($membershipID)), __LINE__);
        }
        $this->MembershipID = $membershipID;
        return $this;
    }
    /**
     * Get TravelSector value
     * @return string|null
     */
    public function getTravelSector()
    {
        return $this->TravelSector;
    }
    /**
     * Set TravelSector value
     * @param string $travelSector
     * @return \StructType\CustLoyalty
     */
    public function setTravelSector($travelSector = null)
    {
        // validation for constraint: string
        if (!is_null($travelSector) && !is_string($travelSector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelSector, true), gettype($travelSector)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($travelSector) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $travelSector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($travelSector, true)), __LINE__);
        }
        $this->TravelSector = $travelSector;
        return $this;
    }
    /**
     * Get SingleVendorInd value
     * @return string|null
     */
    public function getSingleVendorInd()
    {
        return $this->SingleVendorInd;
    }
    /**
     * Set SingleVendorInd value
     * @param string $singleVendorInd
     * @return \StructType\CustLoyalty
     */
    public function setSingleVendorInd($singleVendorInd = null)
    {
        // validation for constraint: string
        if (!is_null($singleVendorInd) && !is_string($singleVendorInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($singleVendorInd, true), gettype($singleVendorInd)), __LINE__);
        }
        $this->SingleVendorInd = $singleVendorInd;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\CustLoyalty
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($rPH) && !preg_match('/[0-9]{1,8}/', $rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($rPH, true)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get VendorCode value
     * @return string[]|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * This method is responsible for validating the values passed to the setVendorCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVendorCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVendorCodeForArrayConstraintsFromSetVendorCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $custLoyaltyVendorCodeItem) {
            // validation for constraint: itemType
            if (!is_string($custLoyaltyVendorCodeItem)) {
                $invalidValues[] = is_object($custLoyaltyVendorCodeItem) ? get_class($custLoyaltyVendorCodeItem) : sprintf('%s(%s)', gettype($custLoyaltyVendorCodeItem), var_export($custLoyaltyVendorCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VendorCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VendorCode value
     * @param string[] $vendorCode
     * @return \StructType\CustLoyalty
     */
    public function setVendorCode(array $vendorCode = array())
    {
        // validation for constraint: list
        if ('' !== ($vendorCodeArrayErrorMessage = self::validateVendorCodeForArrayConstraintsFromSetVendorCode($vendorCode))) {
            throw new \InvalidArgumentException($vendorCodeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($vendorCode) && mb_strlen($vendorCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($vendorCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($vendorCode) && mb_strlen($vendorCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($vendorCode)), __LINE__);
        }
        $this->VendorCode = is_array($vendorCode) ? implode(' ', $vendorCode) : null;
        return $this;
    }
    /**
     * Get PrimaryLoyaltyIndicator value
     * @return bool|null
     */
    public function getPrimaryLoyaltyIndicator()
    {
        return $this->PrimaryLoyaltyIndicator;
    }
    /**
     * Set PrimaryLoyaltyIndicator value
     * @param bool $primaryLoyaltyIndicator
     * @return \StructType\CustLoyalty
     */
    public function setPrimaryLoyaltyIndicator($primaryLoyaltyIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($primaryLoyaltyIndicator) && !is_bool($primaryLoyaltyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($primaryLoyaltyIndicator, true), gettype($primaryLoyaltyIndicator)), __LINE__);
        }
        $this->PrimaryLoyaltyIndicator = $primaryLoyaltyIndicator;
        return $this;
    }
    /**
     * Get AllianceLoyaltyLevelName value
     * @return string|null
     */
    public function getAllianceLoyaltyLevelName()
    {
        return $this->AllianceLoyaltyLevelName;
    }
    /**
     * Set AllianceLoyaltyLevelName value
     * @param string $allianceLoyaltyLevelName
     * @return \StructType\CustLoyalty
     */
    public function setAllianceLoyaltyLevelName($allianceLoyaltyLevelName = null)
    {
        // validation for constraint: string
        if (!is_null($allianceLoyaltyLevelName) && !is_string($allianceLoyaltyLevelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allianceLoyaltyLevelName, true), gettype($allianceLoyaltyLevelName)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($allianceLoyaltyLevelName) && mb_strlen($allianceLoyaltyLevelName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($allianceLoyaltyLevelName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($allianceLoyaltyLevelName) && mb_strlen($allianceLoyaltyLevelName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($allianceLoyaltyLevelName)), __LINE__);
        }
        $this->AllianceLoyaltyLevelName = $allianceLoyaltyLevelName;
        return $this;
    }
    /**
     * Get CustomerType value
     * @return string|null
     */
    public function getCustomerType()
    {
        return $this->CustomerType;
    }
    /**
     * Set CustomerType value
     * @param string $customerType
     * @return \StructType\CustLoyalty
     */
    public function setCustomerType($customerType = null)
    {
        // validation for constraint: string
        if (!is_null($customerType) && !is_string($customerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerType, true), gettype($customerType)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($customerType) && mb_strlen($customerType) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($customerType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($customerType) && mb_strlen($customerType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($customerType)), __LINE__);
        }
        $this->CustomerType = $customerType;
        return $this;
    }
    /**
     * Get CustomerValue value
     * @return string|null
     */
    public function getCustomerValue()
    {
        return $this->CustomerValue;
    }
    /**
     * Set CustomerValue value
     * @param string $customerValue
     * @return \StructType\CustLoyalty
     */
    public function setCustomerValue($customerValue = null)
    {
        // validation for constraint: string
        if (!is_null($customerValue) && !is_string($customerValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerValue, true), gettype($customerValue)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($customerValue) && mb_strlen($customerValue) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($customerValue)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($customerValue) && mb_strlen($customerValue) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($customerValue)), __LINE__);
        }
        $this->CustomerValue = $customerValue;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \StructType\CustLoyalty
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\CustLoyalty
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get LoyalLevel value
     * @return string|null
     */
    public function getLoyalLevel()
    {
        return $this->LoyalLevel;
    }
    /**
     * Set LoyalLevel value
     * @param string $loyalLevel
     * @return \StructType\CustLoyalty
     */
    public function setLoyalLevel($loyalLevel = null)
    {
        // validation for constraint: string
        if (!is_null($loyalLevel) && !is_string($loyalLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loyalLevel, true), gettype($loyalLevel)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($loyalLevel) && mb_strlen($loyalLevel) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($loyalLevel)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($loyalLevel) && mb_strlen($loyalLevel) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($loyalLevel)), __LINE__);
        }
        $this->LoyalLevel = $loyalLevel;
        return $this;
    }
    /**
     * Get LoyalLevelCode value
     * @return int|null
     */
    public function getLoyalLevelCode()
    {
        return $this->LoyalLevelCode;
    }
    /**
     * Set LoyalLevelCode value
     * @param int $loyalLevelCode
     * @return \StructType\CustLoyalty
     */
    public function setLoyalLevelCode($loyalLevelCode = null)
    {
        // validation for constraint: int
        if (!is_null($loyalLevelCode) && !(is_int($loyalLevelCode) || ctype_digit($loyalLevelCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($loyalLevelCode, true), gettype($loyalLevelCode)), __LINE__);
        }
        // validation for constraint: maxInclusive(3)
        if (!is_null($loyalLevelCode) && $loyalLevelCode > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 3', var_export($loyalLevelCode, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($loyalLevelCode) && $loyalLevelCode < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($loyalLevelCode, true)), __LINE__);
        }
        $this->LoyalLevelCode = $loyalLevelCode;
        return $this;
    }
    /**
     * Get SignupDate value
     * @return string|null
     */
    public function getSignupDate()
    {
        return $this->SignupDate;
    }
    /**
     * Set SignupDate value
     * @param string $signupDate
     * @return \StructType\CustLoyalty
     */
    public function setSignupDate($signupDate = null)
    {
        // validation for constraint: string
        if (!is_null($signupDate) && !is_string($signupDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signupDate, true), gettype($signupDate)), __LINE__);
        }
        $this->SignupDate = $signupDate;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\CustLoyalty
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\CustLoyalty
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get ExpireDateExclusiveIndicator value
     * @return bool|null
     */
    public function getExpireDateExclusiveIndicator()
    {
        return $this->ExpireDateExclusiveIndicator;
    }
    /**
     * Set ExpireDateExclusiveIndicator value
     * @param bool $expireDateExclusiveIndicator
     * @return \StructType\CustLoyalty
     */
    public function setExpireDateExclusiveIndicator($expireDateExclusiveIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($expireDateExclusiveIndicator) && !is_bool($expireDateExclusiveIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expireDateExclusiveIndicator, true), gettype($expireDateExclusiveIndicator)), __LINE__);
        }
        $this->ExpireDateExclusiveIndicator = $expireDateExclusiveIndicator;
        return $this;
    }
    /**
     * Get Operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \StructType\CustLoyalty
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActionType', is_array($operation) ? implode(', ', $operation) : var_export($operation, true), implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustLoyalty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
