<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CurrencyConversions StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of currency conversion elements.
 * @subpackage Structs
 */
class CurrencyConversions extends AbstractStructBase
{
    /**
     * The CurrencyConversion
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\CurrencyConversion[]
     */
    public $CurrencyConversion;
    /**
     * Constructor method for CurrencyConversions
     * @uses CurrencyConversions::setCurrencyConversion()
     * @param \StructType\CurrencyConversion[] $currencyConversion
     */
    public function __construct(array $currencyConversion = array())
    {
        $this
            ->setCurrencyConversion($currencyConversion);
    }
    /**
     * Get CurrencyConversion value
     * @return \StructType\CurrencyConversion[]|null
     */
    public function getCurrencyConversion()
    {
        return $this->CurrencyConversion;
    }
    /**
     * This method is responsible for validating the values passed to the setCurrencyConversion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurrencyConversion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCurrencyConversionForArrayConstraintsFromSetCurrencyConversion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $currencyConversionsCurrencyConversionItem) {
            // validation for constraint: itemType
            if (!$currencyConversionsCurrencyConversionItem instanceof \StructType\CurrencyConversion) {
                $invalidValues[] = is_object($currencyConversionsCurrencyConversionItem) ? get_class($currencyConversionsCurrencyConversionItem) : sprintf('%s(%s)', gettype($currencyConversionsCurrencyConversionItem), var_export($currencyConversionsCurrencyConversionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CurrencyConversion property can only contain items of type \StructType\CurrencyConversion, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CurrencyConversion value
     * @throws \InvalidArgumentException
     * @param \StructType\CurrencyConversion[] $currencyConversion
     * @return \StructType\CurrencyConversions
     */
    public function setCurrencyConversion(array $currencyConversion = array())
    {
        // validation for constraint: array
        if ('' !== ($currencyConversionArrayErrorMessage = self::validateCurrencyConversionForArrayConstraintsFromSetCurrencyConversion($currencyConversion))) {
            throw new \InvalidArgumentException($currencyConversionArrayErrorMessage, __LINE__);
        }
        $this->CurrencyConversion = $currencyConversion;
        return $this;
    }
    /**
     * Add item to CurrencyConversion value
     * @throws \InvalidArgumentException
     * @param \StructType\CurrencyConversion $item
     * @return \StructType\CurrencyConversions
     */
    public function addToCurrencyConversion(\StructType\CurrencyConversion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CurrencyConversion) {
            throw new \InvalidArgumentException(sprintf('The CurrencyConversion property can only contain items of type \StructType\CurrencyConversion, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CurrencyConversion[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CurrencyConversions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
