<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CurrencyConversion StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides a rate conversion from one currency to another.
 * @subpackage Structs
 */
class CurrencyConversion extends AbstractStructBase
{
    /**
     * The RateConversion
     * Meta information extracted from the WSDL
     * - documentation: The conversion factor to apply against the source currency to obtain the requested currency.
     * - use: optional
     * @var float
     */
    public $RateConversion;
    /**
     * The SourceCurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: The code specifying the source currency (use ISO 4217, three alpha code). | Used for an Alpha String, length exactly 3.
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * - use: optional
     * @var string
     */
    public $SourceCurrencyCode;
    /**
     * The RequestedCurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: The code specifying the requested currency (use ISO 4217, three alpha code). | Used for an Alpha String, length exactly 3.
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * - use: optional
     * @var string
     */
    public $RequestedCurrencyCode;
    /**
     * The DecimalPlaces
     * Meta information extracted from the WSDL
     * - documentation: Indicates the number of decimal places for the requested currency. This is equivalent to the ISO 4217 standard "minor unit".
     * - use: optional
     * @var int
     */
    public $DecimalPlaces;
    /**
     * The Source
     * Meta information extracted from the WSDL
     * - documentation: The source of the rate conversion information. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $Source;
    /**
     * Constructor method for CurrencyConversion
     * @uses CurrencyConversion::setRateConversion()
     * @uses CurrencyConversion::setSourceCurrencyCode()
     * @uses CurrencyConversion::setRequestedCurrencyCode()
     * @uses CurrencyConversion::setDecimalPlaces()
     * @uses CurrencyConversion::setSource()
     * @param float $rateConversion
     * @param string $sourceCurrencyCode
     * @param string $requestedCurrencyCode
     * @param int $decimalPlaces
     * @param string $source
     */
    public function __construct($rateConversion = null, $sourceCurrencyCode = null, $requestedCurrencyCode = null, $decimalPlaces = null, $source = null)
    {
        $this
            ->setRateConversion($rateConversion)
            ->setSourceCurrencyCode($sourceCurrencyCode)
            ->setRequestedCurrencyCode($requestedCurrencyCode)
            ->setDecimalPlaces($decimalPlaces)
            ->setSource($source);
    }
    /**
     * Get RateConversion value
     * @return float|null
     */
    public function getRateConversion()
    {
        return $this->RateConversion;
    }
    /**
     * Set RateConversion value
     * @param float $rateConversion
     * @return \StructType\CurrencyConversion
     */
    public function setRateConversion($rateConversion = null)
    {
        // validation for constraint: float
        if (!is_null($rateConversion) && !(is_float($rateConversion) || is_numeric($rateConversion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rateConversion, true), gettype($rateConversion)), __LINE__);
        }
        $this->RateConversion = $rateConversion;
        return $this;
    }
    /**
     * Get SourceCurrencyCode value
     * @return string|null
     */
    public function getSourceCurrencyCode()
    {
        return $this->SourceCurrencyCode;
    }
    /**
     * Set SourceCurrencyCode value
     * @param string $sourceCurrencyCode
     * @return \StructType\CurrencyConversion
     */
    public function setSourceCurrencyCode($sourceCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($sourceCurrencyCode) && !is_string($sourceCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceCurrencyCode, true), gettype($sourceCurrencyCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{3})
        if (!is_null($sourceCurrencyCode) && !preg_match('/[a-zA-Z]{3}/', $sourceCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{3}', var_export($sourceCurrencyCode, true)), __LINE__);
        }
        $this->SourceCurrencyCode = $sourceCurrencyCode;
        return $this;
    }
    /**
     * Get RequestedCurrencyCode value
     * @return string|null
     */
    public function getRequestedCurrencyCode()
    {
        return $this->RequestedCurrencyCode;
    }
    /**
     * Set RequestedCurrencyCode value
     * @param string $requestedCurrencyCode
     * @return \StructType\CurrencyConversion
     */
    public function setRequestedCurrencyCode($requestedCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($requestedCurrencyCode) && !is_string($requestedCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestedCurrencyCode, true), gettype($requestedCurrencyCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{3})
        if (!is_null($requestedCurrencyCode) && !preg_match('/[a-zA-Z]{3}/', $requestedCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{3}', var_export($requestedCurrencyCode, true)), __LINE__);
        }
        $this->RequestedCurrencyCode = $requestedCurrencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\CurrencyConversion
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Get Source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param string $source
     * @return \StructType\CurrencyConversion
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($source) && mb_strlen($source) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($source)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($source) && mb_strlen($source) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($source)), __LINE__);
        }
        $this->Source = $source;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CurrencyConversion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
