<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CuisineCodes StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of cuisine types of restaurant.
 * @subpackage Structs
 */
class CuisineCodes extends AbstractStructBase
{
    /**
     * The CuisineCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\CuisineCode[]
     */
    public $CuisineCode;
    /**
     * Constructor method for CuisineCodes
     * @uses CuisineCodes::setCuisineCode()
     * @param \StructType\CuisineCode[] $cuisineCode
     */
    public function __construct(array $cuisineCode = array())
    {
        $this
            ->setCuisineCode($cuisineCode);
    }
    /**
     * Get CuisineCode value
     * @return \StructType\CuisineCode[]|null
     */
    public function getCuisineCode()
    {
        return $this->CuisineCode;
    }
    /**
     * This method is responsible for validating the values passed to the setCuisineCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCuisineCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCuisineCodeForArrayConstraintsFromSetCuisineCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cuisineCodesCuisineCodeItem) {
            // validation for constraint: itemType
            if (!$cuisineCodesCuisineCodeItem instanceof \StructType\CuisineCode) {
                $invalidValues[] = is_object($cuisineCodesCuisineCodeItem) ? get_class($cuisineCodesCuisineCodeItem) : sprintf('%s(%s)', gettype($cuisineCodesCuisineCodeItem), var_export($cuisineCodesCuisineCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CuisineCode property can only contain items of type \StructType\CuisineCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CuisineCode value
     * @throws \InvalidArgumentException
     * @param \StructType\CuisineCode[] $cuisineCode
     * @return \StructType\CuisineCodes
     */
    public function setCuisineCode(array $cuisineCode = array())
    {
        // validation for constraint: array
        if ('' !== ($cuisineCodeArrayErrorMessage = self::validateCuisineCodeForArrayConstraintsFromSetCuisineCode($cuisineCode))) {
            throw new \InvalidArgumentException($cuisineCodeArrayErrorMessage, __LINE__);
        }
        $this->CuisineCode = $cuisineCode;
        return $this;
    }
    /**
     * Add item to CuisineCode value
     * @throws \InvalidArgumentException
     * @param \StructType\CuisineCode $item
     * @return \StructType\CuisineCodes
     */
    public function addToCuisineCode(\StructType\CuisineCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CuisineCode) {
            throw new \InvalidArgumentException(sprintf('The CuisineCode property can only contain items of type \StructType\CuisineCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CuisineCode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CuisineCodes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
